/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.rng;

import java.util.List;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.rng.NativeRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaNativeRandom
extends NativeRandom {
    private static final Logger log = LoggerFactory.getLogger(CudaNativeRandom.class);
    protected List<DataBuffer> stateBuffers;

    public CudaNativeRandom() {
        this(System.currentTimeMillis());
    }

    public CudaNativeRandom(long seed) {
        this(seed, 10000000L);
    }

    public CudaNativeRandom(long seed, long numberOfElements) {
        super(seed, numberOfElements);
    }

    public void init() {
        this.statePointer = this.nativeOps.initRandom(this.getExtraPointers(), this.seed, this.numberOfElements, AtomicAllocator.getInstance().getPointer(this.stateBuffer));
        AtomicAllocator.getInstance().getAllocationPoint(this.stateBuffer).tickDeviceWrite();
    }

    public PointerPointer getExtraPointers() {
        PointerPointer ptr = new PointerPointer(4L);
        CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
        ptr.put(0L, AtomicAllocator.getInstance().getHostPointer(this.stateBuffer));
        ptr.put(1L, (Pointer)context.getOldStream());
        return ptr;
    }
}

