/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.jita.allocator.concurrency.AtomicState;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.time.RateTimer;
import org.nd4j.jita.allocator.time.impl.BinaryTimer;

public class NestedPoint {
    @NonNull
    private AllocationShape shape;
    @NonNull
    private AtomicState accessState;
    private AtomicLong accessTime;
    private RateTimer timerShort = new BinaryTimer(10L, TimeUnit.SECONDS);
    private RateTimer timerLong = new BinaryTimer(60L, TimeUnit.SECONDS);
    private AllocationStatus nestedStatus = AllocationStatus.UNDEFINED;
    private AtomicLong counter = new AtomicLong(0L);

    public NestedPoint(@NonNull AllocationShape shape) {
        if (shape == null) {
            throw new NullPointerException("shape");
        }
        this.shape = shape;
    }

    public long getTicks() {
        return this.counter.get();
    }

    public void tick() {
        this.accessTime.set(System.nanoTime());
        this.counter.incrementAndGet();
    }

    public void tack() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedPoint that = (NestedPoint)o;
        return this.shape != null ? this.shape.equals(that.shape) : that.shape == null;
    }

    public int hashCode() {
        return this.shape != null ? this.shape.hashCode() : 0;
    }

    public NestedPoint() {
    }

    @NonNull
    public AllocationShape getShape() {
        return this.shape;
    }

    public void setShape(@NonNull AllocationShape shape) {
        if (shape == null) {
            throw new NullPointerException("shape");
        }
        this.shape = shape;
    }

    @NonNull
    public AtomicState getAccessState() {
        return this.accessState;
    }

    public void setAccessState(@NonNull AtomicState accessState) {
        if (accessState == null) {
            throw new NullPointerException("accessState");
        }
        this.accessState = accessState;
    }

    public RateTimer getTimerShort() {
        return this.timerShort;
    }

    public RateTimer getTimerLong() {
        return this.timerLong;
    }

    public AllocationStatus getNestedStatus() {
        return this.nestedStatus;
    }

    public void setNestedStatus(AllocationStatus nestedStatus) {
        this.nestedStatus = nestedStatus;
    }
}

