/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.constant;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.conf.Configuration;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.jita.constant.ConstantProtector;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedCudaShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(ProtectedCudaShapeInfoProvider.class);
    private AtomicAllocator allocator;
    private AtomicLong cacheHit = new AtomicLong(1L);
    private AtomicLong cacheMiss = new AtomicLong(1L);
    private Semaphore lock = new Semaphore(1);
    private Configuration configuration = CudaEnvironment.getInstance().getConfiguration();
    protected static final ConstantProtector protector = ConstantProtector.getInstance();
    private static ProtectedCudaShapeInfoProvider ourInstance = new ProtectedCudaShapeInfoProvider();

    private ProtectedCudaShapeInfoProvider() {
    }

    public void purgeCache() {
        protector.purgeProtector();
    }

    public static ProtectedCudaShapeInfoProvider getInstance() {
        return ourInstance;
    }

    public DataBuffer createShapeInformation(int[] shape, int[] stride, int offset, int elementWiseStride, char order) {
        offset = 0;
        Integer deviceId = AtomicAllocator.getInstance().getDeviceId();
        ShapeDescriptor descriptor = new ShapeDescriptor(shape, stride, offset, elementWiseStride, order);
        if (!protector.containsDataBuffer(deviceId, descriptor)) {
            DataBuffer buffer = super.createShapeInformation(shape, stride, offset, elementWiseStride, order);
            buffer.setConstant(true);
            if (this.configuration.getMemoryModel() == Configuration.MemoryModel.IMMEDIATE) {
                Nd4j.getConstantHandler().moveToConstantSpace(buffer);
            }
            protector.persistDataBuffer(deviceId, descriptor, buffer);
            this.cacheMiss.incrementAndGet();
            return buffer;
        }
        this.cacheHit.incrementAndGet();
        return protector.getDataBuffer(deviceId, descriptor);
    }
}

