/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.cublas;
import org.bytedeco.javacpp.cuda;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.blas.impl.BaseLevel3;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.factory.DataTypeValidation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.blas.CudaBlas;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLevel3
extends BaseLevel3 {
    private Allocator allocator = AtomicAllocator.getInstance();
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger logger = LoggerFactory.getLogger(JcublasLevel3.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(B, ctx);
        CublasPointer cCPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            int arch = CudaEnvironment.getInstance().getCurrentDeviceArchitecture();
            if (arch == 53 || arch == 60) {
                cublas.cublasHgemm((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (cuda.__half)new cuda.__half().x((short)HalfIndexer.fromFloat((float)alpha)), (cuda.__half)new cuda.__half(cAPointer.getDevicePointer()), (int)lda, (cuda.__half)new cuda.__half(cBPointer.getDevicePointer()), (int)ldb, (cuda.__half)new cuda.__half().x((short)HalfIndexer.fromFloat((float)beta)), (cuda.__half)new cuda.__half(cCPointer.getDevicePointer()), (int)ldc);
            } else {
                cublas.cublasSgemmEx((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (FloatPointer)new FloatPointer(new float[]{alpha}), (Pointer)((ShortPointer)cAPointer.getDevicePointer()), (int)2, (int)lda, (Pointer)((ShortPointer)cBPointer.getDevicePointer()), (int)2, (int)ldb, (FloatPointer)new FloatPointer(new float[]{beta}), (Pointer)((ShortPointer)cCPointer.getDevicePointer()), (int)2, (int)ldc);
            }
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT gemm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(B, ctx);
        CublasPointer cCPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasSgemm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)cAPointer.getDevicePointer()), (int)lda, (FloatPointer)((FloatPointer)cBPointer.getDevicePointer()), (int)ldb, (FloatPointer)new FloatPointer(new float[]{beta}), (FloatPointer)((FloatPointer)cCPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ssymm(char Order, char Side, char Uplo, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT symm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasSsymm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertSideMode(Side), (int)CudaBlas.convertUplo(Uplo), (int)M, (int)N, (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)aPointer.getDevicePointer()), (int)lda, (FloatPointer)((FloatPointer)bPointer.getDevicePointer()), (int)ldb, (FloatPointer)new FloatPointer(new float[]{beta}), (FloatPointer)((FloatPointer)cPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ssyrk(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT syrk called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasSsyrk_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertUplo(Uplo), (int)CudaBlas.convertTranspose(Trans), (int)N, (int)K, (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)aPointer.getDevicePointer()), (int)lda, (FloatPointer)new FloatPointer(new float[]{beta}), (FloatPointer)((FloatPointer)cPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A);
    }

    protected void ssyr2k(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void strmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void strsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT trsm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasStrsm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertSideMode(Side), (int)CudaBlas.convertUplo(Uplo), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertDiag(Diag), (int)M, (int)N, (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)aPointer.getDevicePointer()), (int)lda, (FloatPointer)((FloatPointer)bPointer.getDevicePointer()), (int)ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dgemm(char Order, char TransA, char TransB, int M, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE gemm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        DataTypeValidation.assertDouble((INDArray[])new INDArray[]{A, B, C});
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(B, ctx);
        CublasPointer cCPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDgemm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertTranspose(TransB), (int)M, (int)N, (int)K, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)cAPointer.getDevicePointer()), (int)lda, (DoublePointer)((DoublePointer)cBPointer.getDevicePointer()), (int)ldb, (DoublePointer)new DoublePointer(new double[]{beta}), (DoublePointer)((DoublePointer)cCPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsymm(char Order, char Side, char Uplo, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE symm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDsymm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertSideMode(Side), (int)CudaBlas.convertUplo(Uplo), (int)M, (int)N, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)aPointer.getDevicePointer()), (int)lda, (DoublePointer)((DoublePointer)bPointer.getDevicePointer()), (int)ldb, (DoublePointer)new DoublePointer(new double[]{beta}), (DoublePointer)((DoublePointer)cPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsyrk(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE syrk called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDsyrk_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertUplo(Uplo), (int)Trans, (int)N, (int)K, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)aPointer.getDevicePointer()), (int)lda, (DoublePointer)new DoublePointer(new double[]{beta}), (DoublePointer)((DoublePointer)cPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsyr2k(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE syr2k called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDsyr2k_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertUplo(Uplo), (int)Trans, (int)N, (int)K, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)aPointer.getDevicePointer()), (int)lda, (DoublePointer)((DoublePointer)bPointer.getDevicePointer()), (int)ldb, (DoublePointer)new DoublePointer(new double[]{beta}), (DoublePointer)((DoublePointer)cPointer.getDevicePointer()), (int)ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dtrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE trmm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDtrmm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertSideMode(Side), (int)CudaBlas.convertUplo(Uplo), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertDiag(Diag), (int)M, (int)N, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)aPointer.getDevicePointer()), (int)lda, (DoublePointer)((DoublePointer)bPointer.getDevicePointer()), (int)ldb, (DoublePointer)((DoublePointer)bPointer.getDevicePointer()), (int)ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dtrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE trsm called");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDtrsm_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)CudaBlas.convertSideMode(Side), (int)CudaBlas.convertUplo(Uplo), (int)CudaBlas.convertTranspose(TransA), (int)CudaBlas.convertDiag(Diag), (int)M, (int)N, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)aPointer.getDevicePointer()), (int)lda, (DoublePointer)((DoublePointer)bPointer.getDevicePointer()), (int)ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    protected void cgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csymm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyrk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
    }

    protected void zgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsymm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyrk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void chemm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cherk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cher2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zhemm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zherk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zher2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }
}

