/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.memory;

import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.impl.AllocationPoint;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.jcublas.ops.executioner.CudaGridExecutioner;
import org.nd4j.linalg.memory.BasicMemoryManager;
import org.nd4j.linalg.memory.MemoryKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaMemoryManager
extends BasicMemoryManager {
    private static final Logger log = LoggerFactory.getLogger(CudaMemoryManager.class);

    public Pointer allocate(long bytes, MemoryKind kind, boolean initialize) {
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        if (kind == MemoryKind.HOST) {
            return allocator.getMemoryHandler().alloc(AllocationStatus.HOST, null, null, initialize).getHostPointer();
        }
        if (kind == MemoryKind.DEVICE) {
            return allocator.getMemoryHandler().alloc(AllocationStatus.HOST, null, null, initialize).getDevicePointer();
        }
        throw new RuntimeException("Unknown MemoryKind requested: " + kind);
    }

    public void collect(INDArray ... arrays) {
        ((CudaGridExecutioner)Nd4j.getExecutioner()).flushQueueBlocking();
        int cnt = -1;
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        for (INDArray array : arrays) {
            ++cnt;
            if (array == null || array.isView()) continue;
            AllocationPoint point = allocator.getAllocationPoint(array);
            if (point.getAllocationStatus() == AllocationStatus.HOST) {
                allocator.getMemoryHandler().free(point, AllocationStatus.HOST);
            } else if (point.getAllocationStatus() == AllocationStatus.DEVICE) {
                allocator.getMemoryHandler().free(point, AllocationStatus.DEVICE);
                allocator.getMemoryHandler().free(point, AllocationStatus.HOST);
            } else if (point.getAllocationStatus() != AllocationStatus.DEALLOCATED) {
                throw new RuntimeException("Unknown AllocationStatus: " + (Object)((Object)point.getAllocationStatus()) + " for argument: " + cnt);
            }
            point.setAllocationStatus(AllocationStatus.DEALLOCATED);
        }
    }

    public synchronized void purgeCaches() {
        AtomicAllocator.getInstance().getMemoryHandler().getMemoryProvider().purgeCache();
    }

    public void memcpy(DataBuffer dstBuffer, DataBuffer srcBuffer) {
        CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
        if (dstBuffer instanceof CompressedDataBuffer && !(srcBuffer instanceof CompressedDataBuffer)) {
            AllocationPoint srcPoint = AtomicAllocator.getInstance().getAllocationPoint(srcBuffer);
            long size = (long)srcBuffer.getElementSize() * srcBuffer.length();
            if (!srcPoint.isActualOnHostSide()) {
                AtomicAllocator.getInstance().synchronizeHostData(srcBuffer);
            }
            Pointer src = AtomicAllocator.getInstance().getHostPointer(srcBuffer);
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)src, (long)size);
        } else if (!(dstBuffer instanceof CompressedDataBuffer) && srcBuffer instanceof CompressedDataBuffer) {
            AllocationPoint dstPoint = AtomicAllocator.getInstance().getAllocationPoint(dstBuffer);
            long size = (long)srcBuffer.getElementSize() * srcBuffer.length();
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)srcBuffer.addressPointer(), (long)size);
            dstPoint.tickHostWrite();
        } else if (dstBuffer instanceof CompressedDataBuffer && srcBuffer instanceof CompressedDataBuffer) {
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)srcBuffer.addressPointer(), (long)(srcBuffer.length() * (long)srcBuffer.getElementSize()));
        } else {
            AtomicAllocator.getInstance().memcpy(dstBuffer, srcBuffer);
        }
    }

    public void setAutoGcWindow(int windowMillis) {
        super.setAutoGcWindow(windowMillis);
        CudaEnvironment.getInstance().getConfiguration().setNoGcWindowMs(windowMillis);
    }
}

