/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.linalg.util.ArrayUtil;

public class CudaFloatDataBuffer
extends BaseCudaDataBuffer {
    public CudaFloatDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaFloatDataBuffer(long length) {
        super(length, 4);
    }

    public CudaFloatDataBuffer(long length, boolean initialize) {
        super(length, 4, initialize);
    }

    public CudaFloatDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaFloatDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    protected void initTypeAndSize() {
        this.elementSize = 4;
        this.type = DataBuffer.Type.FLOAT;
    }

    public CudaFloatDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaFloatDataBuffer(float[] buffer) {
        super(buffer);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(float[] data, boolean copy, int offset) {
        super(data, copy, (long)offset);
    }

    public CudaFloatDataBuffer(double[] data) {
        super(data);
    }

    public CudaFloatDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(double[] data, boolean copy, int offset) {
        super(data, copy, (long)offset);
    }

    public CudaFloatDataBuffer(int[] data) {
        super(data);
    }

    public CudaFloatDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaFloatDataBuffer(int[] data, boolean copy, int offset) {
        super(data, copy, (long)offset);
    }

    public CudaFloatDataBuffer(byte[] data, long length) {
        super(data, length);
    }

    public CudaFloatDataBuffer(ByteBuffer buffer, long length) {
        super(buffer, (long)((int)length));
    }

    public CudaFloatDataBuffer(ByteBuffer buffer, long length, int offset) {
        super(buffer, length, (long)offset);
    }

    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (contiguous) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Only contiguous supported");
    }

    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (contiguous) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Only contiguous supported");
    }

    protected DataBuffer create(long length) {
        return new CudaFloatDataBuffer(length);
    }

    public double[] getDoublesAt(long offset, long inc, int length) {
        return ArrayUtil.toDoubles((float[])this.getFloatsAt(offset, inc, length));
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toFloats((int[])data));
    }

    @Override
    public void setData(double[] data) {
        this.setData(ArrayUtil.toFloats((double[])data));
    }

    @Override
    public byte[] asBytes() {
        float[] data = this.asFloat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i = 0; i < data.length; ++i) {
            try {
                dos.writeFloat(data[i]);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bos.toByteArray();
    }

    public DataBuffer.Type dataType() {
        return this.type;
    }

    @Override
    public double[] asDouble() {
        return ArrayUtil.toDoubles((float[])this.asFloat());
    }

    @Override
    public int[] asInt() {
        return ArrayUtil.toInts((float[])this.asFloat());
    }

    @Override
    public double getDouble(long i) {
        return super.getFloat(i);
    }

    public DataBuffer create(double[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaFloatDataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaFloatDataBuffer(data);
    }

    @Override
    public void flush() {
    }
}

