/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.conf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.conf.Configuration;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOpsHolder;

public class CudaEnvironment {
    private static final CudaEnvironment INSTANCE = new CudaEnvironment();
    private static volatile Configuration configuration;
    private static Map<Integer, Integer> arch;

    private CudaEnvironment() {
        configuration = new Configuration();
    }

    public static CudaEnvironment getInstance() {
        return INSTANCE;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public int getCurrentDeviceArchitecture() {
        int deviceId = Nd4j.getAffinityManager().getDeviceForCurrentThread();
        if (!arch.containsKey(deviceId)) {
            int major = NativeOpsHolder.getInstance().getDeviceNativeOps().getDeviceMajor((Pointer)new CudaPointer(deviceId));
            int minor = NativeOpsHolder.getInstance().getDeviceNativeOps().getDeviceMinor((Pointer)new CudaPointer(deviceId));
            Integer cc = Integer.parseInt(new String("" + major + minor));
            arch.put(deviceId, cc);
            return cc;
        }
        return arch.get(deviceId);
    }

    public void notifyConfigurationApplied() {
        configuration.updateDevice();
    }

    static {
        arch = new ConcurrentHashMap<Integer, Integer>();
    }
}

