/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.cublas;
import org.bytedeco.javacpp.cuda;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.linalg.api.blas.impl.BaseLevel1;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.api.ops.impl.accum.ASum;
import org.nd4j.linalg.api.ops.impl.accum.Dot;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.Axpy;
import org.nd4j.linalg.factory.DataTypeValidation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.jcublas.ops.executioner.CudaExecutioner;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLevel1
extends BaseLevel1 {
    private Allocator allocator = AtomicAllocator.getInstance();
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger logger = LoggerFactory.getLogger(JcublasLevel1.class);

    protected float sdsdot(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected double dsdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected float hdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        DataTypeValidation.assertSameDataType((INDArray[])new INDArray[]{X, Y});
        float ret = 1.0f;
        Dot dot = new Dot(X, Y);
        Nd4j.getExecutioner().exec((Op)dot);
        ret = dot.getFinalResult().floatValue();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float sdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT dot called");
        }
        DataTypeValidation.assertSameDataType((INDArray[])new INDArray[]{X, Y});
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X, Y);
        float ret = 1.0f;
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            long result = cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0L) {
                throw new IllegalStateException("cublasSetStream failed");
            }
            FloatPointer resultPointer = new FloatPointer(new float[]{0.0f});
            result = cublas.cublasSdot_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY, (FloatPointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X, Y);
        return ret;
    }

    protected float hdot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected float sdot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double ddot(int N, INDArray X, int incX, INDArray Y, int incY) {
        double ret;
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE dot called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X, Y);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            DoublePointer resultPointer = new DoublePointer(new double[]{0.0});
            cublas.cublasDdot_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY, (DoublePointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X, Y);
        return ret;
    }

    protected double ddot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void cdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void cdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    protected void zdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void zdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float snrm2(int N, INDArray X, int incX) {
        float ret;
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT nrm2 called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer cAPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            FloatPointer resultPointer = new FloatPointer(new float[]{0.0f});
            cublas.cublasSnrm2_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)((FloatPointer)cAPointer.getDevicePointer()), (int)incX, (FloatPointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret;
    }

    protected float hasum(int N, INDArray X, int incX) {
        ASum asum = new ASum(X);
        Nd4j.getExecutioner().exec((Accumulation)asum, new int[]{Integer.MAX_VALUE});
        float ret = asum.getFinalResult().floatValue();
        return ret;
    }

    protected float sasum(int N, INDArray X, int incX) {
        ASum asum = new ASum(X);
        Nd4j.getExecutioner().exec((Accumulation)asum, new int[]{Integer.MAX_VALUE});
        float ret = asum.getFinalResult().floatValue();
        return ret;
    }

    protected float hasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected float sasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double dnrm2(int N, INDArray X, int incX) {
        double ret;
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE nrm2 called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer cAPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            DoublePointer resultPointer = new DoublePointer(new double[]{0.0});
            cublas.cublasDnrm2_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)((DoublePointer)cAPointer.getDevicePointer()), (int)incX, (DoublePointer)resultPointer);
            ret = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret;
    }

    protected double dasum(int N, INDArray X, int incX) {
        ASum asum = new ASum(X);
        Nd4j.getExecutioner().exec((Accumulation)asum, new int[]{Integer.MAX_VALUE});
        double ret = asum.getFinalResult().doubleValue();
        return ret;
    }

    protected double dasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected float scnrm2(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float scasum(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dznrm2(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dzasum(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int isamax(int N, INDArray X, int incX) {
        int ret2;
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT iamax called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            IntPointer resultPointer = new IntPointer(new int[]{0});
            cublas.cublasIsamax_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (IntPointer)resultPointer);
            ret2 = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret2 - 1;
    }

    protected int isamax(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int idamax(int N, INDArray X, int incX) {
        int ret2;
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE imax called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(null, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            IntPointer resultPointer = new IntPointer(new int[]{0});
            cublas.cublasIdamax_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (IntPointer)resultPointer);
            ret2 = resultPointer.get();
        }
        this.allocator.registerAction(ctx, null, X);
        return ret2 - 1;
    }

    protected int idamax(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected int icamax(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected int izamax(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT swap called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasSswap_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT copy called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasScopy_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX, (FloatPointer)((FloatPointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void scopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void saxpy(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT axpy called");
        }
        Nd4j.getExecutioner().exec((Op)new Axpy(X, Y, (double)alpha, (long)N));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void haxpy(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        ((CudaExecutioner)Nd4j.getExecutioner()).exec((Op)new Axpy(X, Y, (double)alpha, (long)N));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void haxpy(int N, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void saxpy(int N, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE swap called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDswap_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dcopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE copy called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(Y, X);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        CublasPointer yCPointer = new CublasPointer(Y, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDcopy_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX, (DoublePointer)((DoublePointer)yCPointer.getDevicePointer()), (int)incY);
        }
        this.allocator.registerAction(ctx, Y, X);
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void dcopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void daxpy(int N, double alpha, INDArray X, int incX, INDArray Y, int incY) {
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE axpy called");
        }
        Nd4j.getExecutioner().exec((Op)new Axpy(X, Y, alpha, (long)N));
        OpExecutionerUtil.checkForAny((INDArray)Y);
    }

    protected void daxpy(int N, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected void cswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void ccopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void caxpy(int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zcopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zaxpy(int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void srotg(float a, float b, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotmg(float d1, float d2, float b1, float b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void srot(int N, INDArray X, int incX, INDArray Y, int incY, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void drotg(double a, double b, double c, double s) {
        throw new UnsupportedOperationException();
    }

    protected void drotmg(double d1, double d2, double b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void drot(int N, INDArray X, int incX, INDArray Y, int incY, double c, double s) {
        throw new UnsupportedOperationException();
    }

    protected void drotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sscal(int N, float alpha, INDArray X, int incX) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            logger.warn("FLOAT scal called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(X, new INDArray[0]);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasSscal_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (FloatPointer)new FloatPointer(new float[]{alpha}), (FloatPointer)((FloatPointer)xCPointer.getDevicePointer()), (int)incX);
        }
        this.allocator.registerAction(ctx, X, new INDArray[0]);
        OpExecutionerUtil.checkForAny((INDArray)X);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dscal(int N, double alpha, INDArray X, int incX) {
        cublasHandle_t handle;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            logger.warn("DOUBLE scal called");
        }
        Nd4j.getExecutioner().push();
        CudaContext ctx = this.allocator.getFlowController().prepareAction(X, new INDArray[0]);
        CublasPointer xCPointer = new CublasPointer(X, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            cublas.cublasSetStream_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            cublas.cublasDscal_v2((cublas.cublasContext)new cublas.cublasContext((Pointer)handle), (int)N, (DoublePointer)new DoublePointer(new double[]{alpha}), (DoublePointer)((DoublePointer)xCPointer.getDevicePointer()), (int)incX);
        }
        this.allocator.registerAction(ctx, X, new INDArray[0]);
        OpExecutionerUtil.checkForAny((INDArray)X);
    }

    protected void cscal(int N, IComplexFloat alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void zscal(int N, IComplexDouble alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void csscal(int N, float alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void zdscal(int N, double alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsDataBufferL1Ops() {
        return false;
    }
}

