/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.linalg.util.ArrayUtil;

public class CudaIntDataBuffer
extends BaseCudaDataBuffer {
    public CudaIntDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaIntDataBuffer(long length) {
        super(length, 4);
    }

    public CudaIntDataBuffer(long length, MemoryWorkspace workspace) {
        super(length, 4, workspace);
    }

    public CudaIntDataBuffer(long length, boolean initialize) {
        super(length, 4, initialize);
    }

    public CudaIntDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 4, initialize, workspace);
    }

    public CudaIntDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaIntDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaIntDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaIntDataBuffer(int[] data) {
        this(data.length);
        this.setData(data);
    }

    public CudaIntDataBuffer(int[] data, MemoryWorkspace workspace) {
        this((long)data.length, workspace);
        this.setData(data);
    }

    public CudaIntDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaIntDataBuffer(int[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, workspace);
    }

    public CudaIntDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaIntDataBuffer(byte[] data, int length) {
        super(data, (long)length);
    }

    public CudaIntDataBuffer(double[] data) {
        super(data);
    }

    public CudaIntDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaIntDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaIntDataBuffer(float[] data) {
        super(data);
    }

    public CudaIntDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaIntDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaIntDataBuffer(ByteBuffer buffer, int length) {
        super(buffer, (long)length);
    }

    public CudaIntDataBuffer(ByteBuffer buffer, int length, long offset) {
        super(buffer, (long)length, offset);
    }

    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (!contiguous) {
            throw new UnsupportedOperationException("Non contiguous is not supported");
        }
    }

    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (!contiguous) {
            throw new UnsupportedOperationException("Non contiguous is not supported");
        }
    }

    protected DataBuffer create(long length) {
        return new CudaIntDataBuffer(length);
    }

    public DataBuffer create(double[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((double[])data));
    }

    public DataBuffer create(float[] data) {
        return new CudaIntDataBuffer(ArrayUtil.toInts((float[])data));
    }

    public DataBuffer create(int[] data) {
        return new CudaIntDataBuffer(data);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.getHostPointer() == null) {
            stream.writeInt(0);
        } else {
            int[] arr = this.asInt();
            stream.writeInt(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                stream.writeInt(arr[i]);
            }
        }
    }

    protected void initTypeAndSize() {
        this.elementSize = (byte)4;
        this.type = DataBuffer.Type.INT;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int n = stream.readInt();
        int[] arr = new int[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = stream.readInt();
        }
        this.setData(arr);
    }
}

