/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.pointers.cuda;

import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.exception.ND4JException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOpsHolder;

public class cudaEvent_t
extends CudaPointer {
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private long clock;
    private int laneId;
    private int deviceId;

    public cudaEvent_t(Pointer pointer) {
        super(pointer);
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public void markDestoryed() {
        this.destroyed.set(true);
    }

    public void destroy() {
        if (!this.isDestroyed()) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().destroyEvent((Pointer)this);
            this.markDestoryed();
        }
    }

    public void synchronize() {
        int res;
        if (!this.isDestroyed() && (res = NativeOpsHolder.getInstance().getDeviceNativeOps().eventSynchronize((Pointer)this)) == 0) {
            throw new ND4JException("CUDA exception happened. Terminating. Last op: [" + Nd4j.getExecutioner().getLastOp() + "]");
        }
    }

    public void register(cudaStream_t stream) {
        int res;
        if (!this.isDestroyed() && (res = NativeOpsHolder.getInstance().getDeviceNativeOps().registerEvent((Pointer)this, (Pointer)stream)) == 0) {
            throw new ND4JException("CUDA exception happened. Terminating. Last op: [" + Nd4j.getExecutioner().getLastOp() + "]");
        }
    }

    public long getClock() {
        return this.clock;
    }

    public void setClock(long clock) {
        this.clock = clock;
    }

    public int getLaneId() {
        return this.laneId;
    }

    public void setLaneId(int laneId) {
        this.laneId = laneId;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }
}

