/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.bytedeco.javacpp.openblas;
import org.nd4j.linalg.api.blas.impl.BaseLapack;
import org.nd4j.linalg.api.ndarray.INDArray;

public class CpuLapack
extends BaseLapack {
    protected static int getColumnOrder(INDArray A) {
        return A.ordering() == 'f' ? 102 : 101;
    }

    protected static int getLda(INDArray A) {
        return A.ordering() == 'f' ? A.rows() : A.columns();
    }

    public void sgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        int status = openblas.LAPACKE_sgetrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (FloatBuffer)A.data().asNioFloat(), (int)CpuLapack.getLda(A), (IntBuffer)IPIV.data().asNioInt());
    }

    public void dgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        int status = openblas.LAPACKE_dgetrf((int)CpuLapack.getColumnOrder(A), (int)M, (int)N, (DoubleBuffer)A.data().asNioDouble(), (int)CpuLapack.getLda(A), (IntBuffer)IPIV.data().asNioInt());
    }

    public void sgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        FloatBuffer superb = FloatBuffer.allocate(M < N ? M : N);
        int status = openblas.LAPACKE_sgesvd((int)CpuLapack.getColumnOrder(A), (byte)jobu, (byte)jobvt, (int)M, (int)N, (FloatBuffer)A.data().asNioFloat(), (int)CpuLapack.getLda(A), (FloatBuffer)S.data().asNioFloat(), (FloatBuffer)(U == null ? null : U.data().asNioFloat()), (int)(U == null ? 1 : CpuLapack.getLda(U)), (FloatBuffer)(VT == null ? null : VT.data().asNioFloat()), (int)(VT == null ? 1 : CpuLapack.getLda(VT)), (FloatBuffer)superb);
    }

    public void dgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        DoubleBuffer superb = DoubleBuffer.allocate(M < N ? M : N);
        int status = openblas.LAPACKE_dgesvd((int)CpuLapack.getColumnOrder(A), (byte)jobu, (byte)jobvt, (int)M, (int)N, (DoubleBuffer)A.data().asNioDouble(), (int)CpuLapack.getLda(A), (DoubleBuffer)S.data().asNioDouble(), (DoubleBuffer)(U == null ? null : U.data().asNioDouble()), (int)(U == null ? 1 : CpuLapack.getLda(U)), (DoubleBuffer)(VT == null ? null : VT.data().asNioDouble()), (int)(VT == null ? 1 : CpuLapack.getLda(VT)), (DoubleBuffer)superb);
    }

    public void getri(int N, INDArray A, int lda, int[] IPIV, INDArray WORK, int lwork, int INFO) {
    }
}

