/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.blas;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.openblas;
import org.nd4j.linalg.api.blas.impl.BaseLevel1;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Dot;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.Nd4jBlas;

public class CpuLevel1
extends BaseLevel1 {
    private Nd4jBlas nd4jBlas = (Nd4jBlas)Nd4j.factory().blas();

    protected float sdsdot(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        return openblas.cblas_sdsdot((int)N, (float)alpha, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
    }

    protected double dsdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        return openblas.cblas_dsdot((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
    }

    protected float hdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected float hdot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException();
    }

    protected float sdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        if (incX >= 1 && incY >= 1) {
            return openblas.cblas_sdot((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
        }
        Dot dot = new Dot(X, Y);
        Nd4j.getExecutioner().exec((Op)dot);
        return dot.getFinalResult().floatValue();
    }

    protected float sdot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException();
    }

    protected double ddot(int N, INDArray X, int incX, INDArray Y, int incY) {
        if (incX >= 1 && incY >= 1) {
            return openblas.cblas_ddot((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY);
        }
        Dot dot = new Dot(X, Y);
        Nd4j.getExecutioner().exec((Op)dot);
        return dot.getFinalResult().doubleValue();
    }

    protected double ddot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void cdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void cdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    protected void zdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void zdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    protected float snrm2(int N, INDArray X, int incX) {
        return openblas.cblas_snrm2((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX);
    }

    protected float sasum(int N, INDArray X, int incX) {
        return openblas.cblas_sasum((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX);
    }

    protected float sasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dnrm2(int N, INDArray X, int incX) {
        return openblas.cblas_dnrm2((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX);
    }

    protected double dasum(int N, INDArray X, int incX) {
        return openblas.cblas_dasum((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX);
    }

    protected double dasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float scnrm2(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float scasum(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dznrm2(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dzasum(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected int isamax(int N, INDArray X, int incX) {
        return (int)openblas.cblas_isamax((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX);
    }

    protected int isamax(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException();
    }

    protected int idamax(int N, INDArray X, int incX) {
        return (int)openblas.cblas_idamax((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX);
    }

    protected int idamax(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException();
    }

    protected int icamax(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected int izamax(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void sswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_sswap((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
    }

    protected void scopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_scopy((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
    }

    protected void scopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    protected void haxpy(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void saxpy(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_saxpy((int)N, (float)alpha, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY);
    }

    public void haxpy(int n, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    public void saxpy(int n, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    protected void dswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_dswap((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY);
    }

    protected void dcopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_dcopy((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY);
    }

    protected void dcopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    protected void daxpy(int N, double alpha, INDArray X, int incX, INDArray Y, int incY) {
        openblas.cblas_daxpy((int)N, (double)alpha, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY);
    }

    public void daxpy(int n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        throw new UnsupportedOperationException();
    }

    protected void cswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void ccopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void caxpy(int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zcopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zaxpy(int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void srotg(float a, float b, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotmg(float d1, float d2, float b1, float b2, INDArray P) {
        openblas.cblas_srotmg((FloatPointer)new FloatPointer(new float[]{d1}), (FloatPointer)new FloatPointer(new float[]{d2}), (FloatPointer)new FloatPointer(new float[]{b1}), (float)b2, (FloatPointer)((FloatPointer)P.data().addressPointer()));
    }

    protected void srot(int N, INDArray X, int incX, INDArray Y, int incY, float c, float s) {
        openblas.cblas_srot((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY, (float)c, (float)s);
    }

    protected void srotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        openblas.cblas_srotm((int)N, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX, (FloatPointer)((FloatPointer)Y.data().addressPointer()), (int)incY, (FloatPointer)((FloatPointer)P.data().addressPointer()));
    }

    protected void drotg(double a, double b, double c, double s) {
        openblas.cblas_drotg((DoublePointer)new DoublePointer(new double[]{a}), (DoublePointer)new DoublePointer(new double[]{b}), (DoublePointer)new DoublePointer(new double[]{c}), (DoublePointer)new DoublePointer(new double[]{s}));
    }

    protected void drotmg(double d1, double d2, double b1, double b2, INDArray P) {
        openblas.cblas_drotmg((DoublePointer)new DoublePointer(new double[]{d1}), (DoublePointer)new DoublePointer(new double[]{d2}), (DoublePointer)new DoublePointer(new double[]{b1}), (double)b2, (DoublePointer)((DoublePointer)P.data().addressPointer()));
    }

    protected void drot(int N, INDArray X, int incX, INDArray Y, int incY, double c, double s) {
        openblas.cblas_drot((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY, (double)c, (double)s);
    }

    protected void drotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        openblas.cblas_drotm((int)N, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX, (DoublePointer)((DoublePointer)Y.data().addressPointer()), (int)incY, (DoublePointer)((DoublePointer)P.data().addressPointer()));
    }

    protected void sscal(int N, float alpha, INDArray X, int incX) {
        openblas.cblas_sscal((int)N, (float)alpha, (FloatPointer)((FloatPointer)X.data().addressPointer()), (int)incX);
    }

    protected void dscal(int N, double alpha, INDArray X, int incX) {
        openblas.cblas_dscal((int)N, (double)alpha, (DoublePointer)((DoublePointer)X.data().addressPointer()), (int)incX);
    }

    protected void cscal(int N, IComplexFloat alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void zscal(int N, IComplexDouble alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void csscal(int N, float alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void zdscal(int N, double alpha, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float hasum(int N, INDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float hasum(int N, DataBuffer X, int offsetX, int incX) {
        throw new UnsupportedOperationException();
    }
}

