/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectShapeInfoProvider.class);
    private Map<ShapeDescriptor, Pair<DataBuffer, int[]>> shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, int[]>>();
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<DataBuffer, int[]> createShapeInformation(int[] shape, int[] stride, long offset, int elementWiseStride, char order) {
        offset = 0L;
        ShapeDescriptor descriptor = new ShapeDescriptor(shape, stride, offset, elementWiseStride, order);
        if (!this.shapeCache.containsKey(descriptor)) {
            if (this.counter.get() < 1000) {
                DirectShapeInfoProvider directShapeInfoProvider = this;
                synchronized (directShapeInfoProvider) {
                    if (!this.shapeCache.containsKey(descriptor)) {
                        this.counter.incrementAndGet();
                        Pair buffer = super.createShapeInformation(shape, stride, offset, elementWiseStride, order);
                        this.shapeCache.put(descriptor, (Pair<DataBuffer, int[]>)buffer);
                        this.bytes.addAndGet(((DataBuffer)buffer.getFirst()).length() * 4L * 2L);
                        return buffer;
                    }
                    return this.shapeCache.get(descriptor);
                }
            }
            return super.createShapeInformation(shape, stride, offset, elementWiseStride, order);
        }
        return this.shapeCache.get(descriptor);
    }

    public void purgeCache() {
        this.shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, int[]>>();
    }
}

