/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShapeInfoProvider
extends BaseShapeInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectShapeInfoProvider.class);
    private Map<ShapeDescriptor, Pair<DataBuffer, long[]>> shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, long[]>>();
    private Map<LongShapeDescriptor, Pair<DataBuffer, long[]>> longCache = new ConcurrentHashMap<LongShapeDescriptor, Pair<DataBuffer, long[]>>();
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 1000;

    public Pair<DataBuffer, long[]> createShapeInformation(int[] shape, int[] stride, long offset, int elementWiseStride, char order) {
        return this.createShapeInformation(shape, stride, offset, elementWiseStride, order, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<DataBuffer, long[]> createShapeInformation(int[] shape, int[] stride, long offset, int elementWiseStride, char order, long extras) {
        offset = 0L;
        ShapeDescriptor descriptor = new ShapeDescriptor(shape, stride, offset, elementWiseStride, order, extras);
        if (!this.shapeCache.containsKey(descriptor)) {
            if (this.counter.get() < 1000) {
                DirectShapeInfoProvider directShapeInfoProvider = this;
                synchronized (directShapeInfoProvider) {
                    if (!this.shapeCache.containsKey(descriptor)) {
                        this.counter.incrementAndGet();
                        Pair buffer = super.createShapeInformation(shape, stride, offset, elementWiseStride, order, extras);
                        this.shapeCache.put(descriptor, (Pair<DataBuffer, long[]>)buffer);
                        this.bytes.addAndGet(((DataBuffer)buffer.getFirst()).length() * 4L * 2L);
                        return buffer;
                    }
                    return this.shapeCache.get(descriptor);
                }
            }
            return super.createShapeInformation(shape, stride, offset, elementWiseStride, order, extras);
        }
        return this.shapeCache.get(descriptor);
    }

    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long offset, long elementWiseStride, char order) {
        return this.createShapeInformation(shape, stride, offset, elementWiseStride, order, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<DataBuffer, long[]> createShapeInformation(long[] shape, long[] stride, long offset, long elementWiseStride, char order, long extras) {
        offset = 0L;
        LongShapeDescriptor descriptor = new LongShapeDescriptor(shape, stride, offset, elementWiseStride, order, extras);
        if (!this.shapeCache.containsKey(descriptor)) {
            if (this.counter.get() < 1000) {
                DirectShapeInfoProvider directShapeInfoProvider = this;
                synchronized (directShapeInfoProvider) {
                    if (!this.longCache.containsKey(descriptor)) {
                        this.counter.incrementAndGet();
                        Pair buffer = super.createShapeInformation(shape, stride, offset, elementWiseStride, order, extras);
                        this.longCache.put(descriptor, (Pair<DataBuffer, long[]>)buffer);
                        this.bytes.addAndGet(((DataBuffer)buffer.getFirst()).length() * 4L * 2L);
                        return buffer;
                    }
                    return this.longCache.get(descriptor);
                }
            }
            return super.createShapeInformation(shape, stride, offset, elementWiseStride, order, extras);
        }
        return this.longCache.get(descriptor);
    }

    public void purgeCache() {
        this.shapeCache = new ConcurrentHashMap<ShapeDescriptor, Pair<DataBuffer, long[]>>();
    }
}

