/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseSparseInfoProvider;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.SparseDescriptor;

public class DirectSparseInfoProvider
extends BaseSparseInfoProvider {
    private Map<SparseDescriptor, DataBuffer> sparseCache = new ConcurrentHashMap<SparseDescriptor, DataBuffer>();
    private AtomicInteger counter = new AtomicInteger(0);
    private static final int MAX_ENTRIES = 100;

    public DataBuffer createSparseInformation(int[] flags, long[] sparseOffsets, int[] hiddenDimensions, int underlyingRank) {
        SparseDescriptor descriptor = new SparseDescriptor(flags, sparseOffsets, hiddenDimensions, underlyingRank);
        if (!this.sparseCache.containsKey(descriptor)) {
            if (this.counter.get() < 100) {
                if (!this.sparseCache.containsKey(descriptor)) {
                    this.counter.incrementAndGet();
                    DataBuffer buffer = Shape.createSparseInformation((int[])flags, (long[])sparseOffsets, (int[])hiddenDimensions, (int)underlyingRank);
                    this.sparseCache.put(descriptor, buffer);
                    return buffer;
                }
            } else {
                return Shape.createSparseInformation((int[])flags, (long[])sparseOffsets, (int[])hiddenDimensions, (int)underlyingRank);
            }
        }
        return this.sparseCache.get(descriptor);
    }

    public void purgeCache() {
        this.sparseCache = new ConcurrentHashMap<SparseDescriptor, DataBuffer>();
    }
}

