/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.client;

import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import io.aeron.Aeron;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.nd4j.aeron.ipc.AeronConnectionInformation;
import org.nd4j.aeron.ipc.AeronNDArrayPublisher;
import org.nd4j.aeron.ipc.AeronNDArraySubscriber;
import org.nd4j.aeron.ipc.AeronUtil;
import org.nd4j.aeron.ipc.NDArrayCallback;
import org.nd4j.aeron.ipc.NDArrayMessage;
import org.nd4j.aeron.ipc.response.HostPortPublisher;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.parameterserver.model.MasterStatus;
import org.nd4j.parameterserver.model.ServerTypeJson;
import org.nd4j.parameterserver.model.SubscriberState;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterServerClient
implements NDArrayCallback {
    private static final Logger log = LoggerFactory.getLogger(ParameterServerClient.class);
    private String ndarraySendUrl;
    private String ndarrayRetrieveUrl;
    private AeronNDArraySubscriber subscriber;
    private String subscriberHost;
    private int subscriberPort;
    private int subscriberStream = 11;
    private AtomicReference<INDArray> arr;
    private INDArray none = Nd4j.scalar((double)1.0);
    private AtomicBoolean running;
    private String masterStatusHost;
    private int masterStatusPort;
    private ObjectMapper objectMapper = new ObjectMapper();
    private Aeron aeron;
    private boolean compressArray = true;

    public int arraysSentToResponder() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        try {
            String type = ((ServerTypeJson)this.objectMapper.readValue(((JsonNode)Unirest.get((String)String.format("http://%s:%d/type", this.masterStatusHost, this.masterStatusPort)).asJson().getBody()).toString(), ServerTypeJson.class)).getType();
            if (!type.equals("master")) {
                throw new IllegalStateException("Wrong type " + type);
            }
            Unirest.get((String)String.format("http://%s:%d/started", this.masterStatusHost, this.masterStatusPort)).asJson().getBody();
            return ((MasterStatus)this.objectMapper.readValue(((JsonNode)Unirest.get((String)String.format("http://%s:%d/started", this.masterStatusHost, this.masterStatusPort)).asJson().getBody()).toString(), MasterStatus.class)).getResponderN();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void blockTillReady() {
        while (!this.isReadyForNext()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isReadyForNext() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        try {
            int masterStream = Integer.parseInt(this.ndarraySendUrl.split(":")[2]);
            SubscriberState subscriberState = (SubscriberState)this.objectMapper.readValue(((JsonNode)Unirest.get((String)String.format("http://%s:%d/state/%d", this.masterStatusHost, this.masterStatusPort, masterStream)).asJson().getBody()).toString(), SubscriberState.class);
            return subscriberState.isReady();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean masterStarted() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        try {
            String type = ((ServerTypeJson)this.objectMapper.readValue(((JsonNode)Unirest.get((String)String.format("http://%s:%d/type", this.masterStatusHost, this.masterStatusPort)).asJson().getBody()).toString(), ServerTypeJson.class)).getType();
            if (!type.equals("master")) {
                throw new IllegalStateException("Wrong type " + type);
            }
            Unirest.get((String)String.format("http://%s:%d/started", this.masterStatusHost, this.masterStatusPort)).asJson().getBody();
            return ((MasterStatus)this.objectMapper.readValue(((JsonNode)Unirest.get((String)String.format("http://%s:%d/started", this.masterStatusHost, this.masterStatusPort)).asJson().getBody()).toString(), MasterStatus.class)).started();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void pushNDArrayMessage(NDArrayMessage message) {
        if (this.subscriber == null) {
            this.running = new AtomicBoolean(true);
            this.subscriber = AeronNDArraySubscriber.startSubscriber((Aeron)this.aeron, (String)this.subscriberHost, (int)this.subscriberPort, (NDArrayCallback)this, (int)this.subscriberStream, (AtomicBoolean)this.running);
            log.debug("Started parameter server client on " + this.subscriber.connectionUrl());
        }
        String[] split = this.ndarraySendUrl.split(":");
        int port = Integer.parseInt(split[1]);
        int streamToPublish = Integer.parseInt(split[2]);
        String channel = AeronUtil.aeronChannel((String)split[0], (int)port);
        log.debug("Parameter server client publishing to " + this.ndarraySendUrl);
        try (AeronNDArrayPublisher publisher = AeronNDArrayPublisher.builder().streamId(streamToPublish).compress(this.isCompressArray()).aeron(this.aeron).channel(channel).build();){
            publisher.publish(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void pushNDArray(INDArray arr) {
        this.pushNDArrayMessage(NDArrayMessage.wholeArrayUpdate((INDArray)arr));
    }

    public String connectionUrl() {
        return AeronConnectionInformation.of((String)this.subscriberHost, (int)this.subscriberPort, (int)this.subscriberStream).toString();
    }

    public INDArray getArray() {
        if (this.subscriber == null) {
            this.running = new AtomicBoolean(true);
            this.subscriber = AeronNDArraySubscriber.startSubscriber((Aeron)this.aeron, (String)this.subscriberHost, (int)this.subscriberPort, (NDArrayCallback)this, (int)this.subscriberStream, (AtomicBoolean)this.running);
            log.debug("Started parameter server client on " + this.subscriber.connectionUrl());
        }
        if (this.arr == null) {
            this.arr = new AtomicReference<INDArray>(this.none);
        }
        log.debug("Parameter server client retrieving url from " + this.ndarrayRetrieveUrl);
        String[] split = this.ndarrayRetrieveUrl.split(":");
        int port = Integer.parseInt(split[1]);
        int streamToPublish = Integer.parseInt(split[2]);
        String channel = AeronUtil.aeronChannel((String)split[0], (int)port);
        try (HostPortPublisher hostPortPublisher = HostPortPublisher.builder().channel(channel).aeron(this.aeron).streamId(streamToPublish).uriToSend(AeronConnectionInformation.of((String)this.subscriberHost, (int)this.subscriberPort, (int)this.subscriberStream).toString()).build();){
            hostPortPublisher.send();
            log.debug("Sent subscriber information " + AeronConnectionInformation.of((String)this.subscriberHost, (int)this.subscriberPort, (int)this.subscriberStream).toString());
            while (this.arr.get() == this.none) {
                Thread.sleep(1000L);
                log.info("Waiting on array to be updated.");
            }
        }
        catch (Exception e) {
            log.error("Error with publishing", (Throwable)e);
        }
        INDArray arr2 = this.arr.get();
        this.arr.set(this.none);
        return arr2;
    }

    public void onNDArrayMessage(NDArrayMessage message) {
        boolean whole;
        INDArray arr = message.getArr();
        int[] dimensions = message.getDimensions();
        boolean bl = whole = dimensions.length == 1 && dimensions[0] == -1;
        if (!whole) {
            this.onNDArrayPartial(arr, message.getIndex(), dimensions);
        } else {
            this.onNDArray(arr);
        }
    }

    public void onNDArrayPartial(INDArray arr, long idx, int ... dimensions) {
        INDArray get = this.arr.get();
        get.tensorAlongDimension((int)idx, dimensions).assign(arr);
    }

    public void onNDArray(INDArray arr) {
        log.info("Received array");
        this.arr.set(arr);
    }

    public static ParameterServerClientBuilder builder() {
        return new ParameterServerClientBuilder();
    }

    public String getNdarraySendUrl() {
        return this.ndarraySendUrl;
    }

    public String getNdarrayRetrieveUrl() {
        return this.ndarrayRetrieveUrl;
    }

    public AeronNDArraySubscriber getSubscriber() {
        return this.subscriber;
    }

    public String getSubscriberHost() {
        return this.subscriberHost;
    }

    public int getSubscriberPort() {
        return this.subscriberPort;
    }

    public int getSubscriberStream() {
        return this.subscriberStream;
    }

    public AtomicReference<INDArray> getArr() {
        return this.arr;
    }

    public INDArray getNone() {
        return this.none;
    }

    public AtomicBoolean getRunning() {
        return this.running;
    }

    public String getMasterStatusHost() {
        return this.masterStatusHost;
    }

    public int getMasterStatusPort() {
        return this.masterStatusPort;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Aeron getAeron() {
        return this.aeron;
    }

    public boolean isCompressArray() {
        return this.compressArray;
    }

    public void setNdarraySendUrl(String ndarraySendUrl) {
        this.ndarraySendUrl = ndarraySendUrl;
    }

    public void setNdarrayRetrieveUrl(String ndarrayRetrieveUrl) {
        this.ndarrayRetrieveUrl = ndarrayRetrieveUrl;
    }

    public void setSubscriber(AeronNDArraySubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void setSubscriberHost(String subscriberHost) {
        this.subscriberHost = subscriberHost;
    }

    public void setSubscriberPort(int subscriberPort) {
        this.subscriberPort = subscriberPort;
    }

    public void setSubscriberStream(int subscriberStream) {
        this.subscriberStream = subscriberStream;
    }

    public void setArr(AtomicReference<INDArray> arr) {
        this.arr = arr;
    }

    public void setNone(INDArray none) {
        this.none = none;
    }

    public void setRunning(AtomicBoolean running) {
        this.running = running;
    }

    public void setMasterStatusHost(String masterStatusHost) {
        this.masterStatusHost = masterStatusHost;
    }

    public void setMasterStatusPort(int masterStatusPort) {
        this.masterStatusPort = masterStatusPort;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setAeron(Aeron aeron) {
        this.aeron = aeron;
    }

    public void setCompressArray(boolean compressArray) {
        this.compressArray = compressArray;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterServerClient)) {
            return false;
        }
        ParameterServerClient other = (ParameterServerClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ndarraySendUrl = this.getNdarraySendUrl();
        String other$ndarraySendUrl = other.getNdarraySendUrl();
        if (this$ndarraySendUrl == null ? other$ndarraySendUrl != null : !this$ndarraySendUrl.equals(other$ndarraySendUrl)) {
            return false;
        }
        String this$ndarrayRetrieveUrl = this.getNdarrayRetrieveUrl();
        String other$ndarrayRetrieveUrl = other.getNdarrayRetrieveUrl();
        if (this$ndarrayRetrieveUrl == null ? other$ndarrayRetrieveUrl != null : !this$ndarrayRetrieveUrl.equals(other$ndarrayRetrieveUrl)) {
            return false;
        }
        AeronNDArraySubscriber this$subscriber = this.getSubscriber();
        AeronNDArraySubscriber other$subscriber = other.getSubscriber();
        if (this$subscriber == null ? other$subscriber != null : !this$subscriber.equals(other$subscriber)) {
            return false;
        }
        String this$subscriberHost = this.getSubscriberHost();
        String other$subscriberHost = other.getSubscriberHost();
        if (this$subscriberHost == null ? other$subscriberHost != null : !this$subscriberHost.equals(other$subscriberHost)) {
            return false;
        }
        if (this.getSubscriberPort() != other.getSubscriberPort()) {
            return false;
        }
        if (this.getSubscriberStream() != other.getSubscriberStream()) {
            return false;
        }
        AtomicReference<INDArray> this$arr = this.getArr();
        AtomicReference<INDArray> other$arr = other.getArr();
        if (this$arr == null ? other$arr != null : !this$arr.equals(other$arr)) {
            return false;
        }
        INDArray this$none = this.getNone();
        INDArray other$none = other.getNone();
        if (this$none == null ? other$none != null : !this$none.equals(other$none)) {
            return false;
        }
        AtomicBoolean this$running = this.getRunning();
        AtomicBoolean other$running = other.getRunning();
        if (this$running == null ? other$running != null : !this$running.equals(other$running)) {
            return false;
        }
        String this$masterStatusHost = this.getMasterStatusHost();
        String other$masterStatusHost = other.getMasterStatusHost();
        if (this$masterStatusHost == null ? other$masterStatusHost != null : !this$masterStatusHost.equals(other$masterStatusHost)) {
            return false;
        }
        if (this.getMasterStatusPort() != other.getMasterStatusPort()) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        Aeron this$aeron = this.getAeron();
        Aeron other$aeron = other.getAeron();
        if (this$aeron == null ? other$aeron != null : !this$aeron.equals(other$aeron)) {
            return false;
        }
        return this.isCompressArray() == other.isCompressArray();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterServerClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ndarraySendUrl = this.getNdarraySendUrl();
        result = result * 59 + ($ndarraySendUrl == null ? 43 : $ndarraySendUrl.hashCode());
        String $ndarrayRetrieveUrl = this.getNdarrayRetrieveUrl();
        result = result * 59 + ($ndarrayRetrieveUrl == null ? 43 : $ndarrayRetrieveUrl.hashCode());
        AeronNDArraySubscriber $subscriber = this.getSubscriber();
        result = result * 59 + ($subscriber == null ? 43 : $subscriber.hashCode());
        String $subscriberHost = this.getSubscriberHost();
        result = result * 59 + ($subscriberHost == null ? 43 : $subscriberHost.hashCode());
        result = result * 59 + this.getSubscriberPort();
        result = result * 59 + this.getSubscriberStream();
        AtomicReference<INDArray> $arr = this.getArr();
        result = result * 59 + ($arr == null ? 43 : $arr.hashCode());
        INDArray $none = this.getNone();
        result = result * 59 + ($none == null ? 43 : $none.hashCode());
        AtomicBoolean $running = this.getRunning();
        result = result * 59 + ($running == null ? 43 : $running.hashCode());
        String $masterStatusHost = this.getMasterStatusHost();
        result = result * 59 + ($masterStatusHost == null ? 43 : $masterStatusHost.hashCode());
        result = result * 59 + this.getMasterStatusPort();
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        Aeron $aeron = this.getAeron();
        result = result * 59 + ($aeron == null ? 43 : $aeron.hashCode());
        result = result * 59 + (this.isCompressArray() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ParameterServerClient(ndarraySendUrl=" + this.getNdarraySendUrl() + ", ndarrayRetrieveUrl=" + this.getNdarrayRetrieveUrl() + ", subscriber=" + this.getSubscriber() + ", subscriberHost=" + this.getSubscriberHost() + ", subscriberPort=" + this.getSubscriberPort() + ", subscriberStream=" + this.getSubscriberStream() + ", arr=" + this.getArr() + ", none=" + this.getNone() + ", running=" + this.getRunning() + ", masterStatusHost=" + this.getMasterStatusHost() + ", masterStatusPort=" + this.getMasterStatusPort() + ", objectMapper=" + this.getObjectMapper() + ", aeron=" + this.getAeron() + ", compressArray=" + this.isCompressArray() + ")";
    }

    @ConstructorProperties(value={"ndarraySendUrl", "ndarrayRetrieveUrl", "subscriber", "subscriberHost", "subscriberPort", "subscriberStream", "arr", "none", "running", "masterStatusHost", "masterStatusPort", "objectMapper", "aeron", "compressArray"})
    public ParameterServerClient(String ndarraySendUrl, String ndarrayRetrieveUrl, AeronNDArraySubscriber subscriber, String subscriberHost, int subscriberPort, int subscriberStream, AtomicReference<INDArray> arr, INDArray none, AtomicBoolean running, String masterStatusHost, int masterStatusPort, ObjectMapper objectMapper, Aeron aeron, boolean compressArray) {
        this.ndarraySendUrl = ndarraySendUrl;
        this.ndarrayRetrieveUrl = ndarrayRetrieveUrl;
        this.subscriber = subscriber;
        this.subscriberHost = subscriberHost;
        this.subscriberPort = subscriberPort;
        this.subscriberStream = subscriberStream;
        this.arr = arr;
        this.none = none;
        this.running = running;
        this.masterStatusHost = masterStatusHost;
        this.masterStatusPort = masterStatusPort;
        this.objectMapper = objectMapper;
        this.aeron = aeron;
        this.compressArray = compressArray;
    }

    public static class ParameterServerClientBuilder {
        private String ndarraySendUrl;
        private String ndarrayRetrieveUrl;
        private AeronNDArraySubscriber subscriber;
        private String subscriberHost;
        private int subscriberPort;
        private int subscriberStream;
        private AtomicReference<INDArray> arr;
        private INDArray none;
        private AtomicBoolean running;
        private String masterStatusHost;
        private int masterStatusPort;
        private ObjectMapper objectMapper;
        private Aeron aeron;
        private boolean compressArray;

        ParameterServerClientBuilder() {
        }

        public ParameterServerClientBuilder ndarraySendUrl(String ndarraySendUrl) {
            this.ndarraySendUrl = ndarraySendUrl;
            return this;
        }

        public ParameterServerClientBuilder ndarrayRetrieveUrl(String ndarrayRetrieveUrl) {
            this.ndarrayRetrieveUrl = ndarrayRetrieveUrl;
            return this;
        }

        public ParameterServerClientBuilder subscriber(AeronNDArraySubscriber subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public ParameterServerClientBuilder subscriberHost(String subscriberHost) {
            this.subscriberHost = subscriberHost;
            return this;
        }

        public ParameterServerClientBuilder subscriberPort(int subscriberPort) {
            this.subscriberPort = subscriberPort;
            return this;
        }

        public ParameterServerClientBuilder subscriberStream(int subscriberStream) {
            this.subscriberStream = subscriberStream;
            return this;
        }

        public ParameterServerClientBuilder arr(AtomicReference<INDArray> arr) {
            this.arr = arr;
            return this;
        }

        public ParameterServerClientBuilder none(INDArray none) {
            this.none = none;
            return this;
        }

        public ParameterServerClientBuilder running(AtomicBoolean running) {
            this.running = running;
            return this;
        }

        public ParameterServerClientBuilder masterStatusHost(String masterStatusHost) {
            this.masterStatusHost = masterStatusHost;
            return this;
        }

        public ParameterServerClientBuilder masterStatusPort(int masterStatusPort) {
            this.masterStatusPort = masterStatusPort;
            return this;
        }

        public ParameterServerClientBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public ParameterServerClientBuilder aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public ParameterServerClientBuilder compressArray(boolean compressArray) {
            this.compressArray = compressArray;
            return this;
        }

        public ParameterServerClient build() {
            return new ParameterServerClient(this.ndarraySendUrl, this.ndarrayRetrieveUrl, this.subscriber, this.subscriberHost, this.subscriberPort, this.subscriberStream, this.arr, this.none, this.running, this.masterStatusHost, this.masterStatusPort, this.objectMapper, this.aeron, this.compressArray);
        }

        public String toString() {
            return "ParameterServerClient.ParameterServerClientBuilder(ndarraySendUrl=" + this.ndarraySendUrl + ", ndarrayRetrieveUrl=" + this.ndarrayRetrieveUrl + ", subscriber=" + this.subscriber + ", subscriberHost=" + this.subscriberHost + ", subscriberPort=" + this.subscriberPort + ", subscriberStream=" + this.subscriberStream + ", arr=" + this.arr + ", none=" + this.none + ", running=" + this.running + ", masterStatusHost=" + this.masterStatusHost + ", masterStatusPort=" + this.masterStatusPort + ", objectMapper=" + this.objectMapper + ", aeron=" + this.aeron + ", compressArray=" + this.compressArray + ")";
        }
    }
}

