/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.conf;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.enums.ExecutionMode;
import org.nd4j.parameterserver.distributed.enums.FaultToleranceStrategy;
import org.nd4j.parameterserver.distributed.enums.NodeRole;
import org.nd4j.parameterserver.distributed.enums.TransportType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoidConfiguration
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(VoidConfiguration.class);
    private int streamId;
    private int unicastPort;
    private int multicastPort;
    private int numberOfShards;
    private FaultToleranceStrategy faultToleranceStrategy;
    private ExecutionMode executionMode;
    private List<String> shardAddresses;
    private List<String> backupAddresses;
    private TransportType transportType;
    private String networkMask;
    private String multicastNetwork;
    private String multicastInterface;
    private int ttl;
    protected NodeRole forcedRole;
    @Deprecated
    private boolean useHS = true;
    @Deprecated
    private boolean useNS = false;
    private long retransmitTimeout;
    private long responseTimeframe;
    private long responseTimeout;
    private String controllerAddress;

    public void setStreamId(int streamId) {
        if (streamId < 1) {
            throw new ND4JIllegalStateException("You can't use streamId 0, please specify other one");
        }
        this.streamId = streamId;
    }

    protected void validateNetmask() {
        if (this.networkMask == null) {
            return;
        }
        String[] chunks = this.networkMask.split("\\.");
        if (chunks.length == 1 || this.networkMask.isEmpty()) {
            throw new ND4JIllegalStateException("Provided netmask doesn't look like a legit one. Proper format is: 192.168.1.0/24 or 10.0.0.0/8");
        }
        if (chunks.length != 4) {
            throw new ND4JIllegalStateException("4 octets expected here for network mask");
        }
        for (int i = 0; i < 3; ++i) {
            String curr = chunks[i];
            try {
                int conv = Integer.valueOf(curr);
                if (conv >= 0 && conv <= 255) continue;
                throw new ND4JIllegalStateException();
            }
            catch (Exception e) {
                throw new ND4JIllegalStateException("All IP address octets should be in range of 0...255");
            }
        }
        if (Integer.valueOf(chunks[0]) == 0) {
            throw new ND4JIllegalStateException("First network mask octet should be non-zero. I.e. 10.0.0.0/8");
        }
        if (!this.networkMask.contains("/") || !chunks[3].startsWith("\\0\\/")) {
            chunks[3] = "0/24";
        }
        this.networkMask = chunks[0] + "." + chunks[1] + "." + chunks[2] + "." + chunks[3];
    }

    public void setNetworkMask(@NonNull String netmask) {
        if (netmask == null) {
            throw new NullPointerException("netmask");
        }
        this.networkMask = netmask;
        this.validateNetmask();
    }

    public String getNetworkMask() {
        this.validateNetmask();
        return this.networkMask;
    }

    public void setShardAddresses(List<String> addresses) {
        this.shardAddresses = addresses;
    }

    public void setShardAddresses(String ... ips) {
        if (this.shardAddresses == null) {
            this.shardAddresses = new ArrayList<String>();
        }
        for (String ip : ips) {
            if (ip == null) continue;
            this.shardAddresses.add(ip);
        }
    }

    public void setBackupAddresses(List<String> addresses) {
        this.backupAddresses = addresses;
    }

    public void setBackupAddresses(String ... ips) {
        if (this.backupAddresses == null) {
            this.backupAddresses = new ArrayList<String>();
        }
        for (String ip : ips) {
            if (ip == null) continue;
            this.backupAddresses.add(ip);
        }
    }

    public void setExecutionMode(@NonNull ExecutionMode executionMode) {
        if (executionMode == null) {
            throw new NullPointerException("executionMode");
        }
        this.executionMode = executionMode;
    }

    private static int $default$streamId() {
        return 119;
    }

    private static int $default$unicastPort() {
        return 49876;
    }

    private static int $default$multicastPort() {
        return 59876;
    }

    private static int $default$numberOfShards() {
        return 1;
    }

    private static FaultToleranceStrategy $default$faultToleranceStrategy() {
        return FaultToleranceStrategy.NONE;
    }

    private static ExecutionMode $default$executionMode() {
        return ExecutionMode.SHARDED;
    }

    private static List<String> $default$shardAddresses() {
        return new ArrayList<String>();
    }

    private static List<String> $default$backupAddresses() {
        return new ArrayList<String>();
    }

    private static TransportType $default$transportType() {
        return TransportType.ROUTED;
    }

    private static String $default$multicastNetwork() {
        return "224.0.1.1";
    }

    private static int $default$ttl() {
        return 4;
    }

    private static long $default$retransmitTimeout() {
        return 1000L;
    }

    private static long $default$responseTimeframe() {
        return 500L;
    }

    private static long $default$responseTimeout() {
        return 30000L;
    }

    public static VoidConfigurationBuilder builder() {
        return new VoidConfigurationBuilder();
    }

    public VoidConfiguration() {
    }

    @ConstructorProperties(value={"streamId", "unicastPort", "multicastPort", "numberOfShards", "faultToleranceStrategy", "executionMode", "shardAddresses", "backupAddresses", "transportType", "networkMask", "multicastNetwork", "multicastInterface", "ttl", "forcedRole", "useHS", "useNS", "retransmitTimeout", "responseTimeframe", "responseTimeout", "controllerAddress"})
    public VoidConfiguration(int streamId, int unicastPort, int multicastPort, int numberOfShards, FaultToleranceStrategy faultToleranceStrategy, ExecutionMode executionMode, List<String> shardAddresses, List<String> backupAddresses, TransportType transportType, String networkMask, String multicastNetwork, String multicastInterface, int ttl, NodeRole forcedRole, boolean useHS, boolean useNS, long retransmitTimeout, long responseTimeframe, long responseTimeout, String controllerAddress) {
        this.streamId = streamId;
        this.unicastPort = unicastPort;
        this.multicastPort = multicastPort;
        this.numberOfShards = numberOfShards;
        this.faultToleranceStrategy = faultToleranceStrategy;
        this.executionMode = executionMode;
        this.shardAddresses = shardAddresses;
        this.backupAddresses = backupAddresses;
        this.transportType = transportType;
        this.networkMask = networkMask;
        this.multicastNetwork = multicastNetwork;
        this.multicastInterface = multicastInterface;
        this.ttl = ttl;
        this.forcedRole = forcedRole;
        this.useHS = useHS;
        this.useNS = useNS;
        this.retransmitTimeout = retransmitTimeout;
        this.responseTimeframe = responseTimeframe;
        this.responseTimeout = responseTimeout;
        this.controllerAddress = controllerAddress;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getUnicastPort() {
        return this.unicastPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public FaultToleranceStrategy getFaultToleranceStrategy() {
        return this.faultToleranceStrategy;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public List<String> getShardAddresses() {
        return this.shardAddresses;
    }

    public List<String> getBackupAddresses() {
        return this.backupAddresses;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public String getMulticastNetwork() {
        return this.multicastNetwork;
    }

    public String getMulticastInterface() {
        return this.multicastInterface;
    }

    public int getTtl() {
        return this.ttl;
    }

    public NodeRole getForcedRole() {
        return this.forcedRole;
    }

    @Deprecated
    public boolean isUseHS() {
        return this.useHS;
    }

    @Deprecated
    public boolean isUseNS() {
        return this.useNS;
    }

    public long getRetransmitTimeout() {
        return this.retransmitTimeout;
    }

    public long getResponseTimeframe() {
        return this.responseTimeframe;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public String getControllerAddress() {
        return this.controllerAddress;
    }

    public void setUnicastPort(int unicastPort) {
        this.unicastPort = unicastPort;
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setFaultToleranceStrategy(FaultToleranceStrategy faultToleranceStrategy) {
        this.faultToleranceStrategy = faultToleranceStrategy;
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    public void setMulticastNetwork(String multicastNetwork) {
        this.multicastNetwork = multicastNetwork;
    }

    public void setMulticastInterface(String multicastInterface) {
        this.multicastInterface = multicastInterface;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setForcedRole(NodeRole forcedRole) {
        this.forcedRole = forcedRole;
    }

    @Deprecated
    public void setUseHS(boolean useHS) {
        this.useHS = useHS;
    }

    @Deprecated
    public void setUseNS(boolean useNS) {
        this.useNS = useNS;
    }

    public void setRetransmitTimeout(long retransmitTimeout) {
        this.retransmitTimeout = retransmitTimeout;
    }

    public void setResponseTimeframe(long responseTimeframe) {
        this.responseTimeframe = responseTimeframe;
    }

    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setControllerAddress(String controllerAddress) {
        this.controllerAddress = controllerAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoidConfiguration)) {
            return false;
        }
        VoidConfiguration other = (VoidConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStreamId() != other.getStreamId()) {
            return false;
        }
        if (this.getUnicastPort() != other.getUnicastPort()) {
            return false;
        }
        if (this.getMulticastPort() != other.getMulticastPort()) {
            return false;
        }
        if (this.getNumberOfShards() != other.getNumberOfShards()) {
            return false;
        }
        FaultToleranceStrategy this$faultToleranceStrategy = this.getFaultToleranceStrategy();
        FaultToleranceStrategy other$faultToleranceStrategy = other.getFaultToleranceStrategy();
        if (this$faultToleranceStrategy == null ? other$faultToleranceStrategy != null : !((Object)((Object)this$faultToleranceStrategy)).equals((Object)other$faultToleranceStrategy)) {
            return false;
        }
        ExecutionMode this$executionMode = this.getExecutionMode();
        ExecutionMode other$executionMode = other.getExecutionMode();
        if (this$executionMode == null ? other$executionMode != null : !((Object)((Object)this$executionMode)).equals((Object)other$executionMode)) {
            return false;
        }
        List<String> this$shardAddresses = this.getShardAddresses();
        List<String> other$shardAddresses = other.getShardAddresses();
        if (this$shardAddresses == null ? other$shardAddresses != null : !((Object)this$shardAddresses).equals(other$shardAddresses)) {
            return false;
        }
        List<String> this$backupAddresses = this.getBackupAddresses();
        List<String> other$backupAddresses = other.getBackupAddresses();
        if (this$backupAddresses == null ? other$backupAddresses != null : !((Object)this$backupAddresses).equals(other$backupAddresses)) {
            return false;
        }
        TransportType this$transportType = this.getTransportType();
        TransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        String this$networkMask = this.getNetworkMask();
        String other$networkMask = other.getNetworkMask();
        if (this$networkMask == null ? other$networkMask != null : !this$networkMask.equals(other$networkMask)) {
            return false;
        }
        String this$multicastNetwork = this.getMulticastNetwork();
        String other$multicastNetwork = other.getMulticastNetwork();
        if (this$multicastNetwork == null ? other$multicastNetwork != null : !this$multicastNetwork.equals(other$multicastNetwork)) {
            return false;
        }
        String this$multicastInterface = this.getMulticastInterface();
        String other$multicastInterface = other.getMulticastInterface();
        if (this$multicastInterface == null ? other$multicastInterface != null : !this$multicastInterface.equals(other$multicastInterface)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        NodeRole this$forcedRole = this.getForcedRole();
        NodeRole other$forcedRole = other.getForcedRole();
        if (this$forcedRole == null ? other$forcedRole != null : !((Object)((Object)this$forcedRole)).equals((Object)other$forcedRole)) {
            return false;
        }
        if (this.isUseHS() != other.isUseHS()) {
            return false;
        }
        if (this.isUseNS() != other.isUseNS()) {
            return false;
        }
        if (this.getRetransmitTimeout() != other.getRetransmitTimeout()) {
            return false;
        }
        if (this.getResponseTimeframe() != other.getResponseTimeframe()) {
            return false;
        }
        if (this.getResponseTimeout() != other.getResponseTimeout()) {
            return false;
        }
        String this$controllerAddress = this.getControllerAddress();
        String other$controllerAddress = other.getControllerAddress();
        return !(this$controllerAddress == null ? other$controllerAddress != null : !this$controllerAddress.equals(other$controllerAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoidConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStreamId();
        result = result * 59 + this.getUnicastPort();
        result = result * 59 + this.getMulticastPort();
        result = result * 59 + this.getNumberOfShards();
        FaultToleranceStrategy $faultToleranceStrategy = this.getFaultToleranceStrategy();
        result = result * 59 + ($faultToleranceStrategy == null ? 43 : ((Object)((Object)$faultToleranceStrategy)).hashCode());
        ExecutionMode $executionMode = this.getExecutionMode();
        result = result * 59 + ($executionMode == null ? 43 : ((Object)((Object)$executionMode)).hashCode());
        List<String> $shardAddresses = this.getShardAddresses();
        result = result * 59 + ($shardAddresses == null ? 43 : ((Object)$shardAddresses).hashCode());
        List<String> $backupAddresses = this.getBackupAddresses();
        result = result * 59 + ($backupAddresses == null ? 43 : ((Object)$backupAddresses).hashCode());
        TransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        String $networkMask = this.getNetworkMask();
        result = result * 59 + ($networkMask == null ? 43 : $networkMask.hashCode());
        String $multicastNetwork = this.getMulticastNetwork();
        result = result * 59 + ($multicastNetwork == null ? 43 : $multicastNetwork.hashCode());
        String $multicastInterface = this.getMulticastInterface();
        result = result * 59 + ($multicastInterface == null ? 43 : $multicastInterface.hashCode());
        result = result * 59 + this.getTtl();
        NodeRole $forcedRole = this.getForcedRole();
        result = result * 59 + ($forcedRole == null ? 43 : ((Object)((Object)$forcedRole)).hashCode());
        result = result * 59 + (this.isUseHS() ? 79 : 97);
        result = result * 59 + (this.isUseNS() ? 79 : 97);
        long $retransmitTimeout = this.getRetransmitTimeout();
        result = result * 59 + (int)($retransmitTimeout >>> 32 ^ $retransmitTimeout);
        long $responseTimeframe = this.getResponseTimeframe();
        result = result * 59 + (int)($responseTimeframe >>> 32 ^ $responseTimeframe);
        long $responseTimeout = this.getResponseTimeout();
        result = result * 59 + (int)($responseTimeout >>> 32 ^ $responseTimeout);
        String $controllerAddress = this.getControllerAddress();
        result = result * 59 + ($controllerAddress == null ? 43 : $controllerAddress.hashCode());
        return result;
    }

    public String toString() {
        return "VoidConfiguration(streamId=" + this.getStreamId() + ", unicastPort=" + this.getUnicastPort() + ", multicastPort=" + this.getMulticastPort() + ", numberOfShards=" + this.getNumberOfShards() + ", faultToleranceStrategy=" + (Object)((Object)this.getFaultToleranceStrategy()) + ", executionMode=" + (Object)((Object)this.getExecutionMode()) + ", shardAddresses=" + this.getShardAddresses() + ", backupAddresses=" + this.getBackupAddresses() + ", transportType=" + (Object)((Object)this.getTransportType()) + ", networkMask=" + this.getNetworkMask() + ", multicastNetwork=" + this.getMulticastNetwork() + ", multicastInterface=" + this.getMulticastInterface() + ", ttl=" + this.getTtl() + ", forcedRole=" + (Object)((Object)this.getForcedRole()) + ", useHS=" + this.isUseHS() + ", useNS=" + this.isUseNS() + ", retransmitTimeout=" + this.getRetransmitTimeout() + ", responseTimeframe=" + this.getResponseTimeframe() + ", responseTimeout=" + this.getResponseTimeout() + ", controllerAddress=" + this.getControllerAddress() + ")";
    }

    public static class VoidConfigurationBuilder {
        private boolean streamId$set;
        private int streamId;
        private boolean unicastPort$set;
        private int unicastPort;
        private boolean multicastPort$set;
        private int multicastPort;
        private boolean numberOfShards$set;
        private int numberOfShards;
        private boolean faultToleranceStrategy$set;
        private FaultToleranceStrategy faultToleranceStrategy;
        private boolean executionMode$set;
        private ExecutionMode executionMode;
        private boolean shardAddresses$set;
        private List<String> shardAddresses;
        private boolean backupAddresses$set;
        private List<String> backupAddresses;
        private boolean transportType$set;
        private TransportType transportType;
        private String networkMask;
        private boolean multicastNetwork$set;
        private String multicastNetwork;
        private String multicastInterface;
        private boolean ttl$set;
        private int ttl;
        private NodeRole forcedRole;
        private boolean useHS;
        private boolean useNS;
        private boolean retransmitTimeout$set;
        private long retransmitTimeout;
        private boolean responseTimeframe$set;
        private long responseTimeframe;
        private boolean responseTimeout$set;
        private long responseTimeout;
        private String controllerAddress;

        VoidConfigurationBuilder() {
        }

        public VoidConfigurationBuilder streamId(int streamId) {
            this.streamId = streamId;
            this.streamId$set = true;
            return this;
        }

        public VoidConfigurationBuilder unicastPort(int unicastPort) {
            this.unicastPort = unicastPort;
            this.unicastPort$set = true;
            return this;
        }

        public VoidConfigurationBuilder multicastPort(int multicastPort) {
            this.multicastPort = multicastPort;
            this.multicastPort$set = true;
            return this;
        }

        public VoidConfigurationBuilder numberOfShards(int numberOfShards) {
            this.numberOfShards = numberOfShards;
            this.numberOfShards$set = true;
            return this;
        }

        public VoidConfigurationBuilder faultToleranceStrategy(FaultToleranceStrategy faultToleranceStrategy) {
            this.faultToleranceStrategy = faultToleranceStrategy;
            this.faultToleranceStrategy$set = true;
            return this;
        }

        public VoidConfigurationBuilder executionMode(ExecutionMode executionMode) {
            this.executionMode = executionMode;
            this.executionMode$set = true;
            return this;
        }

        public VoidConfigurationBuilder shardAddresses(List<String> shardAddresses) {
            this.shardAddresses = shardAddresses;
            this.shardAddresses$set = true;
            return this;
        }

        public VoidConfigurationBuilder backupAddresses(List<String> backupAddresses) {
            this.backupAddresses = backupAddresses;
            this.backupAddresses$set = true;
            return this;
        }

        public VoidConfigurationBuilder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.transportType$set = true;
            return this;
        }

        public VoidConfigurationBuilder networkMask(String networkMask) {
            this.networkMask = networkMask;
            return this;
        }

        public VoidConfigurationBuilder multicastNetwork(String multicastNetwork) {
            this.multicastNetwork = multicastNetwork;
            this.multicastNetwork$set = true;
            return this;
        }

        public VoidConfigurationBuilder multicastInterface(String multicastInterface) {
            this.multicastInterface = multicastInterface;
            return this;
        }

        public VoidConfigurationBuilder ttl(int ttl) {
            this.ttl = ttl;
            this.ttl$set = true;
            return this;
        }

        public VoidConfigurationBuilder forcedRole(NodeRole forcedRole) {
            this.forcedRole = forcedRole;
            return this;
        }

        @Deprecated
        public VoidConfigurationBuilder useHS(boolean useHS) {
            this.useHS = useHS;
            return this;
        }

        @Deprecated
        public VoidConfigurationBuilder useNS(boolean useNS) {
            this.useNS = useNS;
            return this;
        }

        public VoidConfigurationBuilder retransmitTimeout(long retransmitTimeout) {
            this.retransmitTimeout = retransmitTimeout;
            this.retransmitTimeout$set = true;
            return this;
        }

        public VoidConfigurationBuilder responseTimeframe(long responseTimeframe) {
            this.responseTimeframe = responseTimeframe;
            this.responseTimeframe$set = true;
            return this;
        }

        public VoidConfigurationBuilder responseTimeout(long responseTimeout) {
            this.responseTimeout = responseTimeout;
            this.responseTimeout$set = true;
            return this;
        }

        public VoidConfigurationBuilder controllerAddress(String controllerAddress) {
            this.controllerAddress = controllerAddress;
            return this;
        }

        public VoidConfiguration build() {
            return new VoidConfiguration(this.streamId$set ? this.streamId : VoidConfiguration.$default$streamId(), this.unicastPort$set ? this.unicastPort : VoidConfiguration.$default$unicastPort(), this.multicastPort$set ? this.multicastPort : VoidConfiguration.$default$multicastPort(), this.numberOfShards$set ? this.numberOfShards : VoidConfiguration.$default$numberOfShards(), this.faultToleranceStrategy$set ? this.faultToleranceStrategy : VoidConfiguration.$default$faultToleranceStrategy(), this.executionMode$set ? this.executionMode : VoidConfiguration.$default$executionMode(), this.shardAddresses$set ? this.shardAddresses : VoidConfiguration.$default$shardAddresses(), this.backupAddresses$set ? this.backupAddresses : VoidConfiguration.$default$backupAddresses(), this.transportType$set ? this.transportType : VoidConfiguration.$default$transportType(), this.networkMask, this.multicastNetwork$set ? this.multicastNetwork : VoidConfiguration.$default$multicastNetwork(), this.multicastInterface, this.ttl$set ? this.ttl : VoidConfiguration.$default$ttl(), this.forcedRole, this.useHS, this.useNS, this.retransmitTimeout$set ? this.retransmitTimeout : VoidConfiguration.$default$retransmitTimeout(), this.responseTimeframe$set ? this.responseTimeframe : VoidConfiguration.$default$responseTimeframe(), this.responseTimeout$set ? this.responseTimeout : VoidConfiguration.$default$responseTimeout(), this.controllerAddress);
        }

        public String toString() {
            return "VoidConfiguration.VoidConfigurationBuilder(streamId=" + this.streamId + ", unicastPort=" + this.unicastPort + ", multicastPort=" + this.multicastPort + ", numberOfShards=" + this.numberOfShards + ", faultToleranceStrategy=" + (Object)((Object)this.faultToleranceStrategy) + ", executionMode=" + (Object)((Object)this.executionMode) + ", shardAddresses=" + this.shardAddresses + ", backupAddresses=" + this.backupAddresses + ", transportType=" + (Object)((Object)this.transportType) + ", networkMask=" + this.networkMask + ", multicastNetwork=" + this.multicastNetwork + ", multicastInterface=" + this.multicastInterface + ", ttl=" + this.ttl + ", forcedRole=" + (Object)((Object)this.forcedRole) + ", useHS=" + this.useHS + ", useNS=" + this.useNS + ", retransmitTimeout=" + this.retransmitTimeout + ", responseTimeframe=" + this.responseTimeframe + ", responseTimeout=" + this.responseTimeout + ", controllerAddress=" + this.controllerAddress + ")";
        }
    }
}

