/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic;

import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.messages.TrainingMessage;
import org.nd4j.parameterserver.distributed.transport.Transport;

public interface RetransmissionHandler {
    public void init(VoidConfiguration var1, Transport var2);

    public void handleMessage(TrainingMessage var1);

    public void onBackPressure();

    public static TransmissionStatus getTransmissionStatus(long resp) {
        if (resp >= 0L) {
            return TransmissionStatus.MESSAGE_SENT;
        }
        if (resp == -1L) {
            return TransmissionStatus.NOT_CONNECTED;
        }
        if (resp == -2L) {
            return TransmissionStatus.BACKPRESSURE;
        }
        if (resp == -3L) {
            return TransmissionStatus.ADMIN_ACTION;
        }
        throw new ND4JIllegalStateException("Unknown response from Aeron received: [" + resp + "]");
    }

    public static enum TransmissionStatus {
        MESSAGE_SENT,
        NOT_CONNECTED,
        BACKPRESSURE,
        ADMIN_ACTION;

    }
}

