/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic.completion;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.parameterserver.distributed.logic.completion.RequestDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameCompletionHandler {
    private static final Logger log = LoggerFactory.getLogger(FrameCompletionHandler.class);
    private Map<RequestDescriptor, FrameDescriptor> frames = new ConcurrentHashMap<RequestDescriptor, FrameDescriptor>();

    public boolean isTrackingFrame(RequestDescriptor descriptor) {
        return this.frames.containsKey(descriptor);
    }

    public boolean isTrackingFrame(long originatorId, long frameId) {
        return this.frames.containsKey(RequestDescriptor.createDescriptor(originatorId, frameId));
    }

    public void addHook(Long originatorId, Long frameId, Long messageId) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(originatorId, frameId);
        if (!this.frames.containsKey(descriptor)) {
            this.frames.put(descriptor, new FrameDescriptor(originatorId));
        }
        this.frames.get(descriptor).addMessage(messageId);
    }

    public void notifyFrame(RequestDescriptor descriptor, Long messageId) {
        FrameDescriptor frameDescriptor = this.frames.get(descriptor);
        if (frameDescriptor != null) {
            frameDescriptor.finishedMessage(messageId);
        }
    }

    public void notifyFrame(Long originatorId, Long frameId, Long messageId) {
        this.notifyFrame(RequestDescriptor.createDescriptor(originatorId, frameId), messageId);
    }

    public boolean isCompleted(RequestDescriptor descriptor) {
        if (this.isTrackingFrame(descriptor)) {
            FrameDescriptor frameDescriptor = this.frames.get(descriptor);
            if (frameDescriptor == null) {
                return false;
            }
            return frameDescriptor.isFinished();
        }
        log.warn("DOUBLE SPENDING!!!");
        return false;
    }

    public boolean isCompleted(long originatorId, long frameId) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(originatorId, frameId);
        return this.isCompleted(descriptor);
    }

    public FrameDescriptor getCompletedFrameInfo(RequestDescriptor descriptor) {
        try {
            FrameDescriptor frameDescriptor = this.frames.get(descriptor);
            return frameDescriptor;
        }
        finally {
            this.frames.remove(descriptor);
        }
    }

    public FrameDescriptor getCompletedFrameInfo(long originatorId, long frameId) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(originatorId, frameId);
        return this.getCompletedFrameInfo(descriptor);
    }

    public static class FrameDescriptor {
        private long frameOriginatorId;
        private Map<Long, AtomicBoolean> states = new ConcurrentHashMap<Long, AtomicBoolean>();
        private AtomicInteger messages = new AtomicInteger(0);
        private AtomicInteger finished = new AtomicInteger(0);

        public FrameDescriptor(long frameOriginatorId) {
            this.frameOriginatorId = frameOriginatorId;
        }

        public boolean isFinished() {
            return this.messages.get() == this.finished.get();
        }

        public void addMessage(Long messageId) {
            this.states.put(messageId, new AtomicBoolean(false));
            this.messages.incrementAndGet();
        }

        public void finishedMessage(Long messageId) {
            AtomicBoolean boo = this.states.get(messageId);
            if (boo != null) {
                boo.set(true);
            }
            this.finished.incrementAndGet();
        }

        public int getIncompleteNumber() {
            return this.messages.get() - this.finished.get();
        }

        public long getFrameOriginatorId() {
            return this.frameOriginatorId;
        }
    }
}

