/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic.routing;

import lombok.NonNull;
import org.nd4j.linalg.util.HashUtil;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.logic.ClientRouter;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRouter
implements ClientRouter {
    private static final Logger log = LoggerFactory.getLogger(BaseRouter.class);
    protected VoidConfiguration voidConfiguration;
    protected Transport transport;
    protected transient long originatorIdx = 0L;

    @Override
    public void init(@NonNull VoidConfiguration voidConfiguration, @NonNull Transport transport) {
        if (voidConfiguration == null) {
            throw new NullPointerException("voidConfiguration");
        }
        if (transport == null) {
            throw new NullPointerException("transport");
        }
        this.voidConfiguration = voidConfiguration;
        this.transport = transport;
    }

    @Override
    public void setOriginator(VoidMessage message) {
        if (this.originatorIdx == 0L) {
            this.originatorIdx = HashUtil.getLongHash((String)(this.transport.getIp() + ":" + this.transport.getPort()));
        }
        message.setOriginatorId(this.originatorIdx);
    }
}

