/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic.routing;

import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.logic.routing.BaseRouter;
import org.nd4j.parameterserver.distributed.messages.Frame;
import org.nd4j.parameterserver.distributed.messages.TrainingMessage;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.messages.requests.SkipGramRequestMessage;
import org.nd4j.parameterserver.distributed.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterleavedRouter
extends BaseRouter {
    private static final Logger log = LoggerFactory.getLogger(InterleavedRouter.class);
    protected short targetIndex = (short)-1;
    protected AtomicLong counter = new AtomicLong(0L);

    public InterleavedRouter() {
    }

    public InterleavedRouter(int defaultIndex) {
        this();
        this.targetIndex = (short)defaultIndex;
    }

    @Override
    public void init(@NonNull VoidConfiguration voidConfiguration, @NonNull Transport transport) {
        if (voidConfiguration == null) {
            throw new NullPointerException("voidConfiguration");
        }
        if (transport == null) {
            throw new NullPointerException("transport");
        }
        super.init(voidConfiguration, transport);
        if (this.targetIndex < 0) {
            this.targetIndex = (short)RandomUtils.nextInt((int)0, (int)voidConfiguration.getNumberOfShards());
        }
    }

    @Override
    public int assignTarget(TrainingMessage message) {
        this.setOriginator(message);
        if (message instanceof SkipGramRequestMessage) {
            SkipGramRequestMessage sgrm = (SkipGramRequestMessage)message;
            int w1 = sgrm.getW1();
            if (w1 >= this.voidConfiguration.getNumberOfShards()) {
                message.setTargetId((short)(w1 % this.voidConfiguration.getNumberOfShards()));
            } else {
                message.setTargetId((short)w1);
            }
        } else {
            message.setTargetId((short)Math.abs(this.counter.incrementAndGet() % (long)this.voidConfiguration.getNumberOfShards()));
        }
        return message.getTargetId();
    }

    @Override
    public int assignTarget(VoidMessage message) {
        this.setOriginator(message);
        if (message instanceof Frame) {
            message.setTargetId((short)Math.abs(this.counter.incrementAndGet() % (long)this.voidConfiguration.getNumberOfShards()));
        } else {
            message.setTargetId(this.targetIndex);
        }
        return message.getTargetId();
    }
}

