/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic.storage;

import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.parameterserver.distributed.logic.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStorage
implements Storage {
    private static final Logger log = LoggerFactory.getLogger(BaseStorage.class);
    private ConcurrentHashMap<Integer, INDArray> storage = new ConcurrentHashMap();

    @Override
    public INDArray getArray(@NonNull Integer key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.storage.get(key);
    }

    @Override
    public void setArray(@NonNull Integer key, @NonNull INDArray array) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (array == null) {
            throw new NullPointerException("array");
        }
        this.storage.put(key, array);
    }

    @Override
    public boolean arrayExists(@NonNull Integer key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.storage.containsKey(key);
    }

    @Override
    public void shutdown() {
        this.storage.clear();
    }
}

