/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages.aggregations;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.parameterserver.distributed.messages.VoidAggregation;
import org.nd4j.parameterserver.distributed.messages.aggregations.BaseAggregation;
import org.nd4j.parameterserver.distributed.messages.complete.VectorCompleteMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorAggregation
extends BaseAggregation {
    private static final Logger log = LoggerFactory.getLogger(VectorAggregation.class);

    protected VectorAggregation() {
    }

    public VectorAggregation(long taskId, short aggregationWidth, short shardIndex, INDArray array) {
        super(taskId, aggregationWidth, shardIndex);
        this.payload = array.isView() ? array.dup(array.ordering()) : array;
        this.addToChunks(this.payload);
    }

    @Override
    public void processMessage() {
        if (this.clipboard.isTracking(this.originatorId, this.getTaskId())) {
            this.clipboard.pin(this);
            if (this.clipboard.isReady(this.originatorId, this.taskId)) {
                VoidAggregation aggregation = this.clipboard.unpin(this.originatorId, this.taskId);
                if (aggregation == null) {
                    return;
                }
                VectorCompleteMessage msg = new VectorCompleteMessage(this.taskId, aggregation.getAccumulatedResult());
                msg.setOriginatorId(aggregation.getOriginatorId());
                this.transport.sendMessage(msg);
            }
        }
    }
}

