/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages.intercom;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.parameterserver.distributed.messages.BaseVoidMessage;
import org.nd4j.parameterserver.distributed.messages.DistributedMessage;

public class DistributedAssignMessage
extends BaseVoidMessage
implements DistributedMessage {
    private int index;
    private double value;
    private Integer key;
    private INDArray payload;

    protected DistributedAssignMessage() {
    }

    public DistributedAssignMessage(@NonNull Integer key, int index, double value) {
        super(6);
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.index = index;
        this.value = value;
        this.key = key;
    }

    public DistributedAssignMessage(@NonNull Integer key, INDArray payload) {
        super(6);
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.key = key;
        this.payload = payload;
    }

    @Override
    public void processMessage() {
        if (this.payload != null) {
            if (this.storage.arrayExists(this.key) && this.storage.getArray(this.key).length() == this.payload.length()) {
                this.storage.getArray(this.key).assign(this.payload);
            } else {
                this.storage.setArray(this.key, this.payload);
            }
        } else if (this.index >= 0) {
            if (this.storage.getArray(this.key) == null) {
                throw new RuntimeException("Init wasn't called before for key [" + this.key + "]");
            }
            this.storage.getArray(this.key).getRow(this.index).assign((Number)this.value);
        } else {
            this.storage.getArray(this.key).assign((Number)this.value);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public double getValue() {
        return this.value;
    }

    public Integer getKey() {
        return this.key;
    }

    public INDArray getPayload() {
        return this.payload;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public void setPayload(INDArray payload) {
        this.payload = payload;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistributedAssignMessage)) {
            return false;
        }
        DistributedAssignMessage other = (DistributedAssignMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        Integer this$key = this.getKey();
        Integer other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        INDArray this$payload = this.getPayload();
        INDArray other$payload = other.getPayload();
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DistributedAssignMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        Integer $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        INDArray $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DistributedAssignMessage(index=" + this.getIndex() + ", value=" + this.getValue() + ", key=" + this.getKey() + ", payload=" + this.getPayload() + ")";
    }
}

