/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages.intercom;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.parameterserver.distributed.messages.BaseVoidMessage;
import org.nd4j.parameterserver.distributed.messages.DistributedMessage;

public class DistributedSolidMessage
extends BaseVoidMessage
implements DistributedMessage {
    private Integer key;
    private INDArray payload;
    private boolean overwrite;

    public DistributedSolidMessage(@NonNull Integer key, @NonNull INDArray array, boolean overwrite) {
        super(5);
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (array == null) {
            throw new NullPointerException("array");
        }
        this.payload = array;
        this.key = key;
        this.overwrite = overwrite;
    }

    @Override
    public void processMessage() {
        if (this.overwrite) {
            this.storage.setArray(this.key, this.payload);
        } else if (!this.storage.arrayExists(this.key)) {
            this.storage.setArray(this.key, this.payload);
        }
    }

    public Integer getKey() {
        return this.key;
    }

    public INDArray getPayload() {
        return this.payload;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public void setPayload(INDArray payload) {
        this.payload = payload;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistributedSolidMessage)) {
            return false;
        }
        DistributedSolidMessage other = (DistributedSolidMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$key = this.getKey();
        Integer other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        INDArray this$payload = this.getPayload();
        INDArray other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        return this.isOverwrite() == other.isOverwrite();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DistributedSolidMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        INDArray $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        result = result * 59 + (this.isOverwrite() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "DistributedSolidMessage(key=" + this.getKey() + ", payload=" + this.getPayload() + ", overwrite=" + this.isOverwrite() + ")";
    }

    public DistributedSolidMessage() {
    }
}

