/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages.requests;

import org.nd4j.parameterserver.distributed.messages.BaseVoidMessage;
import org.nd4j.parameterserver.distributed.messages.RequestMessage;
import org.nd4j.parameterserver.distributed.messages.aggregations.InitializationAggregation;
import org.nd4j.parameterserver.distributed.messages.intercom.DistributedInitializationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializationRequestMessage
extends BaseVoidMessage
implements RequestMessage {
    private static final Logger log = LoggerFactory.getLogger(InitializationRequestMessage.class);
    protected int vectorLength;
    protected int numWords;
    protected long seed;
    protected boolean useHs;
    protected boolean useNeg;
    protected int columnsPerShard;

    protected InitializationRequestMessage() {
        super(4);
        this.taskId = -119L;
    }

    public InitializationRequestMessage(int vectorLength, int numWords, long seed, boolean useHs, boolean useNeg, int columnsPerShard) {
        this();
        this.vectorLength = vectorLength;
        this.numWords = numWords;
        this.seed = seed;
        this.useHs = useHs;
        this.useNeg = useNeg;
        this.columnsPerShard = columnsPerShard;
    }

    @Override
    public void processMessage() {
        DistributedInitializationMessage dim = new DistributedInitializationMessage(this.vectorLength, this.numWords, this.seed, this.useHs, this.useNeg, this.columnsPerShard);
        InitializationAggregation aggregation = new InitializationAggregation((short)this.voidConfiguration.getNumberOfShards(), this.transport.getShardIndex());
        aggregation.setOriginatorId(this.originatorId);
        this.clipboard.pin(aggregation);
        dim.setOriginatorId(this.originatorId);
        dim.extractContext(this);
        dim.processMessage();
        if (this.voidConfiguration.getNumberOfShards() > 1) {
            this.transport.sendMessageToAllShards(dim);
        }
    }

    @Override
    public boolean isBlockingMessage() {
        return true;
    }

    public static InitializationRequestMessageBuilder builder() {
        return new InitializationRequestMessageBuilder();
    }

    public static class InitializationRequestMessageBuilder {
        private int vectorLength;
        private int numWords;
        private long seed;
        private boolean useHs;
        private boolean useNeg;
        private int columnsPerShard;

        InitializationRequestMessageBuilder() {
        }

        public InitializationRequestMessageBuilder vectorLength(int vectorLength) {
            this.vectorLength = vectorLength;
            return this;
        }

        public InitializationRequestMessageBuilder numWords(int numWords) {
            this.numWords = numWords;
            return this;
        }

        public InitializationRequestMessageBuilder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public InitializationRequestMessageBuilder useHs(boolean useHs) {
            this.useHs = useHs;
            return this;
        }

        public InitializationRequestMessageBuilder useNeg(boolean useNeg) {
            this.useNeg = useNeg;
            return this;
        }

        public InitializationRequestMessageBuilder columnsPerShard(int columnsPerShard) {
            this.columnsPerShard = columnsPerShard;
            return this;
        }

        public InitializationRequestMessage build() {
            return new InitializationRequestMessage(this.vectorLength, this.numWords, this.seed, this.useHs, this.useNeg, this.columnsPerShard);
        }

        public String toString() {
            return "InitializationRequestMessage.InitializationRequestMessageBuilder(vectorLength=" + this.vectorLength + ", numWords=" + this.numWords + ", seed=" + this.seed + ", useHs=" + this.useHs + ", useNeg=" + this.useNeg + ", columnsPerShard=" + this.columnsPerShard + ")";
        }
    }
}

