/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.messages.requests;

import lombok.NonNull;
import org.nd4j.parameterserver.distributed.logic.storage.WordVectorStorage;
import org.nd4j.parameterserver.distributed.messages.BaseVoidMessage;
import org.nd4j.parameterserver.distributed.messages.RequestMessage;
import org.nd4j.parameterserver.distributed.messages.aggregations.VectorAggregation;
import org.nd4j.parameterserver.distributed.messages.intercom.DistributedVectorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorRequestMessage
extends BaseVoidMessage
implements RequestMessage {
    private static final Logger log = LoggerFactory.getLogger(VectorRequestMessage.class);
    protected Integer key;
    protected int rowIndex;

    protected VectorRequestMessage() {
        super(7);
    }

    public VectorRequestMessage(int rowIndex) {
        this(WordVectorStorage.SYN_0, rowIndex);
    }

    public VectorRequestMessage(@NonNull Integer key, int rowIndex) {
        this();
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.rowIndex = rowIndex;
        this.taskId = rowIndex;
        this.key = key;
    }

    @Override
    public void processMessage() {
        VectorAggregation aggregation = new VectorAggregation(this.rowIndex, (short)this.voidConfiguration.getNumberOfShards(), this.getShardIndex(), this.storage.getArray(this.key).getRow(this.rowIndex).dup());
        aggregation.setOriginatorId(this.getOriginatorId());
        this.clipboard.pin(aggregation);
        DistributedVectorMessage dvm = new DistributedVectorMessage(this.key, this.rowIndex);
        dvm.setOriginatorId(this.originatorId);
        if (this.voidConfiguration.getNumberOfShards() > 1) {
            this.transport.sendMessageToAllShards(dvm);
        } else {
            aggregation.extractContext(this);
            aggregation.processMessage();
        }
    }

    @Override
    public boolean isBlockingMessage() {
        return true;
    }

    public Integer getKey() {
        return this.key;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorRequestMessage)) {
            return false;
        }
        VectorRequestMessage other = (VectorRequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$key = this.getKey();
        Integer other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        return this.getRowIndex() == other.getRowIndex();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VectorRequestMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        result = result * 59 + this.getRowIndex();
        return result;
    }

    @Override
    public String toString() {
        return "VectorRequestMessage(key=" + this.getKey() + ", rowIndex=" + this.getRowIndex() + ")";
    }
}

