/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.training.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.parameterserver.distributed.enums.ExecutionMode;
import org.nd4j.parameterserver.distributed.logic.completion.FrameCompletionHandler;
import org.nd4j.parameterserver.distributed.logic.completion.RequestDescriptor;
import org.nd4j.parameterserver.distributed.logic.storage.WordVectorStorage;
import org.nd4j.parameterserver.distributed.messages.VoidAggregation;
import org.nd4j.parameterserver.distributed.messages.aggregations.DotAggregation;
import org.nd4j.parameterserver.distributed.messages.complete.FrameCompleteMessage;
import org.nd4j.parameterserver.distributed.messages.intercom.DistributedCbowDotMessage;
import org.nd4j.parameterserver.distributed.messages.requests.CbowRequestMessage;
import org.nd4j.parameterserver.distributed.training.BaseTrainer;
import org.nd4j.parameterserver.distributed.training.chains.CbowChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbowTrainer
extends BaseTrainer<CbowRequestMessage> {
    private static final Logger log = LoggerFactory.getLogger(CbowTrainer.class);
    private static final float HS_MAX_EXP = 6.0f;
    protected Map<RequestDescriptor, CbowChain> chains = new ConcurrentHashMap<RequestDescriptor, CbowChain>();
    protected AtomicLong cntRounds = new AtomicLong(0L);

    @Override
    public void startTraining(CbowRequestMessage message) {
        CbowChain chain = new CbowChain(message);
        chain.addElement(message);
        this.chains.put(RequestDescriptor.createDescriptor(message.getOriginatorId(), message.getTaskId()), chain);
        int[] row_syn1 = message.getSyn1rows();
        if (message.getNegSamples() > 0) {
            int rows = this.storage.getArray(WordVectorStorage.SYN_0).rows();
            int[] tempArray = new int[message.getNegSamples() + 1];
            tempArray[0] = message.getW1();
            for (int e = 1; e < message.getNegSamples() + 1; ++e) {
                int rnd;
                while ((rnd = RandomUtils.nextInt((int)0, (int)rows)) == message.getW1()) {
                }
                tempArray[e] = rnd;
            }
            row_syn1 = ArrayUtils.addAll((int[])row_syn1, (int[])tempArray);
            message.setNegatives(tempArray);
        }
        if (message.getSyn0rows() == null || message.getSyn0rows().length < 1) {
            throw new RuntimeException("Empty syn0rows!");
        }
        DistributedCbowDotMessage dcdm = new DistributedCbowDotMessage(message.getTaskId(), message.getSyn0rows(), row_syn1, message.getW1(), message.getCodes(), message.getCodes().length > 0, (short)message.getNegSamples(), (float)message.getAlpha());
        dcdm.setTargetId((short)-1);
        dcdm.setOriginatorId(message.getOriginatorId());
        if (this.voidConfiguration.getExecutionMode() == ExecutionMode.AVERAGING) {
            this.transport.putMessage(dcdm);
        } else if (this.voidConfiguration.getExecutionMode() == ExecutionMode.SHARDED) {
            this.transport.sendMessage(dcdm);
        }
    }

    @Override
    public void pickTraining(CbowRequestMessage message) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(message.getOriginatorId(), message.getTaskId());
        if (!this.chains.containsKey(descriptor)) {
            CbowChain chain = new CbowChain(message);
            chain.addElement(message);
            this.chains.put(descriptor, chain);
        }
    }

    @Override
    public void aggregationFinished(VoidAggregation aggregation) {
        CbowChain chain = this.chains.get(RequestDescriptor.createDescriptor(aggregation.getOriginatorId(), aggregation.getTaskId()));
        if (chain == null) {
            throw new RuntimeException("sI_" + this.transport.getShardIndex() + " Unable to find chain for specified originatorId: [" + aggregation.getOriginatorId() + "]; taskId: [" + aggregation.getTaskId() + "]");
        }
        chain.addElement((DotAggregation)aggregation);
        this.finishTraining(aggregation.getOriginatorId(), aggregation.getTaskId());
    }

    @Override
    public void finishTraining(long originatorId, long taskId) {
        RequestDescriptor descriptor;
        boolean updated;
        INDArray neu1e;
        INDArray syn0;
        CbowRequestMessage cbr;
        CbowChain chain;
        RequestDescriptor chainDesc;
        block14: {
            int e;
            chainDesc = RequestDescriptor.createDescriptor(originatorId, taskId);
            chain = this.chains.get(chainDesc);
            if (chain == null) {
                throw new RuntimeException("Unable to find chain for specified taskId: [" + taskId + "]");
            }
            cbr = chain.getCbowRequest();
            double alpha = cbr.getAlpha();
            INDArray expTable = this.storage.getArray(WordVectorStorage.EXP_TABLE);
            INDArray dots = chain.getDotAggregation().getAccumulatedResult();
            syn0 = this.storage.getArray(WordVectorStorage.SYN_0);
            INDArray syn1 = this.storage.getArray(WordVectorStorage.SYN_1);
            INDArray syn1Neg = this.storage.getArray(WordVectorStorage.SYN_1_NEGATIVE);
            INDArray words = Nd4j.pullRows((INDArray)this.storage.getArray(WordVectorStorage.SYN_0), (int)1, (int[])cbr.getSyn0rows(), (char)'c');
            INDArray neue = words.mean(new int[]{0});
            neu1e = Nd4j.create((int)syn0.columns());
            updated = false;
            if (cbr.getCodes().length > 0) {
                for (e = 0; e < cbr.getCodes().length; ++e) {
                    int idx;
                    float dot = dots.getFloat(e);
                    if (dot < -6.0f || dot >= 6.0f || (idx = (int)((double)(dot + 6.0f) * ((double)((float)expTable.length() / 6.0f) / 2.0))) >= expTable.length() || idx < 0) continue;
                    byte code = cbr.getCodes()[e];
                    double f = expTable.getFloat(idx);
                    double g = ((double)(1 - code) - f) * alpha;
                    updated = true;
                    Nd4j.getBlasWrapper().axpy((Number)new Double(g), syn1.getRow(cbr.getSyn1rows()[e]), neu1e);
                    Nd4j.getBlasWrapper().axpy((Number)new Double(g), neue, syn1.getRow(cbr.getSyn1rows()[e]));
                }
            }
            if (cbr.getNegSamples() <= 0) break block14;
            int cnt = 0;
            while (e < cbr.getNegSamples() + 1) {
                block18: {
                    double g;
                    block16: {
                        float code;
                        float dot;
                        block17: {
                            block15: {
                                dot = dots.getFloat(e);
                                code = cnt == 0 ? 1.0f : 0.0f;
                                g = 0.0;
                                if (!(dot > 6.0f)) break block15;
                                g = (double)(code - 1.0f) * alpha;
                                break block16;
                            }
                            if (!(dot < -6.0f)) break block17;
                            g = (double)(code - 0.0f) * alpha;
                            break block16;
                        }
                        int idx = (int)((double)(dot + 6.0f) * ((double)((float)expTable.length() / 6.0f) / 2.0));
                        if (idx >= expTable.length() || idx < 0) break block18;
                        g = ((double)code - expTable.getDouble(idx)) * alpha;
                    }
                    updated = true;
                    Nd4j.getBlasWrapper().axpy((Number)new Double(g), syn1Neg.getRow(cbr.getNegatives()[cnt]), neu1e);
                    Nd4j.getBlasWrapper().axpy((Number)new Double(g), neue, syn1Neg.getRow(cbr.getNegatives()[cnt]));
                }
                ++e;
                ++cnt;
            }
        }
        if (updated) {
            for (int i = 0; i < cbr.getSyn0rows().length; ++i) {
                Nd4j.getBlasWrapper().axpy((Number)new Double(1.0), neu1e, syn0.getRow(cbr.getSyn0rows()[i]));
            }
        }
        if (this.completionHandler.isTrackingFrame(descriptor = RequestDescriptor.createDescriptor(chain.getOriginatorId(), chain.getFrameId()))) {
            this.completionHandler.notifyFrame(chain.getOriginatorId(), chain.getFrameId(), chain.getTaskId());
            if (this.completionHandler.isCompleted(descriptor)) {
                FrameCompletionHandler.FrameDescriptor frameDescriptor = this.completionHandler.getCompletedFrameInfo(descriptor);
                if (frameDescriptor != null) {
                    FrameCompleteMessage fcm = new FrameCompleteMessage(chain.getFrameId());
                    fcm.setOriginatorId(frameDescriptor.getFrameOriginatorId());
                    this.transport.sendMessage(fcm);
                } else {
                    log.warn("Frame double spending detected");
                }
            }
        }
        if (this.cntRounds.incrementAndGet() % 100000L == 0L) {
            log.info("{} training rounds finished...", (Object)this.cntRounds.get());
        }
        this.chains.remove(chainDesc);
    }

    @Override
    public String targetMessageClass() {
        return CbowRequestMessage.class.getSimpleName();
    }
}

