/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.ops;

import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.LinearViewNDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.cpu.javacpp.Loop;
import org.nd4j.linalg.cpu.util.ArgsConverter;

public class NativeOpExecutioner
extends DefaultOpExecutioner {
    private Loop loop = new Loop();

    public Op exec(Op op) {
        if (op.isPassThrough() || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            return super.exec(op);
        }
        if (op instanceof ScalarOp) {
            ScalarOp s = (ScalarOp)op;
            this.exec(s);
        } else if (op instanceof TransformOp) {
            TransformOp t = (TransformOp)op;
            this.exec(t);
        } else if (op instanceof Accumulation) {
            Accumulation ac = (Accumulation)op;
            this.exec(ac);
        } else if (op instanceof IndexAccumulation) {
            IndexAccumulation iac = (IndexAccumulation)op;
            this.exec((Op)iac);
        }
        return op;
    }

    private void exec(ScalarOp op) {
        if (op.x() instanceof IComplexNDArray || op.x() instanceof LinearViewNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            this.loop.execScalarDouble(op.x().data().asDouble(), op.z().data().asDouble(), op.n(), op.x().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), new double[]{op.scalar().doubleValue()});
        } else {
            this.loop.execScalarFloat(op.x().data().asFloat(), op.z().data().asFloat(), op.n(), op.x().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), new float[]{op.scalar().floatValue()});
        }
    }

    private void exec(TransformOp op) {
        if (op.x() instanceof IComplexNDArray || op.x() instanceof LinearViewNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.y() != null) {
                this.loop.execDoubleTransform(op.x().data().asDouble(), op.y().data().asDouble(), op.n(), op.x().offset(), op.y().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.y()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), ArgsConverter.convertExtraArgsDouble((Op)op), op.z().data().asDouble());
            } else {
                this.loop.execDoubleTransform(op.x().data().asDouble(), op.n(), op.x().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), ArgsConverter.convertExtraArgsDouble((Op)op), op.z().data().asDouble());
            }
        } else if (op.y() != null) {
            this.loop.execFloatTransform(op.x().data().asFloat(), op.y().data().asFloat(), op.n(), op.x().offset(), op.y().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.y()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), ArgsConverter.convertExtraArgsFloat((Op)op), op.z().data().asFloat());
        } else {
            this.loop.execFloatTransform(op.x().data().asFloat(), op.n(), op.x().offset(), op.z().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.z()), op.name(), ArgsConverter.convertExtraArgsFloat((Op)op), op.z().data().asFloat());
        }
    }

    private void exec(Accumulation op) {
        if (op.x() instanceof IComplexNDArray || op.x() instanceof LinearViewNDArray || this.executionMode() == OpExecutioner.ExecutionMode.JAVA) {
            super.exec((Op)op);
        } else if (op.x().data().dataType() == DataBuffer.Type.DOUBLE) {
            if (op.y() != null) {
                op.setFinalResult((Number)this.loop.reduce3(op.x().data().asDouble(), op.y().data().asDouble(), op.n(), op.x().offset(), op.y().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.y()), op.name(), ArgsConverter.convertExtraArgsDouble((Op)op)));
            } else {
                op.setFinalResult((Number)this.loop.reduce(op.x().data().asDouble(), op.n(), op.x().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), op.name(), ArgsConverter.convertExtraArgsDouble((Op)op)));
            }
        } else if (op.y() != null) {
            op.setFinalResult((Number)Float.valueOf(this.loop.reduce3Float(op.x().data().asFloat(), op.y().data().asFloat(), op.n(), op.x().offset(), op.y().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), BlasBufferUtil.getBlasStride((INDArray)op.y()), op.name(), ArgsConverter.convertExtraArgsFloat((Op)op))));
        } else {
            op.setFinalResult((Number)Float.valueOf(this.loop.reduceFloat(op.x().data().asFloat(), op.n(), op.x().offset(), BlasBufferUtil.getBlasStride((INDArray)op.x()), op.name(), ArgsConverter.convertExtraArgsFloat((Op)op))));
        }
    }
}

