/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.NativeSystemBLAS;
import java.lang.reflect.Field;
import org.nd4j.linalg.factory.BaseBlasWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlasWrapper
extends BaseBlasWrapper {
    private static final Logger log = LoggerFactory.getLogger(BlasWrapper.class);
    public static final String FORCE_NATIVE = "org.nd4j.linalg.cpu.force_native";

    static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    static {
        String forceNative = System.getProperty(FORCE_NATIVE, "false");
        if (Boolean.parseBoolean(forceNative)) {
            try {
                Field blasInstance = BLAS.class.getDeclaredField("INSTANCE");
                BLAS newInstance = (BLAS)Class.forName("com.github.fommil.netlib.NativeSystemBLAS").newInstance();
                BlasWrapper.setFinalStatic(blasInstance, newInstance);
            }
            catch (ClassNotFoundException e) {
                log.warn("Native BLAS not available on classpath");
            }
            catch (Exception e) {
                log.warn("unable to force native BLAS", (Throwable)e);
            }
        }
        if (!(BLAS.getInstance() instanceof NativeSystemBLAS)) {
            System.out.println("****************************************************************");
            System.out.println("WARNING: COULD NOT LOAD NATIVE SYSTEM BLAS");
            System.out.println("ND4J performance WILL be reduced");
            System.out.println("Please install native BLAS library such as OpenBLAS or IntelMKL");
            System.out.println("See http://nd4j.org/getstarted.html#open for further details");
            System.out.println("****************************************************************");
        }
    }
}

