/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.blas;

import com.github.fommil.netlib.BLAS;
import org.jblas.ComplexDouble;
import org.jblas.ComplexFloat;
import org.jblas.NativeBlas;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.impl.BaseLevel1;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cpu.util.CpuComplex;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;

public class CpuLevel1
extends BaseLevel1 {
    protected float sdsdot(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        return BLAS.getInstance().sdsdot(N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getFloatData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
    }

    protected double dsdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected float sdot(int N, INDArray X, int incX, INDArray Y, int incY) {
        return BLAS.getInstance().sdot(N, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getFloatData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
    }

    protected float sdot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        return BLAS.getInstance().sdot(N, this.getFloatData(X), offsetX, incX, this.getFloatData(Y), offsetY, incY);
    }

    protected double ddot(int N, INDArray X, int incX, INDArray Y, int incY) {
        return BLAS.getInstance().ddot(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
    }

    protected double ddot(int N, DataBuffer X, int offsetX, int incX, DataBuffer Y, int offsetY, int incY) {
        return BLAS.getInstance().ddot(N, this.getDoubleData(X), offsetX, incX, this.getDoubleData(Y), offsetY, incY);
    }

    protected void cdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void cdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    protected void zdotu_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotu) {
        throw new UnsupportedOperationException();
    }

    protected void zdotc_sub(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray dotc) {
        throw new UnsupportedOperationException();
    }

    protected float snrm2(int N, INDArray X, int incX) {
        return BLAS.getInstance().snrm2(N, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected float sasum(int N, INDArray X, int incX) {
        return BLAS.getInstance().sasum(N, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected float sasum(int N, DataBuffer X, int offsetX, int incX) {
        return BLAS.getInstance().sasum(N, this.getFloatData(X), offsetX, incX);
    }

    protected double dnrm2(int N, INDArray X, int incX) {
        return BLAS.getInstance().dnrm2(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected double dasum(int N, INDArray X, int incX) {
        return BLAS.getInstance().dasum(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected double dasum(int N, DataBuffer X, int offsetX, int incX) {
        return BLAS.getInstance().dasum(N, this.getDoubleData(X), offsetX, incX);
    }

    protected float scnrm2(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected float scasum(int N, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected double dznrm2(int N, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        return NativeBlas.dznrm2((int)N, (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
    }

    protected double dzasum(int N, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        return NativeBlas.dzasum((int)N, (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
    }

    protected int isamax(int N, INDArray X, int incX) {
        return BLAS.getInstance().isamax(N, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected int isamax(int N, DataBuffer X, int offsetX, int incX) {
        return BLAS.getInstance().isamax(N, this.getFloatData(X), offsetX, incX);
    }

    protected int idamax(int N, INDArray X, int incX) {
        return BLAS.getInstance().idamax(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX);
    }

    protected int idamax(int N, DataBuffer X, int offsetX, int incX) {
        return BLAS.getInstance().idamax(N, this.getDoubleData(X), offsetX, incX);
    }

    protected int icamax(int N, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        return NativeBlas.icamax((int)N, (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
    }

    protected int izamax(int N, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        return NativeBlas.izamax((int)N, (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
    }

    protected void sswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().sswap(N, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void scopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().scopy(N, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void scopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        BLAS.getInstance().scopy(n, this.getFloatData(x), offsetX, incrX, this.getFloatData(y), offsetY, incrY);
    }

    protected void saxpy(int N, float alpha, INDArray X, int incX, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().saxpy(N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    public void saxpy(int n, float alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        BLAS.getInstance().saxpy(n, alpha, this.getFloatData(x), offsetX, incrX, this.getFloatData(y), offsetY, incrY);
    }

    protected void dswap(int N, INDArray X, int incX, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dswap(N, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dcopy(int N, INDArray X, int incX, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dcopy(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dcopy(int n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        BLAS.getInstance().dcopy(n, this.getDoubleData(x), offsetX, incrX, this.getDoubleData(y), offsetY, incrY);
    }

    protected void daxpy(int N, double alpha, INDArray X, int incX, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().daxpy(N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    public void daxpy(int n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        BLAS.getInstance().daxpy(n, alpha, this.getDoubleData(x), offsetX, incrX, this.getDoubleData(y), offsetY, incrY);
    }

    protected void cswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        float[] yData = this.getFloatData((INDArray)Y);
        NativeBlas.cswap((int)N, (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (float[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)X);
    }

    protected void ccopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        float[] yData = this.getFloatData((INDArray)Y);
        NativeBlas.ccopy((int)N, (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (float[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void caxpy(int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        float[] yData = this.getFloatData((INDArray)Y);
        NativeBlas.caxpy((int)N, (ComplexFloat)CpuComplex.getComplexFloat(alpha), (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (float[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void zswap(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        double[] yData = this.getDoubleData((INDArray)Y);
        NativeBlas.zswap((int)N, (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (double[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void zcopy(int N, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        double[] yData = this.getDoubleData((INDArray)Y);
        NativeBlas.zcopy((int)N, (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (double[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void zaxpy(int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        double[] yData = this.getDoubleData((INDArray)Y);
        NativeBlas.zaxpy((int)N, (ComplexDouble)CpuComplex.getComplexDouble(alpha), (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (double[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void srotg(float a, float b, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotmg(float d1, float d2, float b1, float b2, INDArray P) {
        float[] pData = this.getFloatData(P);
        BLAS.getInstance().srotmg(new floatW(d1), new floatW(d2), new floatW(b1), b2, pData, BlasBufferUtil.getBlasOffset((INDArray)P));
        BlasBufferUtil.setData((float[])pData, (INDArray)P);
    }

    protected void srot(int N, INDArray X, int incX, INDArray Y, int incY, float c, float s) {
        throw new UnsupportedOperationException();
    }

    protected void srotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        throw new UnsupportedOperationException();
    }

    protected void drotg(double a, double b, double c, double s) {
        throw new UnsupportedOperationException();
    }

    protected void drotmg(double d1, double d2, double b1, double b2, INDArray P) {
        double[] pData = this.getDoubleData(P);
        BLAS.getInstance().drotmg(new doubleW(d1), new doubleW(d2), new doubleW(b1), b2, pData, BlasBufferUtil.getBlasOffset((INDArray)P));
        BlasBufferUtil.setData((double[])pData, (INDArray)P);
    }

    protected void drot(int N, INDArray X, int incX, INDArray Y, int incY, double c, double s) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().drot(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, c, s);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void drotm(int N, INDArray X, int incX, INDArray Y, int incY, INDArray P) {
        double[] pData = this.getDoubleData(P);
        BLAS.getInstance().drotm(N, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, pData, BlasBufferUtil.getBlasOffset((INDArray)P));
        BlasBufferUtil.setData((double[])pData, (INDArray)P);
    }

    protected void sscal(int N, float alpha, INDArray X, int incX) {
        float[] data = this.getFloatData(X);
        BLAS.getInstance().sscal(N, alpha, data, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])data, (INDArray)X);
    }

    protected void dscal(int N, double alpha, INDArray X, int incX) {
        double[] data = this.getDoubleData(X);
        BLAS.getInstance().dscal(N, alpha, data, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])data, (INDArray)X);
    }

    protected void cscal(int N, IComplexFloat alpha, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        float[] xData = this.getFloatData((INDArray)X);
        NativeBlas.cscal((int)N, (ComplexFloat)CpuComplex.getComplexFloat(alpha), (float[])xData, (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void zscal(int N, IComplexDouble alpha, IComplexNDArray X, int incX) {
        double[] xData = this.getDoubleData((INDArray)X);
        NativeBlas.zscal((int)N, (ComplexDouble)CpuComplex.getComplexDouble(alpha), (double[])xData, (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void csscal(int N, float alpha, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        float[] xData = this.getFloatData((INDArray)X);
        NativeBlas.csscal((int)N, (float)alpha, (float[])xData, (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void zdscal(int N, double alpha, IComplexNDArray X, int incX) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        double[] xData = this.getDoubleData((INDArray)X);
        NativeBlas.zdscal((int)N, (double)alpha, (double[])xData, (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }
}

