/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.blas;

import com.github.fommil.netlib.BLAS;
import org.jblas.ComplexDouble;
import org.jblas.ComplexFloat;
import org.jblas.NativeBlas;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.impl.BaseLevel2;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cpu.util.JblasComplex;

public class CpuLevel2
extends BaseLevel2 {
    protected void sgemv(char order, char TransA, int M, int N, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().sgemv(String.valueOf(TransA), M, N, alpha, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void sgbmv(char order, char TransA, int M, int N, int KL, int KU, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().sgbmv(String.valueOf(TransA), M, N, KL, KU, alpha, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void strmv(char order, char Uplo, char TransA, char Diag, int N, INDArray A, int lda, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().strmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void stbmv(char order, char Uplo, char TransA, char Diag, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().stbmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, K, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void stpmv(char order, char Uplo, char TransA, char Diag, int N, INDArray Ap, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().stpmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getFloatData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void strsv(char order, char Uplo, char TransA, char Diag, int N, INDArray A, int lda, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().strsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void stbsv(char order, char Uplo, char TransA, char Diag, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().stbsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, K, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void stpsv(char order, char Uplo, char TransA, char Diag, int N, INDArray Ap, INDArray X, int incX) {
        float[] xData = this.getFloatData(X);
        BLAS.getInstance().stpsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getFloatData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((float[])xData, (INDArray)X);
    }

    protected void dgemv(char order, char TransA, int M, int N, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dgemv(String.valueOf(TransA), M, N, alpha, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dgbmv(char order, char TransA, int M, int N, int KL, int KU, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dgbmv(String.valueOf(TransA), M, N, KL, KU, alpha, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dtrmv(char order, char Uplo, char TransA, char Diag, int N, INDArray A, int lda, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtrmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void dtbmv(char order, char Uplo, char TransA, char Diag, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtbmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, K, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void dtpmv(char order, char Uplo, char TransA, char Diag, int N, INDArray Ap, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtpmv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getDoubleData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void dtrsv(char order, char Uplo, char TransA, char Diag, int N, INDArray A, int lda, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtrsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void dtbsv(char order, char Uplo, char TransA, char Diag, int N, int K, INDArray A, int lda, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtbsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, K, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void dtpsv(char order, char Uplo, char TransA, char Diag, int N, INDArray Ap, INDArray X, int incX) {
        double[] xData = this.getDoubleData(X);
        BLAS.getInstance().dtpsv(String.valueOf(Uplo), String.valueOf(TransA), String.valueOf(Diag), N, this.getDoubleData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), xData, BlasBufferUtil.getBlasOffset((INDArray)X), incX);
        BlasBufferUtil.setData((double[])xData, (INDArray)X);
    }

    protected void cgemv(char order, char TransA, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexFloat beta, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        float[] yData = this.getFloatData((INDArray)Y);
        NativeBlas.cgemv((char)TransA, (int)M, (int)N, (ComplexFloat)JblasComplex.getComplexFloat(alpha), (float[])this.getFloatData((INDArray)A), (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)A.size(0), (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (ComplexFloat)JblasComplex.getComplexFloat(beta), (float[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void cgbmv(char order, char TransA, int M, int N, int KL, int KU, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexFloat beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void ctrmv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ctbmv(char order, char Uplo, char TransA, char Diag, int N, int K, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ctpmv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray Ap, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ctrsv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ctbsv(char order, char Uplo, char TransA, char Diag, int N, int K, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ctpsv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray Ap, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void zgemv(char order, char TransA, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexDouble beta, IComplexNDArray Y, int incY) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        double[] yData = this.getDoubleData((INDArray)Y);
        NativeBlas.zgemv((char)TransA, (int)M, (int)N, (ComplexDouble)JblasComplex.getComplexDouble(alpha), (double[])this.getDoubleData((INDArray)A), (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)A.size(0), (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (ComplexDouble)JblasComplex.getComplexDouble(beta), (double[])yData, (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void zgbmv(char order, char TransA, int M, int N, int KL, int KU, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexDouble beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void ztrmv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ztbmv(char order, char Uplo, char TransA, char Diag, int N, int K, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ztpmv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray Ap, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ztrsv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ztbsv(char order, char Uplo, char TransA, char Diag, int N, int K, IComplexNDArray A, int lda, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ztpsv(char order, char Uplo, char TransA, char Diag, int N, IComplexNDArray Ap, IComplexNDArray X, int incX) {
        throw new UnsupportedOperationException();
    }

    protected void ssymv(char order, char Uplo, int N, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().ssymv(String.valueOf(Uplo), N, alpha, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void ssbmv(char order, char Uplo, int N, int K, float alpha, INDArray A, int lda, INDArray X, int incX, float beta, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().ssbmv(String.valueOf(Uplo), N, K, alpha, this.getFloatData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void sspmv(char order, char Uplo, int N, float alpha, INDArray Ap, INDArray X, int incX, float beta, INDArray Y, int incY) {
        float[] yData = this.getFloatData(Y);
        BLAS.getInstance().sspmv(String.valueOf(Uplo), N, alpha, this.getFloatData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((float[])yData, (INDArray)Y);
    }

    protected void sger(char order, int M, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        float[] aData = this.getFloatData(A);
        BLAS.getInstance().sger(M, N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getFloatData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((float[])aData, (INDArray)A);
    }

    protected void ssyr(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray A, int lda) {
        float[] aData = this.getFloatData(A);
        BLAS.getInstance().ssyr(String.valueOf(Uplo), N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((float[])aData, (INDArray)A);
    }

    protected void sspr(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Ap) {
        float[] apData = this.getFloatData(Ap);
        BLAS.getInstance().sspr(String.valueOf(Uplo), N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, apData, BlasBufferUtil.getBlasOffset((INDArray)Ap));
        BlasBufferUtil.setData((float[])apData, (INDArray)Ap);
    }

    protected void ssyr2(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        float[] aData = this.getFloatData(A);
        BLAS.getInstance().ssyr2(String.valueOf(Uplo), N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incY, this.getFloatData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((float[])aData, (INDArray)A);
    }

    protected void sspr2(char order, char Uplo, int N, float alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A) {
        float[] aData = this.getFloatData(A);
        BLAS.getInstance().sspr2(String.valueOf(Uplo), N, alpha, this.getFloatData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getFloatData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A));
        BlasBufferUtil.setData((float[])aData, (INDArray)A);
    }

    protected void dsymv(char order, char Uplo, int N, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dsymv(String.valueOf(Uplo), N, alpha, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dsbmv(char order, char Uplo, int N, int K, double alpha, INDArray A, int lda, INDArray X, int incX, double beta, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dsbmv(String.valueOf(Uplo), N, K, alpha, this.getDoubleData(A), BlasBufferUtil.getBlasOffset((INDArray)A), lda, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dspmv(char order, char Uplo, int N, double alpha, INDArray Ap, INDArray X, int incX, double beta, INDArray Y, int incY) {
        double[] yData = this.getDoubleData(Y);
        BLAS.getInstance().dspmv(String.valueOf(Uplo), N, alpha, this.getDoubleData(Ap), BlasBufferUtil.getBlasOffset((INDArray)Ap), this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, beta, yData, BlasBufferUtil.getBlasOffset((INDArray)Y), incY);
        BlasBufferUtil.setData((double[])yData, (INDArray)Y);
    }

    protected void dger(char order, int M, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        double[] aData = this.getDoubleData(A);
        BLAS.getInstance().dger(M, N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void dsyr(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray A, int lda) {
        double[] aData = this.getDoubleData(A);
        BLAS.getInstance().dsyr(String.valueOf(Uplo), N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void dspr(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Ap) {
        double[] apData = this.getDoubleData(Ap);
        BLAS.getInstance().dspr(String.valueOf(Uplo), N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, apData, BlasBufferUtil.getBlasOffset((INDArray)Ap));
        BlasBufferUtil.setData((double[])apData, (INDArray)Ap);
    }

    protected void dsyr2(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A, int lda) {
        double[] aData = this.getDoubleData(A);
        BLAS.getInstance().dsyr2(String.valueOf(Uplo), N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A), lda);
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void dspr2(char order, char Uplo, int N, double alpha, INDArray X, int incX, INDArray Y, int incY, INDArray A) {
        double[] aData = this.getDoubleData(A);
        BLAS.getInstance().dspr2(String.valueOf(Uplo), N, alpha, this.getDoubleData(X), BlasBufferUtil.getBlasOffset((INDArray)X), incX, this.getDoubleData(Y), BlasBufferUtil.getBlasOffset((INDArray)Y), incY, aData, BlasBufferUtil.getBlasOffset((INDArray)A));
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void chemv(char order, char Uplo, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexFloat beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void chbmv(char order, char Uplo, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexFloat beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void chpmv(char order, char Uplo, int N, IComplexFloat alpha, IComplexNDArray Ap, IComplexNDArray X, int incX, IComplexFloat beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void cgeru(char order, int M, int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        float[] aData = this.getFloatData((INDArray)A);
        NativeBlas.cgeru((int)M, (int)N, (ComplexFloat)JblasComplex.getComplexFloat(alpha), (float[])this.getFloatData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (float[])this.getFloatData((INDArray)Y), (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY, (float[])aData, (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)lda);
        BlasBufferUtil.setData((float[])aData, (INDArray)A);
    }

    protected void cgerc(char order, int M, int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    protected void cher(char order, char Uplo, int N, float alpha, IComplexNDArray X, int incX, IComplexNDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    protected void chpr(char order, char Uplo, int N, INDArray alpha, IComplexNDArray X, int incX, IComplexNDArray A) {
        throw new UnsupportedOperationException();
    }

    protected void cher2(char order, char Uplo, int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    protected void chpr2(char order, char Uplo, int N, IComplexFloat alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray Ap) {
        throw new UnsupportedOperationException();
    }

    protected void zhemv(char order, char Uplo, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexDouble beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zhbmv(char order, char Uplo, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray X, int incX, IComplexDouble beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zhpmv(char order, char Uplo, int N, IComplexDouble alpha, IComplexNDArray Ap, IComplexNDArray X, int incX, IComplexDouble beta, IComplexNDArray Y, int incY) {
        throw new UnsupportedOperationException();
    }

    protected void zgeru(char order, int M, int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        double[] aData = this.getDoubleData((INDArray)A);
        NativeBlas.zgeru((int)M, (int)N, (ComplexDouble)JblasComplex.getComplexDouble(alpha), (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (double[])this.getDoubleData((INDArray)Y), (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY, (double[])aData, (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)A.size(0));
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void zgerc(char order, int M, int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        X = (IComplexNDArray)Shape.toOffsetZero((INDArray)X);
        Y = (IComplexNDArray)Shape.toOffsetZero((INDArray)Y);
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        double[] aData = this.getDoubleData((INDArray)A);
        NativeBlas.zgerc((int)M, (int)N, (ComplexDouble)JblasComplex.getComplexDouble(alpha), (double[])this.getDoubleData((INDArray)X), (int)BlasBufferUtil.getBlasOffset((INDArray)X), (int)incX, (double[])this.getDoubleData((INDArray)Y), (int)BlasBufferUtil.getBlasOffset((INDArray)Y), (int)incY, (double[])aData, (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)lda);
        BlasBufferUtil.setData((double[])aData, (INDArray)A);
    }

    protected void zher(char order, char Uplo, int N, double alpha, IComplexNDArray X, int incX, IComplexNDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    protected void zhpr(char order, char Uplo, int N, INDArray alpha, IComplexNDArray X, int incX, IComplexNDArray A) {
        throw new UnsupportedOperationException();
    }

    protected void zher2(char order, char Uplo, int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray A, int lda) {
        throw new UnsupportedOperationException();
    }

    protected void zhpr2(char order, char Uplo, int N, IComplexDouble alpha, IComplexNDArray X, int incX, IComplexNDArray Y, int incY, IComplexNDArray Ap) {
        throw new UnsupportedOperationException();
    }
}

