/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.blas;

import com.github.fommil.netlib.BLAS;
import org.jblas.ComplexDouble;
import org.jblas.ComplexFloat;
import org.jblas.NativeBlas;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.impl.BaseLevel3;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cpu.util.CpuComplex;

public class CpuLevel3
extends BaseLevel3 {
    protected void sgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        DataBuffer aData = A.data();
        DataBuffer bData = B.data();
        float[] cData = this.getFloatData(C);
        BLAS.getInstance().sgemm(String.valueOf(TransA), String.valueOf(TransB), M, N, K, alpha, aData.asFloat(), BlasBufferUtil.getBlasOffset((INDArray)A), lda, bData.asFloat(), BlasBufferUtil.getBlasOffset((INDArray)B), ldb, beta, cData, BlasBufferUtil.getBlasOffset((INDArray)C), ldc);
        BlasBufferUtil.setData((float[])cData, (INDArray)C);
    }

    protected void ssymm(char Order, char Side, char Uplo, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ssyrk(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ssyr2k(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void strmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void strsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void dgemm(char Order, char TransA, char TransB, int M, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        A = Shape.toOffsetZero((INDArray)A);
        B = Shape.toOffsetZero((INDArray)B);
        DataBuffer aData = A.data();
        DataBuffer bData = B.data();
        double[] cData = this.getDoubleData(C);
        BLAS.getInstance().dgemm(String.valueOf(TransA), String.valueOf(TransB), M, N, K, alpha, aData.asDouble(), BlasBufferUtil.getBlasOffset((INDArray)A), lda, bData.asDouble(), BlasBufferUtil.getBlasOffset((INDArray)B), ldb, beta, cData, BlasBufferUtil.getBlasOffset((INDArray)C), ldc);
        BlasBufferUtil.setData((double[])cData, (INDArray)C);
    }

    protected void dsymm(char Order, char Side, char Uplo, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void dsyrk(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, double beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void dsyr2k(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void dtrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void dtrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void cgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        B = (IComplexNDArray)Shape.toOffsetZero((INDArray)B);
        C = (IComplexNDArray)Shape.toOffsetZero((INDArray)C);
        float[] cData = this.getFloatData((INDArray)C);
        NativeBlas.cgemm((char)TransA, (char)TransB, (int)M, (int)N, (int)K, (ComplexFloat)CpuComplex.getComplexFloat(alpha), (float[])this.getFloatData((INDArray)A), (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)lda, (float[])this.getFloatData((INDArray)B), (int)BlasBufferUtil.getBlasOffset((INDArray)B), (int)ldb, (ComplexFloat)CpuComplex.getComplexFloat(beta), (float[])cData, (int)BlasBufferUtil.getBlasOffset((INDArray)C), (int)ldc);
        BlasBufferUtil.setData((float[])cData, (INDArray)C);
    }

    protected void csymm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyrk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void zgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        A = (IComplexNDArray)Shape.toOffsetZero((INDArray)A);
        B = (IComplexNDArray)Shape.toOffsetZero((INDArray)B);
        C = (IComplexNDArray)Shape.toOffsetZero((INDArray)C);
        double[] cData = this.getDoubleData((INDArray)C);
        NativeBlas.zgemm((char)TransA, (char)TransB, (int)M, (int)N, (int)K, (ComplexDouble)CpuComplex.getComplexDouble(alpha), (double[])this.getDoubleData((INDArray)A), (int)BlasBufferUtil.getBlasOffset((INDArray)A), (int)lda, (double[])this.getDoubleData((INDArray)B), (int)BlasBufferUtil.getBlasOffset((INDArray)B), (int)ldb, (ComplexDouble)CpuComplex.getComplexDouble(beta), (double[])cData, (int)BlasBufferUtil.getBlasOffset((INDArray)C), (int)ldc);
        BlasBufferUtil.setData((double[])cData, (INDArray)C);
    }

    protected void zsymm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyrk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void chemm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cherk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cher2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zhemm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zherk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zher2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }
}

