/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.complex;

import org.jblas.ComplexFloat;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public class ComplexDouble
extends org.jblas.ComplexDouble
implements IComplexDouble {
    public static final ComplexDouble UNIT = new ComplexDouble(1.0, 0.0);
    public static final ComplexDouble NEG = new ComplexDouble(-1.0, 0.0);
    public static final ComplexDouble ZERO = new ComplexDouble(0.0, 0.0);

    public ComplexDouble(org.jblas.ComplexDouble c) {
        super(c.real(), c.imag());
    }

    public ComplexDouble(double real, double imag) {
        super(real, imag);
    }

    public ComplexDouble(double real) {
        super(real);
    }

    public IComplexNumber eqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val == otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val != otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag == otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber neqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val != otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val == otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag != otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber gt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val > otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val < otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag > otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber lt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val < otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val > otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag < otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber rsubi(IComplexNumber c) {
        return this.rsubi(c, (IComplexNumber)this);
    }

    public IComplexNumber set(IComplexNumber set) {
        return (IComplexNumber)this.set(set.realComponent().doubleValue(), set.imaginaryComponent().doubleValue());
    }

    public IComplexNumber rsubi(IComplexNumber a, IComplexNumber result) {
        return result.set(a.sub((IComplexNumber)this));
    }

    public double arg() {
        return super.arg();
    }

    public double abs() {
        return super.abs();
    }

    public IComplexFloat asFloat() {
        return Nd4j.createFloat((float)((float)this.real()), (float)((float)this.imag()));
    }

    public IComplexDouble asDouble() {
        return this;
    }

    public ComplexDouble dup() {
        return new ComplexDouble(this.realComponent(), this.imaginaryComponent());
    }

    public ComplexDouble conji() {
        super.set(this.realComponent().doubleValue(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    public ComplexDouble conj() {
        return this.dup().conji();
    }

    public IComplexNumber set(Number real, Number imag) {
        super.set(real.doubleValue(), imag.doubleValue());
        return this;
    }

    public IComplexNumber copy(IComplexNumber other) {
        return other.set((IComplexNumber)this);
    }

    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() + c.realComponent().doubleValue()), (Number)(result.imaginaryComponent().doubleValue() + c.imaginaryComponent().doubleValue()));
    }

    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    public IComplexNumber addi(Number a, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() + a.doubleValue()), (Number)result.imaginaryComponent().doubleValue());
    }

    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() - c.realComponent().doubleValue()), (Number)(result.imaginaryComponent().doubleValue() - c.imaginaryComponent().doubleValue()));
    }

    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    public IComplexNumber subi(Number a, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() - a.doubleValue()), (Number)(result.imaginaryComponent().doubleValue() - a.doubleValue()));
    }

    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    public IComplexNumber rsub(IComplexNumber c) {
        return this.dup().rsubi(c);
    }

    public IComplexNumber rsubi(Number a, IComplexNumber result) {
        return result.set((Number)(a.doubleValue() - result.realComponent().doubleValue()), (Number)this.imaginaryComponent());
    }

    public IComplexNumber rsubi(Number a) {
        return this.rsubi(a, (IComplexNumber)this);
    }

    public IComplexNumber rsub(Number r) {
        return this.dup().rsubi(r);
    }

    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        double newR = this.real() * c.realComponent().doubleValue() - this.imag() * c.imaginaryComponent().doubleValue();
        double newI = this.real() * c.imaginaryComponent().doubleValue() + this.imag() * c.realComponent().doubleValue();
        result.set((Number)newR, (Number)newI);
        return result;
    }

    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    public IComplexNumber muli(Number v, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() * v.doubleValue()), (Number)(result.imaginaryComponent().doubleValue() * v.doubleValue()));
    }

    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        double d = c.realComponent().doubleValue() * c.realComponent().doubleValue() + c.imaginaryComponent().doubleValue() * c.imaginaryComponent().doubleValue();
        double newR = (this.real() * c.realComponent().doubleValue() + this.imag() * c.imaginaryComponent().doubleValue()) / d;
        double newI = (this.imag() * c.realComponent().doubleValue() - this.real() * c.imaginaryComponent().doubleValue()) / d;
        result.set((Number)newR, (Number)newI);
        return result;
    }

    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    public IComplexNumber divi(Number v, IComplexNumber result) {
        return result.set((Number)(result.realComponent().doubleValue() / v.doubleValue()), (Number)(result.imaginaryComponent().doubleValue() / v.doubleValue()));
    }

    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    public IComplexNumber rdiv(IComplexNumber c) {
        return this.dup().rdivi(c);
    }

    public IComplexNumber rdivi(IComplexNumber c, IComplexNumber result) {
        return result.set(c.div((IComplexNumber)this));
    }

    public IComplexNumber rdivi(IComplexNumber c) {
        return this.rdivi(c, (IComplexNumber)this);
    }

    public IComplexNumber rdivi(Number v, IComplexNumber result) {
        double d = result.realComponent().doubleValue() * result.realComponent().doubleValue() + result.imaginaryComponent().doubleValue() * result.imaginaryComponent().doubleValue();
        return result.set((Number)(v.doubleValue() * result.realComponent().doubleValue() / d), (Number)(-v.doubleValue() * result.imaginaryComponent().doubleValue() / d));
    }

    public IComplexNumber rdivi(Number v) {
        return this.rdivi(v, (IComplexNumber)this);
    }

    public IComplexNumber rdiv(Number v) {
        return this.dup().rdivi(v, (IComplexNumber)this);
    }

    public boolean eq(IComplexNumber c) {
        return false;
    }

    public boolean ne(IComplexNumber c) {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public org.jblas.ComplexDouble set(double real, double imag) {
        return super.set(real, imag);
    }

    public double real() {
        return super.real();
    }

    public double imag() {
        return super.imag();
    }

    public Double realComponent() {
        return super.real();
    }

    public Double imaginaryComponent() {
        return super.imag();
    }

    public org.jblas.ComplexDouble copy(org.jblas.ComplexDouble other) {
        return super.copy(other);
    }

    public org.jblas.ComplexDouble addi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.addi(c, result);
    }

    public org.jblas.ComplexDouble addi(org.jblas.ComplexDouble c) {
        return super.addi(c);
    }

    public org.jblas.ComplexDouble add(org.jblas.ComplexDouble c) {
        return super.add(c);
    }

    public org.jblas.ComplexDouble addi(double a, org.jblas.ComplexDouble result) {
        return super.addi(a, result);
    }

    public org.jblas.ComplexDouble addi(double c) {
        return super.addi(c);
    }

    public org.jblas.ComplexDouble add(double c) {
        return super.add(c);
    }

    public org.jblas.ComplexDouble subi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.subi(c, result);
    }

    public org.jblas.ComplexDouble subi(org.jblas.ComplexDouble c) {
        return super.subi(c);
    }

    public org.jblas.ComplexDouble sub(org.jblas.ComplexDouble c) {
        return super.sub(c);
    }

    public org.jblas.ComplexDouble subi(double a, org.jblas.ComplexDouble result) {
        return super.subi(a, result);
    }

    public org.jblas.ComplexDouble subi(double a) {
        return super.subi(a);
    }

    public org.jblas.ComplexDouble sub(double r) {
        return super.sub(r);
    }

    public org.jblas.ComplexDouble muli(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.muli(c, result);
    }

    public org.jblas.ComplexDouble muli(org.jblas.ComplexDouble c) {
        return super.muli(c);
    }

    public org.jblas.ComplexDouble mul(org.jblas.ComplexDouble c) {
        return super.mul(c);
    }

    public org.jblas.ComplexDouble mul(double v) {
        return super.mul(v);
    }

    public org.jblas.ComplexDouble muli(double v, org.jblas.ComplexDouble result) {
        return super.muli(v, result);
    }

    public org.jblas.ComplexDouble muli(double v) {
        return super.muli(v);
    }

    public ComplexDouble div(org.jblas.ComplexDouble c) {
        return this.dup().divi(c);
    }

    public org.jblas.ComplexDouble divi(org.jblas.ComplexDouble c, org.jblas.ComplexDouble result) {
        return super.divi(c, result);
    }

    public ComplexDouble divi(org.jblas.ComplexDouble c) {
        super.divi(c);
        return this;
    }

    public ComplexDouble divi(double v, org.jblas.ComplexDouble result) {
        super.divi(v, result);
        return this;
    }

    public ComplexDouble divi(double v) {
        super.divi(v);
        return this;
    }

    public ComplexDouble div(double v) {
        super.div(v);
        return this;
    }

    public Double absoluteValue() {
        return super.abs();
    }

    public Double complexArgument() {
        return Math.acos(this.realComponent() / this.absoluteValue());
    }

    public ComplexDouble invi() {
        double d = this.realComponent() * this.realComponent() + this.imaginaryComponent() * this.imaginaryComponent();
        this.set(this.realComponent() / d, -this.imaginaryComponent().doubleValue() / d);
        return this;
    }

    public ComplexDouble inv() {
        return this.dup().invi();
    }

    public ComplexDouble neg() {
        return this.dup().negi();
    }

    public ComplexDouble negi() {
        this.set(-this.realComponent().doubleValue(), -this.imaginaryComponent().doubleValue());
        return this;
    }

    public ComplexDouble sqrt() {
        double a = this.absoluteValue();
        double s2 = Math.sqrt(2.0);
        double p = Math.sqrt(a + this.realComponent()) / s2;
        double q = Math.sqrt(a - this.realComponent()) / s2 * Math.signum(this.imaginaryComponent());
        return new ComplexDouble(p, q);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IComplexNumber) || !(o instanceof ComplexFloat) && !(o instanceof org.jblas.ComplexDouble)) {
            return false;
        }
        IComplexNumber num = (IComplexNumber)o;
        double thisReal = this.realComponent();
        double otherReal = num.realComponent().doubleValue();
        double thisImag = this.imaginaryComponent();
        double otherImag = this.imaginaryComponent();
        double diff = Math.abs(thisReal - otherReal);
        double imagDiff = Math.abs(thisImag - otherImag);
        return diff < Nd4j.EPS_THRESHOLD && imagDiff < Nd4j.EPS_THRESHOLD;
    }

    public boolean eq(org.jblas.ComplexDouble c) {
        return super.eq(c);
    }

    public boolean ne(org.jblas.ComplexDouble c) {
        return super.ne(c);
    }

    public boolean isZero() {
        return super.isZero();
    }

    public boolean isReal() {
        return this.imaginaryComponent() == 0.0;
    }

    public boolean isImag() {
        return this.realComponent() == 0.0;
    }
}

