/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.complex;

import org.jblas.ComplexDouble;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public class ComplexFloat
extends org.jblas.ComplexFloat
implements IComplexFloat {
    public static final ComplexFloat UNIT = new ComplexFloat(1.0f, 0.0f);
    public static final ComplexFloat NEG = new ComplexFloat(-1.0f, 0.0f);
    public static final ComplexFloat ZERO = new ComplexFloat(0.0f, 0.0f);

    public ComplexFloat(org.jblas.ComplexFloat c) {
        super(c.real(), c.imag());
    }

    public ComplexFloat(float real, float imag) {
        super(real, imag);
    }

    public ComplexFloat(float real) {
        super(real);
    }

    public IComplexNumber eqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val == otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val != otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag == otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber neqc(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val != otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val == otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag != otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber gt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val > otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val < otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag > otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber lt(IComplexNumber num) {
        double val = num.realComponent().doubleValue();
        double imag = num.imaginaryComponent().doubleValue();
        double otherVal = num.realComponent().doubleValue();
        double otherImag = num.imaginaryComponent().doubleValue();
        if (val < otherVal) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        if (val > otherVal) {
            return Nd4j.createComplexNumber((Number)0, (Number)0);
        }
        if (imag < otherImag) {
            return Nd4j.createComplexNumber((Number)1, (Number)0);
        }
        return Nd4j.createComplexNumber((Number)0, (Number)0);
    }

    public IComplexNumber rsubi(IComplexNumber c) {
        return this.rsubi(c, (IComplexNumber)this);
    }

    public IComplexNumber set(IComplexNumber set) {
        return this.set(set.realComponent(), set.imaginaryComponent());
    }

    public IComplexNumber rsubi(IComplexNumber a, IComplexNumber result) {
        return result.set(a.sub((IComplexNumber)this));
    }

    public float arg() {
        return super.arg();
    }

    public float abs() {
        return super.abs();
    }

    public IComplexDouble asDouble() {
        return Nd4j.createDouble((double)this.realComponent().floatValue(), (double)this.imaginaryComponent().floatValue());
    }

    public ComplexFloat asFloat() {
        return this;
    }

    public ComplexFloat dup() {
        return new ComplexFloat(this.realComponent().floatValue(), this.imaginaryComponent().floatValue());
    }

    public ComplexFloat conji() {
        super.set(this.realComponent().floatValue(), -this.imaginaryComponent().floatValue());
        return this;
    }

    public ComplexFloat conj() {
        return this.dup().conji();
    }

    public IComplexNumber set(Number real, Number imag) {
        super.set(real.floatValue(), imag.floatValue());
        return this;
    }

    public IComplexNumber copy(IComplexNumber other) {
        return other.set((IComplexNumber)this);
    }

    public IComplexNumber addi(IComplexNumber c, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() + c.realComponent().floatValue()), (Number)Float.valueOf(result.imaginaryComponent().floatValue() + c.imaginaryComponent().floatValue()));
    }

    public IComplexNumber addi(IComplexNumber c) {
        return this.addi(c, (IComplexNumber)this);
    }

    public IComplexNumber add(IComplexNumber c) {
        return this.dup().addi(c);
    }

    public IComplexNumber addi(Number a, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() + a.floatValue()), (Number)Float.valueOf(result.imaginaryComponent().floatValue()));
    }

    public IComplexNumber addi(Number c) {
        return this.addi(c, (IComplexNumber)this);
    }

    public IComplexNumber add(Number c) {
        return this.dup().addi(c);
    }

    public IComplexNumber subi(IComplexNumber c, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() - c.realComponent().floatValue()), (Number)Float.valueOf(result.imaginaryComponent().floatValue() - c.imaginaryComponent().floatValue()));
    }

    public IComplexNumber subi(IComplexNumber c) {
        return this.subi(c, (IComplexNumber)this);
    }

    public IComplexNumber sub(IComplexNumber c) {
        return this.dup().subi(c);
    }

    public IComplexNumber subi(Number a, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() - a.floatValue()), (Number)Float.valueOf(result.imaginaryComponent().floatValue()));
    }

    public IComplexNumber subi(Number a) {
        return this.subi(a, (IComplexNumber)this);
    }

    public IComplexNumber sub(Number r) {
        return this.dup().subi(r);
    }

    public IComplexNumber rsub(IComplexNumber c) {
        return this.dup().rsubi(c);
    }

    public IComplexNumber rsubi(Number a, IComplexNumber result) {
        return result.set((Number)(a.doubleValue() - this.realComponent().doubleValue()), (Number)Float.valueOf(this.imag()));
    }

    public IComplexNumber rsubi(Number a) {
        return this.rsubi(a, (IComplexNumber)this);
    }

    public IComplexNumber rsub(Number r) {
        return this.dup().rsubi(r, (IComplexNumber)this);
    }

    public IComplexNumber muli(IComplexNumber c, IComplexNumber result) {
        float newR = this.real() * c.realComponent().floatValue() - this.imag() * c.imaginaryComponent().floatValue();
        float newI = this.real() * c.imaginaryComponent().floatValue() + this.imag() * c.realComponent().floatValue();
        result.set((Number)Float.valueOf(newR), (Number)Float.valueOf(newI));
        return result;
    }

    public IComplexNumber muli(IComplexNumber c) {
        return this.muli(c, (IComplexNumber)this);
    }

    public IComplexNumber mul(IComplexNumber c) {
        return this.dup().muli(c);
    }

    public IComplexNumber mul(Number v) {
        return this.dup().muli(v);
    }

    public IComplexNumber muli(Number v, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() * v.floatValue()), (Number)Float.valueOf(result.imaginaryComponent().floatValue() * v.floatValue()));
    }

    public IComplexNumber muli(Number v) {
        return this.muli(v, (IComplexNumber)this);
    }

    public IComplexNumber div(IComplexNumber c) {
        return this.dup().divi(c);
    }

    public IComplexNumber divi(IComplexNumber c, IComplexNumber result) {
        float d = c.realComponent().floatValue() * c.realComponent().floatValue() + c.imaginaryComponent().floatValue() * c.imaginaryComponent().floatValue();
        float newR = (this.real() * c.realComponent().floatValue() + this.imag() * c.imaginaryComponent().floatValue()) / d;
        float newI = (this.imag() * c.realComponent().floatValue() - this.real() * c.imaginaryComponent().floatValue()) / d;
        result.set((Number)Float.valueOf(newR), (Number)Float.valueOf(newI));
        return result;
    }

    public IComplexNumber divi(IComplexNumber c) {
        return this.divi(c, (IComplexNumber)this);
    }

    public IComplexNumber divi(Number v, IComplexNumber result) {
        return result.set((Number)Float.valueOf(result.realComponent().floatValue() / v.floatValue()), (Number)Float.valueOf(this.imaginaryComponent().floatValue() / v.floatValue()));
    }

    public IComplexNumber divi(Number v) {
        return this.divi(v, (IComplexNumber)this);
    }

    public IComplexNumber div(Number v) {
        return this.dup().divi(v);
    }

    public IComplexNumber rdiv(IComplexNumber c) {
        return this.dup().rdivi(c);
    }

    public IComplexNumber rdivi(IComplexNumber c, IComplexNumber result) {
        return result.set(c.div(result));
    }

    public IComplexNumber rdivi(IComplexNumber c) {
        return this.rdivi(c, (IComplexNumber)this);
    }

    public IComplexNumber rdivi(Number v, IComplexNumber result) {
        float d = result.realComponent().floatValue() * result.realComponent().floatValue() + result.imaginaryComponent().floatValue() * result.imaginaryComponent().floatValue();
        return result.set((Number)Float.valueOf(v.floatValue() * result.realComponent().floatValue() / d), (Number)Float.valueOf(-v.floatValue() * result.imaginaryComponent().floatValue() / d));
    }

    public IComplexNumber rdivi(Number v) {
        return this.rdivi(v, (IComplexNumber)this);
    }

    public IComplexNumber rdiv(Number v) {
        return this.dup().rdivi(v);
    }

    public boolean eq(IComplexNumber c) {
        return false;
    }

    public boolean ne(IComplexNumber c) {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public org.jblas.ComplexFloat set(float real, float imag) {
        return super.set(real, imag);
    }

    public float real() {
        return super.real();
    }

    public float imag() {
        return super.imag();
    }

    public Float realComponent() {
        return Float.valueOf(super.real());
    }

    public Float imaginaryComponent() {
        return Float.valueOf(super.imag());
    }

    public org.jblas.ComplexFloat copy(org.jblas.ComplexFloat other) {
        return super.copy(other);
    }

    public org.jblas.ComplexFloat addi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.addi(c, result);
    }

    public org.jblas.ComplexFloat addi(org.jblas.ComplexFloat c) {
        return super.addi(c);
    }

    public org.jblas.ComplexFloat add(org.jblas.ComplexFloat c) {
        return super.add(c);
    }

    public org.jblas.ComplexFloat addi(float a, org.jblas.ComplexFloat result) {
        return super.addi(a, result);
    }

    public org.jblas.ComplexFloat addi(float c) {
        return super.addi(c);
    }

    public org.jblas.ComplexFloat add(float c) {
        return super.add(c);
    }

    public org.jblas.ComplexFloat subi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.subi(c, result);
    }

    public org.jblas.ComplexFloat subi(org.jblas.ComplexFloat c) {
        return super.subi(c);
    }

    public org.jblas.ComplexFloat sub(org.jblas.ComplexFloat c) {
        return super.sub(c);
    }

    public org.jblas.ComplexFloat subi(float a, org.jblas.ComplexFloat result) {
        return super.subi(a, result);
    }

    public org.jblas.ComplexFloat subi(float a) {
        return super.subi(a);
    }

    public org.jblas.ComplexFloat sub(float r) {
        return super.sub(r);
    }

    public org.jblas.ComplexFloat muli(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.muli(c, result);
    }

    public org.jblas.ComplexFloat muli(org.jblas.ComplexFloat c) {
        return super.muli(c);
    }

    public org.jblas.ComplexFloat mul(org.jblas.ComplexFloat c) {
        return super.mul(c);
    }

    public org.jblas.ComplexFloat mul(float v) {
        return super.mul(v);
    }

    public org.jblas.ComplexFloat muli(float v, org.jblas.ComplexFloat result) {
        return super.muli(v, result);
    }

    public org.jblas.ComplexFloat muli(float v) {
        return super.muli(v);
    }

    public ComplexFloat div(org.jblas.ComplexFloat c) {
        return this.dup().divi(c);
    }

    public org.jblas.ComplexFloat divi(org.jblas.ComplexFloat c, org.jblas.ComplexFloat result) {
        return super.divi(c, result);
    }

    public ComplexFloat divi(org.jblas.ComplexFloat c) {
        super.divi(c);
        return this;
    }

    public ComplexFloat divi(float v, org.jblas.ComplexFloat result) {
        super.divi(v, result);
        return this;
    }

    public ComplexFloat divi(float v) {
        super.divi(v);
        return this;
    }

    public ComplexFloat div(float v) {
        super.div(v);
        return this;
    }

    public Float absoluteValue() {
        return Float.valueOf(super.abs());
    }

    public Float complexArgument() {
        return Float.valueOf((float)Math.acos(this.realComponent().floatValue() / this.absoluteValue().floatValue()));
    }

    public ComplexFloat invi() {
        float d = this.realComponent().floatValue() * this.realComponent().floatValue() + this.imaginaryComponent().floatValue() * this.imaginaryComponent().floatValue();
        this.set(this.realComponent().floatValue() / d, -this.imaginaryComponent().floatValue() / d);
        return this;
    }

    public ComplexFloat inv() {
        return this.dup().invi();
    }

    public ComplexFloat neg() {
        return this.dup().negi();
    }

    public ComplexFloat negi() {
        this.set(-this.realComponent().floatValue(), -this.imaginaryComponent().floatValue());
        return this;
    }

    public ComplexFloat sqrt() {
        float a = this.absoluteValue().floatValue();
        float s2 = (float)Math.sqrt(2.0);
        float p = (float)Math.sqrt(a + this.realComponent().floatValue()) / s2;
        float q = (float)Math.sqrt(a - this.realComponent().floatValue()) / s2 * Math.signum(this.imaginaryComponent().floatValue());
        return new ComplexFloat(p, q);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IComplexNumber) || !(o instanceof org.jblas.ComplexFloat) && !(o instanceof ComplexDouble)) {
            return false;
        }
        if (o instanceof org.jblas.ComplexFloat) {
            return super.equals(o);
        }
        IComplexNumber num = (IComplexNumber)o;
        return num.realComponent().doubleValue() == this.realComponent().doubleValue() && num.imaginaryComponent().doubleValue() == this.imaginaryComponent().doubleValue();
    }

    public boolean eq(org.jblas.ComplexFloat c) {
        return super.eq(c);
    }

    public boolean ne(org.jblas.ComplexFloat c) {
        return super.ne(c);
    }

    public boolean isZero() {
        return super.isZero();
    }

    public boolean isReal() {
        return (double)this.imaginaryComponent().floatValue() == 0.0;
    }

    public boolean isImag() {
        return (double)this.realComponent().floatValue() == 0.0;
    }
}

