/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.protobuf.common.collect;

import org.nd4j.shade.protobuf.common.annotations.GwtCompatible;
import org.nd4j.shade.protobuf.common.annotations.GwtIncompatible;
import org.nd4j.shade.protobuf.common.collect.AbstractMapBasedMultiset;
import org.nd4j.shade.protobuf.common.collect.Iterables;
import org.nd4j.shade.protobuf.common.collect.Multisets;
import org.nd4j.shade.protobuf.common.collect.ObjectCountHashMap;

@GwtCompatible(serializable=true, emulated=true)
public class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountHashMap(distinctElements);
    }
}

