/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import com.jsaragih.IO;
import com.jsaragih.PAW;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.openimaj.image.FImage;
import org.openimaj.math.matrix.MatrixUtils;

public class FCheck {
    PAW _paw;
    double _b;
    Matrix _w;
    private Matrix vec_;
    private FImage crop_;

    FCheck(double b, Matrix w, PAW paw) {
        assert (w.getRowDimension() == paw._nPix);
        this._b = b;
        this._w = w.copy();
        this._paw = paw;
        this.crop_ = new FImage(this._paw._mask.width, this._paw._mask.height);
        this.vec_ = new Matrix(this._paw._nPix, 1);
    }

    protected FCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FCheck load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            FCheck fCheck = FCheck.read(sc, true);
            return fCheck;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.FCHECK.ordinal() + " " + this._b + " ");
        IO.writeMat(s, this._w);
        this._paw.write(s);
    }

    static FCheck read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.FCHECK.ordinal());
        }
        FCheck fcheck = new FCheck();
        fcheck._b = s.nextDouble();
        fcheck._w = IO.readMat(s);
        fcheck._paw = PAW.read(s, true);
        fcheck.crop_ = new FImage(fcheck._paw._mask.width, fcheck._paw._mask.height);
        fcheck.vec_ = new Matrix(fcheck._paw._nPix, 1);
        return fcheck;
    }

    boolean check(FImage im, Matrix s) {
        assert (s.getRowDimension() / 2 == this._paw.nPoints() && s.getColumnDimension() == 1);
        this._paw.crop(im, this.crop_, s);
        if (this.vec_.getRowDimension() != this._paw._nPix || this.vec_.getColumnDimension() != 1) {
            this.vec_ = new Matrix(this._paw._nPix, 1);
        }
        int w = this.crop_.width;
        int h = this.crop_.height;
        double[][] vp = this.vec_.getArray();
        float[][] cp = this.crop_.pixels;
        float[][] mp = this._paw._mask.pixels;
        int k = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if (mp[i][j] == 0.0f) continue;
                vp[k][0] = cp[i][j];
                ++k;
            }
        }
        double mean = MatrixUtils.sum((Matrix)this.vec_) / (double)this.vec_.getRowDimension();
        MatrixUtils.minus((Matrix)this.vec_, (double)mean);
        double var = 0.0;
        for (int i = 0; i < this._paw._nPix; ++i) {
            var += this.vec_.get(i, 0) * this.vec_.get(i, 0);
        }
        if (var < 1.0E-10) {
            MatrixUtils.fill((Matrix)this.vec_, (double)0.0);
        } else {
            this.vec_ = this.vec_.times(1.0 / Math.sqrt(var));
        }
        double wdv = 0.0;
        for (int i = 0; i < this._paw._nPix; ++i) {
            wdv += this._w.get(i, 0) * this.vec_.get(i, 0);
        }
        return wdv + this._b > 0.0;
    }

    static {
        Tracker.init();
    }
}

