/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import javax.xml.stream.XMLStreamException;
import org.openimaj.image.FImage;
import org.openimaj.image.objectdetection.filtering.OpenCVGrouping;
import org.openimaj.image.objectdetection.haar.Detector;
import org.openimaj.image.objectdetection.haar.OCVHaarLoader;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.image.processing.algorithm.EqualisationProcessor;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.util.pair.ObjectIntPair;

public class FDet {
    private static final int CV_HAAR_FEATURE_MAX = 3;
    int _min_neighbours;
    int _min_size;
    float _img_scale;
    float _scale_factor;
    StageTreeClassifier _cascade;
    FImage small_img_;
    private Detector detector;
    private OpenCVGrouping grouping;

    FDet(String fname, float img_scale, float scale_factor, int min_neighbours, int min_size) throws IOException, XMLStreamException {
        FileInputStream fis = new FileInputStream(fname);
        this._cascade = OCVHaarLoader.read((InputStream)fis);
        fis.close();
        this._img_scale = img_scale;
        this._scale_factor = scale_factor;
        this._min_neighbours = min_neighbours;
        this._min_size = min_size;
        this.setupDetector();
    }

    FDet() {
        try {
            this._cascade = OCVHaarLoader.read((InputStream)OCVHaarLoader.class.getResourceAsStream("haarcascade_frontalface_alt2.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Rectangle> detect(FImage im) {
        int w = Math.round((float)im.width / this._img_scale);
        int h = Math.round((float)im.height / this._img_scale);
        this.small_img_ = (FImage)ResizeProcessor.resample((FImage)im, (int)w, (int)h).processInplace((SinglebandImageProcessor)new EqualisationProcessor());
        List rects = this.detector.detect(this.small_img_);
        rects = ObjectIntPair.getFirst((Iterable)this.grouping.apply(rects));
        for (Rectangle r : rects) {
            r.scale(this._img_scale);
        }
        return rects;
    }

    private void setupDetector() {
        this.detector = new Detector(this._cascade, this._scale_factor);
        this.grouping = new OpenCVGrouping(this._min_neighbours);
        this.detector.setMinimumDetectionSize(this._min_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FDet load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            FDet fDet = FDet.read(sc, true);
            return fDet;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) {
    }

    public static FDet read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.FDET.ordinal());
        }
        FDet fdet = new FDet();
        fdet._min_neighbours = s.nextInt();
        fdet._min_size = s.nextInt();
        fdet._img_scale = s.nextFloat();
        fdet._scale_factor = s.nextFloat();
        int n = s.nextInt();
        s.next();
        s.next();
        for (int i = 0; i < n; ++i) {
            s.next();
            s.next();
            s.next();
            s.next();
            int count = s.nextInt();
            for (int j = 0; j < count; ++j) {
                int ccount = s.nextInt();
                for (int k = 0; k < ccount; ++k) {
                    s.next();
                    s.next();
                    s.next();
                    s.next();
                    s.next();
                    for (int l = 0; l < 3; ++l) {
                        s.next();
                        s.next();
                        s.next();
                        s.next();
                        s.next();
                    }
                }
                s.next();
            }
        }
        fdet.setupDetector();
        return fdet;
    }

    public int get_min_size() {
        return this._min_size;
    }

    public void set_min_size(int _min_size) {
        this._min_size = _min_size;
        this.setupDetector();
    }

    static {
        Tracker.init();
    }
}

