/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import com.jsaragih.IO;
import com.jsaragih.Patch;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.openimaj.image.FImage;

public class MPatch {
    public int _w;
    public int _h;
    public Patch[] _p;
    private FImage res_;

    MPatch(Patch[] p) {
        this._w = p[0].matcher.getTemplate().width;
        this._h = p[0].matcher.getTemplate().height;
        for (int i = 1; i < p.length; ++i) {
            if (p[i].matcher.getTemplate().width == this._w && p[i].matcher.getTemplate().height == this._h) continue;
            throw new IllegalArgumentException("Patches must all have the same size");
        }
        this._p = p;
        this.res_ = new FImage(0, 0);
    }

    MPatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MPatch load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            MPatch mPatch = MPatch.read(sc, true);
            return mPatch;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.MPATCH.ordinal() + " " + this._w + " " + this._h + " " + this._p.length + " ");
        for (int i = 0; i < this._p.length; ++i) {
            this._p[i].write(s);
        }
    }

    static MPatch read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.MPATCH.ordinal());
        }
        MPatch mpatch = new MPatch();
        mpatch._w = s.nextInt();
        mpatch._h = s.nextInt();
        int n = s.nextInt();
        mpatch._p = new Patch[n];
        for (int i = 0; i < n; ++i) {
            mpatch._p[i] = Patch.read(s, true);
        }
        return mpatch;
    }

    final void sum2one(FImage M) {
        M.divideInplace(M.sum());
    }

    void response(FImage im, FImage resp) {
        assert (im.height >= this._h && im.width >= this._w);
        int h = im.height - this._h + 1;
        int w = im.width - this._w + 1;
        if (resp.height != h || resp.width != w) {
            resp.internalAssign(new FImage(w, h));
        }
        if (this.res_ == null) {
            this.res_ = new FImage(w, h);
        }
        if (this.res_.height != h || this.res_.width != w) {
            this.res_.internalAssign(new FImage(w, h));
        }
        if (this._p.length == 1) {
            this._p[0].response(im, resp);
            this.sum2one(resp);
        } else {
            resp.fill(1.0f);
            for (int i = 0; i < this._p.length; ++i) {
                this._p[i].response(im, this.res_);
                this.sum2one(this.res_);
                resp.multiplyInplace(this.res_);
            }
            this.sum2one(resp);
        }
    }

    public MPatch copy() {
        MPatch m = new MPatch();
        m._w = this._w;
        m._h = this._h;
        m.res_ = this.res_;
        m._p = new Patch[this._p.length];
        for (int i = 0; i < this._p.length; ++i) {
            m._p[i] = this._p[i].copy();
        }
        return m;
    }

    static {
        Tracker.init();
    }
}

