/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import com.jsaragih.CLM;
import com.jsaragih.IO;
import com.jsaragih.Tracker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.openimaj.math.matrix.MatrixUtils;

public class PDM {
    public Matrix _V;
    public Matrix _E;
    public Matrix _M;
    private Matrix S_;
    private Matrix R_;
    private Matrix P_;
    private Matrix Px_;
    private Matrix Py_;
    private Matrix Pz_;
    private Matrix R1_;
    private Matrix R2_;
    private Matrix R3_;

    public PDM copy() {
        PDM p = new PDM();
        p._V = this._V.copy();
        p._E = this._E.copy();
        p._M = this._M.copy();
        p.S_ = this.S_.copy();
        p.R_ = this.R_.copy();
        p.P_ = this.P_.copy();
        p.Px_ = this.Px_.copy();
        p.Py_ = this.Py_.copy();
        p.Pz_ = this.Pz_.copy();
        p.R1_ = this.R1_.copy();
        p.R2_ = this.R2_.copy();
        p.R3_ = this.R3_.copy();
        return p;
    }

    void addOrthRow(Matrix R) {
        assert (R.getRowDimension() == 3 && R.getColumnDimension() == 3);
        R.set(2, 0, R.get(0, 1) * R.get(1, 2) - R.get(0, 2) * R.get(1, 1));
        R.set(2, 1, R.get(0, 2) * R.get(1, 0) - R.get(0, 0) * R.get(1, 2));
        R.set(2, 2, R.get(0, 0) * R.get(1, 1) - R.get(0, 1) * R.get(1, 0));
    }

    void metricUpgrade(Matrix R) {
        assert (R.getRowDimension() == 3 && R.getColumnDimension() == 3);
        SingularValueDecomposition svd = R.svd();
        Matrix X = svd.getU().times(svd.getV().transpose());
        Matrix W = Matrix.identity((int)3, (int)3);
        W.set(2, 2, X.det());
        R.setMatrix(0, 2, 0, 2, svd.getU().times(W).times(svd.getV().transpose()));
    }

    Matrix euler2Rot(double pitch, double yaw, double roll) {
        return this.euler2Rot(pitch, yaw, roll, true);
    }

    Matrix euler2Rot(double pitch, double yaw, double roll, boolean full) {
        Matrix R = full ? new Matrix(3, 3) : new Matrix(2, 3);
        double sina = Math.sin(pitch);
        double sinb = Math.sin(yaw);
        double sinc = Math.sin(roll);
        double cosa = Math.cos(pitch);
        double cosb = Math.cos(yaw);
        double cosc = Math.cos(roll);
        R.set(0, 0, cosb * cosc);
        R.set(0, 1, -cosb * sinc);
        R.set(0, 2, sinb);
        R.set(1, 0, cosa * sinc + sina * sinb * cosc);
        R.set(1, 1, cosa * cosc - sina * sinb * sinc);
        R.set(1, 2, -sina * cosb);
        if (full) {
            this.addOrthRow(R);
        }
        return R;
    }

    Matrix euler2Rot(Matrix p) {
        return this.euler2Rot(p, true);
    }

    Matrix euler2Rot(Matrix p, boolean full) {
        assert (p.getRowDimension() == 6 && p.getColumnDimension() == 1);
        return this.euler2Rot(p.get(1, 0), p.get(2, 0), p.get(3, 0), full);
    }

    double[] rot2Euler(Matrix R) {
        double[] q;
        assert (R.getRowDimension() == 3 && R.getColumnDimension() == 3);
        q = new double[]{Math.sqrt(1.0 + R.get(0, 0) + R.get(1, 1) + R.get(2, 2)) / 2.0, (R.get(2, 1) - R.get(1, 2)) / (4.0 * q[0]), (R.get(0, 2) - R.get(2, 0)) / (4.0 * q[0]), (R.get(1, 0) - R.get(0, 1)) / (4.0 * q[0])};
        double yaw = Math.asin(2.0 * (q[0] * q[2] + q[1] * q[3]));
        double pitch = Math.atan2(2.0 * (q[0] * q[1] - q[2] * q[3]), q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]);
        double roll = Math.atan2(2.0 * (q[0] * q[3] - q[1] * q[2]), q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]);
        return new double[]{pitch, roll, yaw};
    }

    void rot2Euler(Matrix R, Matrix p) {
        assert (p.getRowDimension() == 6 && p.getColumnDimension() == 1);
        double[] pry = this.rot2Euler(R);
        p.set(1, 0, pry[0]);
        p.set(2, 0, pry[2]);
        p.set(3, 0, pry[1]);
    }

    void align3Dto2DShapes(AlignmentParams ap, Matrix s2D, Matrix s3D) {
        int i;
        assert (s2D.getColumnDimension() == 1 && s3D.getRowDimension() == 3 * (s2D.getRowDimension() / 2) && s3D.getColumnDimension() == 1);
        int n = s2D.getRowDimension() / 2;
        double[] t2 = new double[2];
        double[] t3 = new double[3];
        Matrix X = MatrixUtils.reshape((Matrix)s2D, (int)2).transpose();
        Matrix S = MatrixUtils.reshape((Matrix)s3D, (int)3).transpose();
        for (i = 0; i < 2; ++i) {
            t2[i] = MatrixUtils.sumColumn((Matrix)X, (int)i) / (double)n;
            MatrixUtils.incrColumn((Matrix)X, (int)i, (double)(-t2[i]));
        }
        for (i = 0; i < 3; ++i) {
            t3[i] = MatrixUtils.sumColumn((Matrix)S, (int)i) / (double)n;
            MatrixUtils.incrColumn((Matrix)S, (int)i, (double)(-t3[i]));
        }
        Matrix M = S.transpose().times(S).inverse().times(S.transpose()).times(X);
        Matrix MtM = M.transpose().times(M);
        SingularValueDecomposition svd = MtM.svd();
        Matrix svals = svd.getS();
        svals.set(0, 0, 1.0 / Math.sqrt(svals.get(0, 0)));
        svals.set(1, 1, 1.0 / Math.sqrt(svals.get(1, 1)));
        Matrix T = new Matrix(3, 3);
        T.setMatrix(0, 1, 0, 2, svd.getU().times(svals).times(svd.getV().transpose()).times(M.transpose()));
        ap.scale = 0.0;
        for (int r = 0; r < 2; ++r) {
            for (int c = 0; c < 3; ++c) {
                ap.scale += T.get(r, c) * M.get(c, r);
            }
        }
        ap.scale *= 0.5;
        this.addOrthRow(T);
        double[] pyr = this.rot2Euler(T);
        ap.pitch = pyr[0];
        ap.roll = pyr[1];
        ap.yaw = pyr[2];
        T = T.times(ap.scale);
        ap.x = t2[0] - (T.get(0, 0) * t3[0] + T.get(0, 1) * t3[1] + T.get(0, 2) * t3[2]);
        ap.y = t2[1] - (T.get(1, 0) * t3[0] + T.get(1, 1) * t3[1] + T.get(1, 2) * t3[2]);
    }

    void clamp(Matrix p, double c) {
        assert (p.getRowDimension() == this._E.getColumnDimension() && p.getColumnDimension() == 1);
        for (int i = 0; i < p.getRowDimension(); ++i) {
            double v = c * Math.sqrt(this._E.get(0, i));
            double p1 = p.get(i, 0);
            if (!(Math.abs(p1) > v)) continue;
            p1 = p1 > 0.0 ? v : -v;
        }
    }

    Matrix calcShape3D(Matrix plocal) {
        assert (plocal.getRowDimension() == this._E.getColumnDimension() && plocal.getColumnDimension() == 1);
        Matrix s = this._M.plus(this._V.times(plocal));
        return s;
    }

    public void calcShape2D(Matrix s, Matrix plocal, Matrix pglobl) {
        assert (plocal.getRowDimension() == this._E.getColumnDimension() && plocal.getColumnDimension() == 1);
        assert (pglobl.getRowDimension() == 6 && pglobl.getColumnDimension() == 1);
        int n = this._M.getRowDimension() / 3;
        double a = pglobl.get(0, 0);
        double x = pglobl.get(4, 0);
        double y = pglobl.get(5, 0);
        this.R_ = this.euler2Rot(pglobl);
        this.S_ = this._M.plus(this._V.times(plocal));
        for (int i = 0; i < n; ++i) {
            s.set(i, 0, a * (this.R_.get(0, 0) * this.S_.get(i, 0) + this.R_.get(0, 1) * this.S_.get(i + n, 0) + this.R_.get(0, 2) * this.S_.get(i + n * 2, 0)) + x);
            s.set(i + n, 0, a * (this.R_.get(1, 0) * this.S_.get(i, 0) + this.R_.get(1, 1) * this.S_.get(i + n, 0) + this.R_.get(1, 2) * this.S_.get(i + n * 2, 0)) + y);
        }
    }

    public void calcParams(Matrix s, Matrix plocal, Matrix pglobl) {
        assert (s.getRowDimension() == 2 * (this._M.getRowDimension() / 3) && s.getColumnDimension() == 1);
        int n = this._M.getRowDimension() / 3;
        Matrix R = new Matrix(3, 3);
        Matrix t = new Matrix(3, 1);
        Matrix p = new Matrix(this._V.getColumnDimension(), 1);
        MatrixUtils.zero((Matrix)plocal);
        AlignmentParams ap = new AlignmentParams();
        for (int iter = 0; iter < 100; ++iter) {
            this.S_ = this.calcShape3D(plocal);
            this.align3Dto2DShapes(ap, s, this.S_);
            R = this.euler2Rot(ap.pitch, ap.yaw, ap.roll);
            Matrix r = new Matrix((double[][])new double[][]{R.getArray()[2]});
            Matrix S = MatrixUtils.reshape((Matrix)this.S_, (int)3).transpose();
            Matrix z = S.times(r.transpose()).times(ap.scale);
            double si = 1.0 / ap.scale;
            double Tx = -si * (R.get(0, 0) * ap.x + R.get(1, 0) * ap.y);
            double Ty = -si * (R.get(0, 1) * ap.x + R.get(1, 1) * ap.y);
            double Tz = -si * (R.get(0, 2) * ap.x + R.get(1, 2) * ap.y);
            for (int j = 0; j < n; ++j) {
                t.set(0, 0, s.get(j, 0));
                t.set(1, 0, s.get(j + n, 0));
                t.set(2, 0, z.get(j, 0));
                this.S_.set(j, 0, si * this.dotCol(t, R, 0) + Tx);
                this.S_.set(j + n, 0, si * this.dotCol(t, R, 1) + Ty);
                this.S_.set(j + n * 2, 0, si * this.dotCol(t, R, 2) + Tz);
            }
            plocal.setMatrix(0, p.getRowDimension() - 1, 0, 0, this._V.transpose().times(this.S_.minus(this._M)));
            if (iter > 0) {
                double norm = 0.0;
                for (int i = 0; i < plocal.getRowDimension(); ++i) {
                    double diff = plocal.get(i, 0) - p.get(i, 0);
                    norm += Math.abs(diff * diff);
                }
                if ((norm = Math.sqrt(norm)) < 1.0E-5) break;
            }
            p.setMatrix(0, p.getRowDimension() - 1, 0, 0, plocal);
        }
        pglobl.set(0, 0, ap.scale);
        pglobl.set(1, 0, ap.pitch);
        pglobl.set(2, 0, ap.yaw);
        pglobl.set(3, 0, ap.roll);
        pglobl.set(4, 0, ap.x);
        pglobl.set(5, 0, ap.y);
    }

    private double dotCol(Matrix colvec, Matrix m, int col) {
        int rows = colvec.getRowDimension();
        double[][] colvec_arr = colvec.getArray();
        double[][] m_arr = m.getArray();
        double dp = 0.0;
        for (int i = 0; i < rows; ++i) {
            dp += colvec_arr[i][0] * m_arr[i][col];
        }
        return dp;
    }

    public void identity(Matrix plocal, Matrix pglobl) {
        MatrixUtils.zero((Matrix)plocal);
        MatrixUtils.zero((Matrix)pglobl);
        pglobl.set(0, 0, 1.0);
    }

    void calcRigidJacob(Matrix plocal, Matrix pglobl, Matrix Jacob) {
        int n = this._M.getRowDimension() / 3;
        int m = this._V.getColumnDimension();
        assert (plocal.getRowDimension() == m && plocal.getColumnDimension() == 1 && pglobl.getRowDimension() == 6 && pglobl.getColumnDimension() == 1 && Jacob.getRowDimension() == 2 * n && Jacob.getColumnDimension() == 6);
        Matrix Rx = new Matrix((double[][])new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}});
        Matrix Ry = new Matrix((double[][])new double[][]{{0.0, 0.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}});
        Matrix Rz = new Matrix((double[][])new double[][]{{0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 0.0}});
        double s = pglobl.get(0, 0);
        this.S_ = this.calcShape3D(plocal);
        this.R_ = this.euler2Rot(pglobl);
        this.P_ = this.R_.getMatrix(0, 1, 0, 2).times(s);
        this.Px_ = this.P_.times(Rx);
        this.Py_ = this.P_.times(Ry);
        this.Pz_ = this.P_.times(Rz);
        double[][] px = this.Px_.getArray();
        double[][] py = this.Py_.getArray();
        double[][] pz = this.Pz_.getArray();
        double[][] r = this.R_.getArray();
        double[][] J = Jacob.getArray();
        for (int i = 0; i < n; ++i) {
            double X = this.S_.get(i, 0);
            double Y = this.S_.get(i + n, 0);
            double Z = this.S_.get(i + n * 2, 0);
            J[i][0] = r[0][0] * X + r[0][1] * Y + r[0][2] * Z;
            J[i + n][0] = r[1][0] * X + r[1][1] * Y + r[1][2] * Z;
            J[i][1] = px[0][0] * X + px[0][1] * Y + px[0][2] * Z;
            J[i + n][1] = px[1][0] * X + px[1][1] * Y + px[1][2] * Z;
            J[i][2] = py[0][0] * X + py[0][1] * Y + py[0][2] * Z;
            J[i + n][2] = py[1][0] * X + py[1][1] * Y + py[1][2] * Z;
            J[i][3] = pz[0][0] * X + pz[0][1] * Y + pz[0][2] * Z;
            J[i + n][3] = pz[1][0] * X + pz[1][1] * Y + pz[1][2] * Z;
            J[i][4] = 1.0;
            J[i + n][4] = 0.0;
            J[i][5] = 0.0;
            J[i + n][5] = 1.0;
        }
    }

    void calcJacob(Matrix plocal, Matrix pglobl, Matrix Jacob) {
        int n = this._M.getRowDimension() / 3;
        int m = this._V.getColumnDimension();
        assert (plocal.getRowDimension() == m && plocal.getColumnDimension() == 1 && pglobl.getRowDimension() == 6 && pglobl.getColumnDimension() == 1 && Jacob.getRowDimension() == 2 * n && Jacob.getColumnDimension() == 6 + m);
        double s = pglobl.get(0, 0);
        Matrix Rx = new Matrix((double[][])new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 1.0, 0.0}});
        Matrix Ry = new Matrix((double[][])new double[][]{{0.0, 0.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0}});
        Matrix Rz = new Matrix((double[][])new double[][]{{0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 0.0}});
        this.S_ = this.calcShape3D(plocal);
        this.R_ = this.euler2Rot(pglobl);
        this.P_ = this.R_.getMatrix(0, 1, 0, 2).times(s);
        this.Px_ = this.P_.times(Rx);
        this.Py_ = this.P_.times(Ry);
        this.Pz_ = this.P_.times(Rz);
        double[][] px = this.Px_.getArray();
        double[][] py = this.Py_.getArray();
        double[][] pz = this.Pz_.getArray();
        double[][] p = this.P_.getArray();
        double[][] r = this.R_.getArray();
        double[][] V = this._V.getArray();
        double[][] J = Jacob.getArray();
        for (int i = 0; i < n; ++i) {
            double X = this.S_.get(i, 0);
            double Y = this.S_.get(i + n, 0);
            double Z = this.S_.get(i + n * 2, 0);
            J[i][0] = r[0][0] * X + r[0][1] * Y + r[0][2] * Z;
            J[i + n][0] = r[1][0] * X + r[1][1] * Y + r[1][2] * Z;
            J[i][1] = px[0][0] * X + px[0][1] * Y + px[0][2] * Z;
            J[i + n][1] = px[1][0] * X + px[1][1] * Y + px[1][2] * Z;
            J[i][2] = py[0][0] * X + py[0][1] * Y + py[0][2] * Z;
            J[i + n][2] = py[1][0] * X + py[1][1] * Y + py[1][2] * Z;
            J[i][3] = pz[0][0] * X + pz[0][1] * Y + pz[0][2] * Z;
            J[i + n][3] = pz[1][0] * X + pz[1][1] * Y + pz[1][2] * Z;
            J[i][4] = 1.0;
            J[i + n][4] = 0.0;
            J[i][5] = 0.0;
            J[i + n][5] = 1.0;
            for (int j = 0; j < m; ++j) {
                J[i][6 + j] = p[0][0] * V[i][j] + p[0][1] * V[i + n][j] + p[0][2] * V[i + 2 * n][j];
                J[i + n][6 + j] = p[1][0] * V[i][j] + p[1][1] * V[i + n][j] + p[1][2] * V[i + 2 * n][j];
            }
        }
    }

    void calcReferenceUpdate(Matrix dp, Matrix plocal, Matrix pglobl) {
        assert (dp.getRowDimension() == 6 + this._V.getColumnDimension() && dp.getColumnDimension() == 1);
        plocal.setMatrix(0, plocal.getRowDimension() - 1, 0, plocal.getColumnDimension() - 1, plocal.plus(dp.getMatrix(6, 6 + this._V.getColumnDimension() - 1, 0, 0)));
        pglobl.set(0, 0, pglobl.get(0, 0) + dp.get(0, 0));
        pglobl.set(4, 0, pglobl.get(4, 0) + dp.get(4, 0));
        pglobl.set(5, 0, pglobl.get(5, 0) + dp.get(5, 0));
        this.R1_ = this.euler2Rot(pglobl);
        this.R2_ = Matrix.identity((int)3, (int)3);
        this.R2_.set(2, 1, dp.get(1, 0));
        this.R2_.set(1, 2, -this.R2_.get(2, 1));
        this.R2_.set(0, 2, dp.get(2, 0));
        this.R2_.set(2, 0, -this.R2_.get(0, 2));
        this.R2_.set(1, 0, dp.get(3, 0));
        this.R2_.set(0, 1, -this.R2_.get(1, 0));
        this.metricUpgrade(this.R2_);
        this.R3_ = this.R1_.times(this.R2_);
        this.rot2Euler(this.R3_, pglobl);
    }

    void applySimT(CLM.SimTData data, Matrix pglobl) {
        assert (pglobl.getRowDimension() == 6 && pglobl.getColumnDimension() == 1);
        double angle = Math.atan2(data.b, data.a);
        double scale = data.a / Math.cos(angle);
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        double xc = pglobl.get(4, 0);
        double yc = pglobl.get(5, 0);
        MatrixUtils.zero((Matrix)this.R1_);
        this.R1_.set(2, 2, 1.0);
        this.R1_.set(0, 0, ca);
        this.R1_.set(0, 1, -sa);
        this.R1_.set(1, 0, sa);
        this.R1_.set(1, 1, ca);
        this.R2_ = this.euler2Rot(pglobl);
        this.R3_ = this.R1_.times(this.R2_);
        pglobl.set(0, 0, pglobl.get(0, 0) * scale);
        this.rot2Euler(this.R3_, pglobl);
        pglobl.set(4, 0, data.a * xc - data.b * yc + data.tx);
        pglobl.set(5, 0, data.b * xc + data.a * yc + data.ty);
    }

    static PDM read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.PDM.ordinal());
        }
        PDM pdm = new PDM();
        pdm._V = IO.readMat(s);
        pdm._E = IO.readMat(s);
        pdm._M = IO.readMat(s);
        pdm.S_ = new Matrix(pdm._M.getRowDimension(), 1);
        pdm.R_ = new Matrix(3, 3);
        pdm.P_ = new Matrix(2, 3);
        pdm.Px_ = new Matrix(2, 3);
        pdm.Py_ = new Matrix(2, 3);
        pdm.Pz_ = new Matrix(2, 3);
        pdm.R1_ = new Matrix(3, 3);
        pdm.R2_ = new Matrix(3, 3);
        pdm.R3_ = new Matrix(3, 3);
        return pdm;
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.PDM.ordinal() + " ");
        IO.writeMat(s, this._V);
        IO.writeMat(s, this._E);
        IO.writeMat(s, this._M);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDM load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            PDM pDM = PDM.read(sc, true);
            return pDM;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public final int nPoints() {
        return this._M.getRowDimension() / 3;
    }

    int nModes() {
        return this._V.getColumnDimension();
    }

    double var(int i) {
        assert (i < this._E.getColumnDimension());
        return this._E.get(0, i);
    }

    static {
        Tracker.init();
    }

    class AlignmentParams {
        double scale;
        double pitch;
        double yaw;
        double roll;
        double x;
        double y;

        AlignmentParams() {
        }
    }
}

