/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import com.jsaragih.CLM;
import com.jsaragih.FDet;
import com.jsaragih.IO;
import com.jsaragih.MFCheck;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.FourierTemplateMatcher;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Inproceedings, author={"Jason M. Saragih", "Simon Lucey", "Jeffrey F. Cohn"}, title="Face alignment through subspace constrained mean-shifts", year="2009", booktitle="IEEE 12th International Conference on Computer Vision, ICCV 2009, Kyoto, Japan, September 27 - October 4, 2009", pages={"1034", "1041"}, publisher="IEEE", customData={"doi", "http://dx.doi.org/10.1109/ICCV.2009.5459377", "researchr", "http://researchr.org/publication/SaragihLC09", "cites", "0", "citedby", "0"})
public class Tracker {
    private static boolean init = false;
    private static final double TSCALE = 0.3;
    public CLM _clm;
    FDet _fdet;
    long _frame;
    MFCheck _fcheck;
    public Matrix _shape;
    public Matrix _rshape;
    Rectangle _rect;
    double[] _simil;
    FImage gray_;
    FImage temp_;
    private FImage small_;

    static synchronized void init() {
        if (!init) {
            System.err.println("This software uses the OpenIMAJ port of FaceTracker.");
            System.err.println("FaceTracker has a different license to the rest of OpenIMAJ:");
            System.err.println();
            System.err.println("FaceTracker Licence");
            System.err.println("-------------------");
            System.err.println("(Academic, non-commercial, not-for-profit licence)");
            System.err.println();
            System.err.println("Copyright (c) 2010 Jason Mora Saragih");
            System.err.println("All rights reserved.");
            System.err.println("");
            System.err.println("Redistribution and use in source and binary forms, with or without ");
            System.err.println("modification, are permitted provided that the following conditions are met:");
            System.err.println();
            System.err.println("    * The software is provided under the terms of this licence stricly for");
            System.err.println("      academic, non-commercial, not-for-profit purposes.");
            System.err.println("    * Redistributions of source code must retain the above copyright notice, ");
            System.err.println("      this list of conditions (licence) and the following disclaimer.");
            System.err.println("    * Redistributions in binary form must reproduce the above copyright ");
            System.err.println("      notice, this list of conditions (licence) and the following disclaimer ");
            System.err.println("      in the documentation and/or other materials provided with the ");
            System.err.println("      distribution.");
            System.err.println("    * The name of the author may not be used to endorse or promote products ");
            System.err.println("      derived from this software without specific prior written permission.");
            System.err.println("    * As this software depends on other libraries, the user must adhere to and ");
            System.err.println("      keep in place any licencing terms of those libraries.");
            System.err.println("    * Any publications arising from the use of this software, including but");
            System.err.println("      not limited to academic journal and conference publications, technical");
            System.err.println("      reports and manuals, must cite the following work:");
            System.err.println();
            System.err.println("      J. M. Saragih, S. Lucey, and J. F. Cohn. Face Alignment through Subspace ");
            System.err.println("      Constrained Mean-Shifts. International Journal of Computer Vision ");
            System.err.println("      (ICCV), September, 2009.");
            System.err.println();
            System.err.println("THIS SOFTWARE IS PROVIDED BY THE AUTHOR \"AS IS\" AND ANY EXPRESS OR IMPLIED ");
            System.err.println("WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF ");
            System.err.println("MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO ");
            System.err.println("EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, ");
            System.err.println("INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, ");
            System.err.println("BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, ");
            System.err.println("DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY ");
            System.err.println("OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING ");
            System.err.println("NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, ");
            System.err.println("EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
            init = true;
        }
    }

    Tracker(CLM clm, FDet fdet, MFCheck fcheck, Matrix rshape, double[] simil) {
        this._clm = clm;
        this._fdet = fdet;
        this._fcheck = fcheck;
        this._rshape = rshape.copy();
        this._simil = simil;
        this._shape = new Matrix(2 * this._clm._pdm.nPoints(), 1);
        this._rect.x = 0.0f;
        this._rect.y = 0.0f;
        this._rect.width = 0.0f;
        this._rect.height = 0.0f;
        this._frame = -1L;
        this._clm._pdm.identity(this._clm._plocal, this._clm._pglobl);
    }

    Tracker() {
    }

    public void frameReset() {
        this._frame = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Tracker load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            Tracker tracker = Tracker.read(sc, true);
            return tracker;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracker load(InputStream in) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in));
            Scanner sc = new Scanner(br);
            Tracker tracker = Tracker.read(sc, true);
            return tracker;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String fname) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fname));
            this.write(bw);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void write(BufferedWriter s) throws IOException {
        s.write(IO.Types.TRACKER.ordinal() + " ");
        this._clm.write(s);
        this._fdet.write(s);
        this._fcheck.write(s);
        IO.writeMat(s, this._rshape);
        s.write(this._simil[0] + " " + this._simil[1] + " " + this._simil[2] + " " + this._simil[3] + " ");
    }

    static Tracker read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.TRACKER.ordinal());
        }
        Tracker tracker = new Tracker();
        tracker._clm = CLM.read(s, true);
        tracker._fdet = FDet.read(s, true);
        tracker._fcheck = MFCheck.read(s, true);
        tracker._rshape = IO.readMat(s);
        tracker._simil = new double[]{s.nextDouble(), s.nextDouble(), s.nextDouble(), s.nextDouble()};
        tracker._shape = new Matrix(2 * tracker._clm._pdm.nPoints(), 1);
        tracker._rect = new Rectangle();
        tracker._rect.x = 0.0f;
        tracker._rect.y = 0.0f;
        tracker._rect.width = 0.0f;
        tracker._rect.height = 0.0f;
        tracker._frame = -1L;
        tracker._clm._pdm.identity(tracker._clm._plocal, tracker._clm._pglobl);
        return tracker;
    }

    public int track(FImage im, int[] wSize, int fpd, int nIter, double clamp, double fTol, boolean fcheck) {
        boolean gen;
        this.gray_ = im;
        boolean rsize = true;
        Rectangle R = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        if (this._frame < 0L || fpd >= 0 && (long)fpd < this._frame) {
            this._frame = 0L;
            List<Rectangle> RL = this._fdet.detect(this.gray_);
            double max = 0.0;
            for (Rectangle r : RL) {
                if (!(r.calculateArea() > max)) continue;
                max = r.calculateArea();
                R = r;
            }
            gen = true;
        } else {
            R = this.redetect(this.gray_);
            gen = false;
        }
        if (R.width == 0.0f || R.height == 0.0f) {
            this._frame = -1L;
            return -1;
        }
        ++this._frame;
        if (gen) {
            this.initShape(R, this._shape);
            this._clm._pdm.calcParams(this._shape, this._clm._plocal, this._clm._pglobl);
        } else {
            double tx = R.x - this._rect.x;
            double ty = R.y - this._rect.y;
            double[] dArray = this._clm._pglobl.getArray()[4];
            dArray[0] = dArray[0] + tx;
            double[] dArray2 = this._clm._pglobl.getArray()[5];
            dArray2[0] = dArray2[0] + ty;
            rsize = false;
        }
        this._clm.fit(this.gray_, wSize, nIter, clamp, fTol);
        this._clm._pdm.calcShape2D(this._shape, this._clm._plocal, this._clm._pglobl);
        if (fcheck && !this._fcheck.check(this._clm.getViewIdx(), this.gray_, this._shape)) {
            return -1;
        }
        this._rect = this.updateTemplate(this.gray_, this._shape, rsize);
        if (this._rect.width == 0.0f || this._rect.height == 0.0f) {
            return -1;
        }
        return 0;
    }

    void initShape(Rectangle r, Matrix shape) {
        assert (shape.getRowDimension() == this._rshape.getRowDimension() && shape.getColumnDimension() == this._rshape.getColumnDimension());
        int n = this._rshape.getRowDimension() / 2;
        double a = (double)r.width * Math.cos(this._simil[1]) * this._simil[0] + 1.0;
        double b = (double)r.width * Math.sin(this._simil[1]) * this._simil[0];
        double tx = (double)(r.x + (float)((int)(r.width / 2.0f))) + (double)r.width * this._simil[2];
        double ty = (double)(r.y + (float)((int)(r.height / 2.0f))) + (double)r.height * this._simil[3];
        double[][] s = this._rshape.getArray();
        double[][] d = shape.getArray();
        for (int i = 0; i < n; ++i) {
            d[i][0] = a * s[i][0] - b * s[i + n][0] + tx;
            d[i + n][0] = b * s[i][0] + a * s[i + n][0] + ty;
        }
    }

    Rectangle redetect(FImage im) {
        int ww = im.width;
        int hh = im.height;
        int w = (int)(0.3 * (double)ww - (double)this.temp_.width + 1.0);
        int h = (int)(0.3 * (double)hh - (double)this.temp_.height + 1.0);
        this.small_ = ResizeProcessor.resample((FImage)im, (int)((int)(0.3 * (double)ww)), (int)((int)(0.3 * (double)hh)));
        h = this.small_.height - this.temp_.height + 1;
        w = this.small_.width - this.temp_.width + 1;
        FourierTemplateMatcher matcher = new FourierTemplateMatcher(this.temp_, FourierTemplateMatcher.Mode.NORM_CORRELATION_COEFFICIENT);
        matcher.analyseImage(this.small_);
        float[][] ncc_ = matcher.getResponseMap().pixels;
        Rectangle R = this.temp_.getBounds();
        float vb = -2.0f;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float v = ncc_[y][x];
                if (!(v > vb)) continue;
                vb = v;
                R.x = x;
                R.y = y;
            }
        }
        R.x = (float)((double)R.x * 3.3333333333333335);
        R.y = (float)((double)R.y * 3.3333333333333335);
        R.width = (float)((double)R.width * 3.3333333333333335);
        R.height = (float)((double)R.height * 3.3333333333333335);
        return R;
    }

    Rectangle updateTemplate(FImage im, Matrix s, boolean rsize) {
        int n = s.getRowDimension() / 2;
        double[][] sv = s.getArray();
        double xmax = sv[0][0];
        double ymax = sv[n][0];
        double xmin = sv[0][0];
        double ymin = sv[n][0];
        for (int i = 0; i < n; ++i) {
            double vx = sv[i][0];
            double vy = sv[i + n][0];
            xmax = Math.max(xmax, vx);
            ymax = Math.max(ymax, vy);
            xmin = Math.min(xmin, vx);
            ymin = Math.min(ymin, vy);
        }
        if (xmin < 0.0 || ymin < 0.0 || xmax >= (double)im.width || ymax >= (double)im.height || Double.isNaN(xmin) || Double.isInfinite(xmin) || Double.isNaN(xmax) || Double.isInfinite(xmax) || Double.isNaN(ymin) || Double.isInfinite(ymin) || Double.isNaN(ymax) || Double.isInfinite(ymax)) {
            return new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Rectangle R = new Rectangle((float)Math.floor(xmin *= 0.3), (float)Math.floor(ymin *= 0.3), (float)Math.ceil((xmax *= 0.3) - xmin), (float)Math.ceil((ymax *= 0.3) - ymin));
        int ww = im.width;
        int hh = im.height;
        if (rsize) {
            this.small_ = ResizeProcessor.resample((FImage)im, (int)((int)(0.3 * (double)ww)), (int)((int)(0.3 * (double)hh)));
        }
        this.temp_ = (FImage)this.small_.extractROI(R);
        R.x = (float)((double)R.x * 3.3333333333333335);
        R.y = (float)((double)R.y * 3.3333333333333335);
        R.width = (float)((double)R.width * 3.3333333333333335);
        R.height = (float)((double)R.height * 3.3333333333333335);
        return R;
    }

    static {
        Tracker.init();
    }
}

