/*
 * Decompiled with CFR 0.152.
 */
package org.lemurproject.ireval;

import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.distribution.TDistributionImpl;

public class SetRetrievalComparator {
    double[] baseline;
    double[] treatment;

    public SetRetrievalComparator(Map<String, Double> baseline, Map<String, Double> treatment) {
        TreeSet<String> commonQueries = new TreeSet<String>(baseline.keySet());
        commonQueries.retainAll(treatment.keySet());
        this.baseline = new double[commonQueries.size()];
        this.treatment = new double[commonQueries.size()];
        int i = 0;
        for (String key : commonQueries) {
            this.baseline[i] = baseline.get(key);
            this.treatment[i] = treatment.get(key);
            ++i;
        }
    }

    private double mean(double[] numbers) {
        double sum = 0.0;
        for (int i = 0; i < numbers.length; ++i) {
            sum += numbers[i];
        }
        return sum / (double)numbers.length;
    }

    public double meanBaselineMetric() {
        return this.mean(this.baseline);
    }

    public double meanTreatmentMetric() {
        return this.mean(this.treatment);
    }

    public int countTreatmentBetter() {
        int better = 0;
        for (int i = 0; i < this.baseline.length; ++i) {
            if (!(this.baseline[i] < this.treatment[i])) continue;
            ++better;
        }
        return better;
    }

    public int countBaselineBetter() {
        int better = 0;
        for (int i = 0; i < this.baseline.length; ++i) {
            if (!(this.baseline[i] > this.treatment[i])) continue;
            ++better;
        }
        return better;
    }

    public int countEqual() {
        int same = 0;
        for (int i = 0; i < this.baseline.length; ++i) {
            if (this.baseline[i] != this.treatment[i]) continue;
            ++same;
        }
        return same;
    }

    public double pairedTTest() {
        double sampleSum = 0.0;
        double sampleSumSquares = 0.0;
        int n = this.baseline.length;
        for (int i = 0; i < this.baseline.length; ++i) {
            double delta = this.treatment[i] - this.baseline[i];
            sampleSum += delta;
            sampleSumSquares += delta * delta;
        }
        double sampleVariance = sampleSumSquares / (double)(n - 1);
        double sampleMean = sampleSum / (double)this.baseline.length;
        double sampleDeviation = Math.sqrt(sampleVariance);
        double meanDeviation = sampleDeviation / Math.sqrt(n);
        double t = sampleMean / meanDeviation;
        try {
            return 1.0 - new TDistributionImpl((double)n).cumulativeProbability(t);
        }
        catch (MathException e) {
            throw new RuntimeException(e);
        }
    }

    public double signTest() {
        double pvalue;
        int treatmentIsBetter = 0;
        int different = 0;
        for (int i = 0; i < this.treatment.length; ++i) {
            if (this.treatment[i] > this.baseline[i]) {
                ++treatmentIsBetter;
            }
            if (this.treatment[i] == this.baseline[i]) continue;
            ++different;
        }
        try {
            pvalue = 1.0 - new BinomialDistributionImpl(different, 0.5).cumulativeProbability(treatmentIsBetter - 1);
        }
        catch (MathException e) {
            throw new RuntimeException(e);
        }
        return pvalue;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public double randomizedTest() {
        double baseMean = this.mean(this.baseline);
        double treatmentMean = this.mean(this.treatment);
        double difference = treatmentMean - baseMean;
        int batch = 10000;
        int maxIterationsWithoutMatch = 1000000;
        long iterations = 0L;
        long matches = 0L;
        double[] leftSample = new double[this.baseline.length];
        double[] rightSample = new double[this.baseline.length];
        Random random = new Random();
        double pValue = 0.0;
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i < batch) {
                } else {
                    pValue = (double)matches / (double)(iterations += (long)batch);
                    if (matches == 0L) {
                        if (iterations >= 1000000L) return pValue;
                        continue block0;
                    }
                    double maxDeviation = Math.max(5.0E-7 / pValue, Math.min(5.0E-5 / pValue, 0.05));
                    double estimatedIterations = Math.sqrt(pValue * (1.0 - pValue)) / maxDeviation;
                    if ((double)iterations > estimatedIterations) return pValue;
                    continue block0;
                }
                for (int j = 0; j < this.baseline.length; ++j) {
                    if (random.nextBoolean()) {
                        leftSample[j] = this.baseline[j];
                        rightSample[j] = this.treatment[j];
                        continue;
                    }
                    leftSample[j] = this.treatment[j];
                    rightSample[j] = this.baseline[j];
                }
                double sampleDifference = this.mean(leftSample) - this.mean(rightSample);
                if (difference <= sampleDifference) {
                    ++matches;
                }
                ++i;
            }
            break;
        }
    }
}

