/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.DenseVector;
import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.SparseVector;
import ch.akuhn.matrix.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Scanner;

public class SparseMatrix
extends Matrix {
    private int columns;
    private List<Vector> rows;

    public SparseMatrix(double[][] values) {
        this.columns = values[0].length;
        this.rows = new ArrayList<Vector>(values.length);
        for (double[] each : values) {
            this.addRow(each);
        }
    }

    public SparseMatrix(int rows, int columns) {
        this.columns = columns;
        this.rows = new ArrayList<Vector>(rows);
        for (int times = 0; times < rows; ++times) {
            this.addRow();
        }
    }

    @Override
    public double add(int row, int column, double sum) {
        return this.rows.get(row).add(column, sum);
    }

    public int addColumn() {
        ++this.columns;
        for (Vector each : this.rows) {
            ((SparseVector)each).resizeTo(this.columns);
        }
        return this.columns - 1;
    }

    public int addRow() {
        this.rows.add(new SparseVector(this.columns));
        return this.rowCount() - 1;
    }

    protected int addRow(double[] values) {
        this.rows.add(new SparseVector(values));
        return this.rowCount() - 1;
    }

    public void addToRow(int row, Vector values) {
        Vector v = this.rows.get(row);
        for (Vector.Entry each : values.entries()) {
            v.add(each.index, each.value);
        }
    }

    public double[][] asDenseDoubleDouble() {
        double[][] dense = new double[this.rowCount()][this.columnCount()];
        for (int ri = 0; ri < this.rows.size(); ++ri) {
            Vector row = this.rows.get(ri);
            for (Vector.Entry column : row.entries()) {
                dense[ri][column.index] = column.value;
            }
        }
        return dense;
    }

    @Override
    public int columnCount() {
        return this.columns;
    }

    public boolean equals(Object obj) {
        return obj instanceof SparseMatrix && ((Object)this.rows).equals(((SparseMatrix)obj).rows);
    }

    @Override
    public double get(int row, int column) {
        return this.rows.get(row).get(column);
    }

    public int hashCode() {
        return ((Object)this.rows).hashCode();
    }

    @Override
    public double put(int row, int column, double value) {
        return this.rows.get(row).put(column, value);
    }

    @Override
    public Iterable<Vector> rows() {
        return Collections.unmodifiableCollection(this.rows);
    }

    @Override
    public Vector row(int row) {
        return this.rows.get(row);
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    public void setRow(int row, SparseVector values) {
        this.rows.set(row, values);
    }

    @Override
    public int used() {
        int used = 0;
        for (Vector each : this.rows) {
            used += each.used();
        }
        return used;
    }

    public void trim() {
        for (Vector each : this.rows) {
            ((SparseVector)each).trim();
        }
    }

    public static SparseMatrix readFrom(Scanner scan) {
        int columns = scan.nextInt();
        int rows = scan.nextInt();
        int used = scan.nextInt();
        SparseMatrix matrix = new SparseMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            int len = scan.nextInt();
            for (int i = 0; i < len; ++i) {
                int column = scan.nextInt();
                double value = scan.nextDouble();
                matrix.put(row, column, value);
            }
        }
        assert (matrix.used() == used);
        return matrix;
    }

    public static SparseMatrix random(int n, int m, double density) {
        Random random = new Random();
        SparseMatrix A = new SparseMatrix(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                if (random.nextDouble() > density) continue;
                A.put(i, j, random.nextDouble());
            }
        }
        return A;
    }

    @Override
    public Vector mult(Vector dense) {
        assert (dense.size() == this.columnCount());
        double[] y = new double[this.rowCount()];
        double[] x = ((DenseVector)dense).values;
        for (int i = 0; i < y.length; ++i) {
            SparseVector row = (SparseVector)this.rows.get(i);
            double sum = 0.0;
            for (int k = 0; k < row.used; ++k) {
                sum += x[row.keys[k]] * row.values[k];
            }
            y[i] = sum;
        }
        return Vector.wrap(y);
    }

    @Override
    public Vector transposeMultiply(Vector dense) {
        assert (dense.size() == this.rowCount());
        double[] y = new double[this.columnCount()];
        double[] x = ((DenseVector)dense).values;
        for (int i = 0; i < x.length; ++i) {
            SparseVector row = (SparseVector)this.rows.get(i);
            for (int k = 0; k < row.used; ++k) {
                int n = row.keys[k];
                y[n] = y[n] + x[i] * row.values[k];
            }
        }
        return Vector.wrap(y);
    }

    @Override
    public Matrix newInstance(int rows, int cols) {
        return new SparseMatrix(rows, cols);
    }
}

