/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.ocr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.analysis.algorithm.TemplateMatcher;
import org.openimaj.image.pixel.FValuePixel;

public class SimpleOCR {
    private TemplateMatcher[] templates = new TemplateMatcher[10];

    public SimpleOCR() throws IOException {
        for (int i = 0; i < 10; ++i) {
            FImage img = ImageUtilities.readF((InputStream)SimpleOCR.class.getResourceAsStream(i + ".png"));
            this.templates[i] = new TemplateMatcher(img, TemplateMatcher.Mode.NORM_CORRELATION_COEFFICIENT);
        }
    }

    String processInternal(FImage img, String separator, int ... pattern) throws Exception {
        ArrayList<NumberOccurance> occurances = new ArrayList<NumberOccurance>();
        int num = 0;
        for (int i : pattern) {
            num += i;
        }
        for (int i = 0; i < 10; ++i) {
            FValuePixel[] resp;
            this.templates[i].analyseImage(img);
            for (FValuePixel pt : resp = this.templates[i].getBestResponses(num)) {
                if (!((double)pt.value > 0.95)) continue;
                occurances.add(new NumberOccurance(pt.x, i));
            }
        }
        if (occurances.size() != num) {
            throw new Exception();
        }
        Collections.sort(occurances);
        String result = "";
        int i = 0;
        int j = 0;
        for (NumberOccurance no : occurances) {
            if (pattern[i] == j) {
                j = 0;
                ++i;
                result = result + separator;
            }
            result = result + no.value;
            ++j;
        }
        return result;
    }

    public String process(FImage image) throws Exception {
        String date = this.processInternal(this.extractDateArea(image), "/", 4, 2, 2);
        String time = this.processInternal(this.extractTimeArea(image), ":", 2, 2, 2);
        return date + " " + time;
    }

    private FImage extractDateArea(FImage image) {
        return image.extractROI(664, 1024, 176, 16);
    }

    private FImage extractTimeArea(FImage image) {
        return image.extractROI(840, 1024, 144, 16);
    }

    public static void main(String[] args) throws Exception {
        SimpleOCR gocr = new SimpleOCR();
        for (String f : args) {
            try {
                FImage image = f.contains("://") ? ImageUtilities.readF((URL)new URL(f)) : ImageUtilities.readF((File)new File(f));
                System.out.println(f + " " + gocr.process(image));
            }
            catch (Exception e) {
                System.out.println(f + " error occurred performing ocr");
            }
        }
    }

    class NumberOccurance
    implements Comparable<NumberOccurance> {
        int offset;
        int value;

        NumberOccurance(int offset, int value) {
            this.offset = offset;
            this.value = value;
        }

        @Override
        public int compareTo(NumberOccurance o) {
            return Integer.valueOf(this.offset).compareTo(o.offset);
        }
    }
}

