/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera;

import Jama.Matrix;
import org.openimaj.image.camera.CameraIntrinsics;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.point.Point3d;
import org.openimaj.math.matrix.MatrixUtils;

public class Camera {
    public CameraIntrinsics intrinsicParameters;
    public Matrix rotation;
    public Point3d translation;

    public Matrix computeHomography() {
        Matrix A = this.rotation.copy();
        A.set(0, 2, this.translation.getX());
        A.set(1, 2, this.translation.getY());
        A.set(2, 2, this.translation.getZ());
        Matrix H = this.intrinsicParameters.calibrationMatrix.times(A);
        MatrixUtils.times((Matrix)H, (double)(1.0 / H.get(2, 2)));
        return H;
    }

    public Point2d project(Point2d pt) {
        Matrix H = this.computeHomography();
        Point2d p = pt.transform(H);
        return this.intrinsicParameters.applyDistortion(p);
    }

    public Point2d project(Point3d pt) {
        Matrix ptm = new Matrix((double[][])new double[][]{{pt.getX()}, {pt.getY()}, {pt.getZ()}, {1.0}});
        double[][] rv = this.rotation.getArray();
        Matrix Rt = new Matrix((double[][])new double[][]{{rv[0][0], rv[0][1], rv[0][2], this.translation.getX()}, {rv[1][0], rv[1][1], rv[1][2], this.translation.getY()}, {rv[2][0], rv[2][1], rv[2][2], this.translation.getZ()}});
        Matrix ARt = this.intrinsicParameters.calibrationMatrix.times(Rt);
        Matrix pr = ARt.times(ptm);
        Point2dImpl p = new Point2dImpl(pr.get(0, 0) / pr.get(2, 0), pr.get(1, 0) / pr.get(2, 0));
        return this.intrinsicParameters.applyDistortion((Point2d)p);
    }
}

