/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera;

import Jama.Matrix;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.transform.RemapProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class CameraIntrinsics {
    public Matrix calibrationMatrix;
    public double k1;
    public double k2;
    public double k3;
    public double p1;
    public double p2;
    public int width;
    public int height;

    public CameraIntrinsics(Matrix m, int width, int height) {
        this.calibrationMatrix = m;
        this.width = width;
        this.height = height;
    }

    public double getFocalLengthX() {
        return this.calibrationMatrix.get(0, 0);
    }

    public double getFocalLengthY() {
        return this.calibrationMatrix.get(1, 1);
    }

    public double getPrincipalPointX() {
        return this.calibrationMatrix.get(0, 2);
    }

    public double getPrincipalPointY() {
        return this.calibrationMatrix.get(1, 2);
    }

    public void setFocalLengthX(double fy) {
        this.calibrationMatrix.set(0, 0, fy);
    }

    public void setFocalLengthY(double fy) {
        this.calibrationMatrix.set(1, 1, fy);
    }

    public void setPrincipalPointX(double cx) {
        this.calibrationMatrix.set(0, 2, cx);
    }

    public void setPrincipalPointY(double cy) {
        this.calibrationMatrix.set(1, 2, cy);
    }

    public void setSkewFactor(double skew) {
        this.calibrationMatrix.set(0, 1, skew);
    }

    public double getSkewFactor() {
        return this.calibrationMatrix.get(0, 1);
    }

    public Point2d applyDistortion(Point2d p) {
        double dx = ((double)p.getX() - this.getPrincipalPointX()) / this.getFocalLengthX();
        double dy = ((double)p.getY() - this.getPrincipalPointY()) / this.getFocalLengthY();
        double r2 = dx * dx + dy * dy;
        double r4 = r2 * r2;
        double r6 = r2 * r2 * r2;
        double tx = dx * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
        double ty = dy * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
        p.translate((float)(tx += 2.0 * this.p1 * dx * dy + this.p2 * (r2 + 2.0 * dx * dx)), (float)(ty += this.p1 * (r2 + 2.0 * dy * dy) + 2.0 * this.p2 * dx * dy));
        return p;
    }

    public CameraIntrinsics getScaledIntrinsics(int newWidth, int newHeight) {
        double sx = (double)newWidth / (double)this.width;
        double sy = (double)newHeight / (double)this.height;
        Matrix m = TransformUtilities.scaleMatrix((double)sx, (double)sy).times(this.calibrationMatrix);
        CameraIntrinsics newCam = new CameraIntrinsics(m, newWidth, newHeight);
        newCam.k1 = this.k1;
        newCam.k2 = this.k2;
        newCam.k3 = this.k3;
        newCam.p1 = this.p1;
        newCam.p2 = this.p2;
        return newCam;
    }

    public String toString() {
        return String.format("fx: %2.2f; fy: %2.2f; sk: %2.6f; u0: %2.2f; v0: %2.2f; k1: %2.6f; k2: %2.6f; k3: %2.6f; p1: %2.6f; p2: %2.6f", this.getFocalLengthX(), this.getFocalLengthY(), this.getSkewFactor(), this.getPrincipalPointX(), this.getPrincipalPointY(), this.k1, this.k2, this.k3, this.p1, this.p2);
    }

    public RemapProcessor buildUndistortionProcessor() {
        return this.buildUndistortionProcessor(this.width, this.height);
    }

    public RemapProcessor buildUndistortionProcessor(int width, int height) {
        FImage[] map = this.buildUndistortionMap(width, height);
        return new RemapProcessor(map[0], map[1]);
    }

    public RemapProcessor buildUndistortionProcessor(int width, int height, CameraIntrinsics target) {
        FImage[] map = this.buildUndistortionMap(width, height, target);
        return new RemapProcessor(map[0], map[1]);
    }

    public RemapProcessor buildRectifiedUndistortionProcessor(int width, int height, CameraIntrinsics target, Matrix R) {
        FImage[] map = this.buildRectifiedUndistortionMap(width, height, target, R);
        return new RemapProcessor(map[0], map[1]);
    }

    public FImage[] buildUndistortionMap(int width, int height) {
        FImage xords = new FImage(width, height);
        FImage yords = new FImage(width, height);
        double px = this.getPrincipalPointX();
        double py = this.getPrincipalPointY();
        double fx = this.getFocalLengthX();
        double fy = this.getFocalLengthY();
        for (int v = 0; v < height; ++v) {
            double y = ((double)v - py) / fy;
            for (int u = 0; u < width; ++u) {
                double x = ((double)u - px) / fx;
                double r2 = x * x + y * y;
                double r4 = r2 * r2;
                double r6 = r2 * r2 * r2;
                double tx = x * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                double ty = y * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                xords.pixels[v][u] = (float)((x + (tx += 2.0 * this.p1 * x * y + this.p2 * (r2 + 2.0 * x * x))) * fx + px);
                yords.pixels[v][u] = (float)((y + (ty += this.p1 * (r2 + 2.0 * y * y) + 2.0 * this.p2 * x * y)) * fy + py);
            }
        }
        return new FImage[]{xords, yords};
    }

    public FImage[] buildUndistortionMap(int width, int height, CameraIntrinsics target) {
        FImage xords = new FImage(width, height);
        FImage yords = new FImage(width, height);
        double pxp = target.getPrincipalPointX();
        double pyp = target.getPrincipalPointY();
        double fxp = target.getFocalLengthX();
        double fyp = target.getFocalLengthY();
        double px = this.getPrincipalPointX();
        double py = this.getPrincipalPointY();
        double fx = this.getFocalLengthX();
        double fy = this.getFocalLengthY();
        for (int v = 0; v < height; ++v) {
            double y = ((double)v - pyp) / fyp;
            for (int u = 0; u < width; ++u) {
                double x = ((double)u - pxp) / fxp;
                double r2 = x * x + y * y;
                double r4 = r2 * r2;
                double r6 = r2 * r2 * r2;
                double tx = x * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                double ty = y * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                xords.pixels[v][u] = (float)((x + (tx += 2.0 * this.p1 * x * y + this.p2 * (r2 + 2.0 * x * x))) * fx + px);
                yords.pixels[v][u] = (float)((y + (ty += this.p1 * (r2 + 2.0 * y * y) + 2.0 * this.p2 * x * y)) * fy + py);
            }
        }
        return new FImage[]{xords, yords};
    }

    public FImage[] buildRectifiedUndistortionMap(int width, int height, CameraIntrinsics target, Matrix R) {
        FImage xords = new FImage(width, height);
        FImage yords = new FImage(width, height);
        double pxp = target.getPrincipalPointX();
        double pyp = target.getPrincipalPointY();
        double fxp = target.getFocalLengthX();
        double fyp = target.getFocalLengthY();
        double px = this.getPrincipalPointX();
        double py = this.getPrincipalPointY();
        double fx = this.getFocalLengthX();
        double fy = this.getFocalLengthY();
        Matrix Rinv = R.inverse();
        Matrix tmp = new Matrix(3, 1);
        tmp.set(2, 0, 1.0);
        for (int v = 0; v < height; ++v) {
            double y = ((double)v - pyp) / fyp;
            for (int u = 0; u < width; ++u) {
                double x = ((double)u - pxp) / fxp;
                tmp.set(0, 0, x);
                tmp.set(1, 0, y);
                Matrix pro = Rinv.times(tmp);
                x = pro.get(0, 0) / pro.get(2, 0);
                y = pro.get(1, 0) / pro.get(2, 0);
                double r2 = x * x + y * y;
                double r4 = r2 * r2;
                double r6 = r2 * r2 * r2;
                double tx = x * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                double ty = y * (this.k1 * r2 + this.k2 * r4 + this.k3 * r6);
                xords.pixels[v][u] = (float)((x + (tx += 2.0 * this.p1 * x * y + this.p2 * (r2 + 2.0 * x * x))) * fx + px);
                yords.pixels[v][u] = (float)((y + (ty += this.p1 * (r2 + 2.0 * y * y) + 2.0 * this.p2 * x * y)) * fy + py);
            }
        }
        return new FImage[]{xords, yords};
    }

    public <I extends Image<?, I>> I undistort(I image) {
        RemapProcessor proc = this.buildUndistortionProcessor(image.getWidth(), image.getHeight());
        return (I)((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)proc);
    }
}

