/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera.calibration;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.openimaj.image.camera.Camera;
import org.openimaj.image.camera.CameraIntrinsics;
import org.openimaj.image.camera.calibration.CameraCalibrationZhang;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.HomographyRefinement;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.util.pair.IndependentPair;

public class CameraCalibration
extends CameraCalibrationZhang {
    public CameraCalibration(List<List<? extends IndependentPair<? extends Point2d, ? extends Point2d>>> points, int width, int height) {
        super(points, width, height);
    }

    @Override
    protected void performCalibration(int width, int height) {
        ArrayList<Matrix> homographies = new ArrayList<Matrix>();
        for (int i = 0; i < this.points.size(); ++i) {
            List data = (List)this.points.get(i);
            Matrix h = HomographyRefinement.SINGLE_IMAGE_TRANSFER.refine(TransformUtilities.homographyMatrixNorm((List)data), data);
            homographies.add(h);
        }
        this.estimateIntrisicAndExtrinsics(homographies, width, height);
        this.refine();
    }

    @Override
    protected RealVector buildObservedVector() {
        int totalPoints = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            totalPoints += ((List)this.points.get(i)).size();
        }
        double[] vec = new double[totalPoints * 2];
        int k = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            int j = 0;
            while (j < ((List)this.points.get(i)).size()) {
                vec[k * 2 + 0] = ((Point2d)((IndependentPair)((List)this.points.get(i)).get(j)).secondObject()).getX();
                vec[k * 2 + 1] = ((Point2d)((IndependentPair)((List)this.points.get(i)).get(j)).secondObject()).getY();
                ++j;
                ++k;
            }
        }
        return new ArrayRealVector(vec, false);
    }

    private void refine() {
        LevenbergMarquardtOptimizer lm = new LevenbergMarquardtOptimizer();
        RealVector start = this.buildInitialVector();
        RealVector observed = this.buildObservedVector();
        int maxEvaluations = 1000;
        int maxIterations = 1000;
        Value value = new Value();
        Jacobian jacobian = new Jacobian();
        MultivariateJacobianFunction model = LeastSquaresFactory.model((MultivariateVectorFunction)value, (MultivariateMatrixFunction)jacobian);
        LeastSquaresOptimizer.Optimum result = lm.optimize(LeastSquaresFactory.create((MultivariateJacobianFunction)model, (RealVector)observed, (RealVector)start, null, (int)1000, (int)1000));
        this.updateEstimates(result.getPoint());
    }

    private void updateEstimates(RealVector point) {
        CameraIntrinsics intrinsic = ((Camera)this.cameras.get((int)0)).intrinsicParameters;
        intrinsic.setFocalLengthX(point.getEntry(0));
        intrinsic.setFocalLengthY(point.getEntry(1));
        intrinsic.setPrincipalPointX(point.getEntry(2));
        intrinsic.setPrincipalPointY(point.getEntry(3));
        intrinsic.setSkewFactor(point.getEntry(4));
        intrinsic.k1 = point.getEntry(5);
        intrinsic.k2 = point.getEntry(6);
        intrinsic.k3 = point.getEntry(7);
        intrinsic.p1 = point.getEntry(8);
        intrinsic.p2 = point.getEntry(9);
        for (int i = 0; i < this.cameras.size(); ++i) {
            Camera e = (Camera)this.cameras.get(i);
            double[] rv = new double[]{point.getEntry(i * 6 + 10), point.getEntry(i * 6 + 11), point.getEntry(i * 6 + 12)};
            e.rotation = TransformUtilities.rodrigues((double[])rv);
            e.translation.setX(point.getEntry(i * 6 + 13));
            e.translation.setY(point.getEntry(i * 6 + 14));
            e.translation.setZ(point.getEntry(i * 6 + 15));
        }
    }

    private RealVector buildInitialVector() {
        CameraIntrinsics intrinsic = ((Camera)this.cameras.get((int)0)).intrinsicParameters;
        double[] vector = new double[10 + this.cameras.size() * 6];
        vector[0] = intrinsic.getFocalLengthX();
        vector[1] = intrinsic.getFocalLengthY();
        vector[2] = intrinsic.getPrincipalPointX();
        vector[3] = intrinsic.getPrincipalPointY();
        vector[4] = intrinsic.getSkewFactor();
        vector[5] = intrinsic.k1;
        vector[6] = intrinsic.k2;
        vector[7] = intrinsic.k3;
        vector[8] = intrinsic.p1;
        vector[9] = intrinsic.p2;
        for (int i = 0; i < this.cameras.size(); ++i) {
            Camera e = (Camera)this.cameras.get(i);
            double[] rv = TransformUtilities.rodrigues((Matrix)e.rotation);
            vector[i * 6 + 10] = rv[0];
            vector[i * 6 + 11] = rv[1];
            vector[i * 6 + 12] = rv[2];
            vector[i * 6 + 13] = e.translation.getX();
            vector[i * 6 + 14] = e.translation.getY();
            vector[i * 6 + 15] = e.translation.getZ();
        }
        return new ArrayRealVector(vector, false);
    }

    private class Jacobian
    implements MultivariateMatrixFunction {
        private Jacobian() {
        }

        public double[][] value(double[] params) {
            int totalPoints = 0;
            for (int i = 0; i < CameraCalibration.this.points.size(); ++i) {
                totalPoints += ((List)CameraCalibration.this.points.get(i)).size();
            }
            double[][] result = new double[2 * totalPoints][];
            int k = 0;
            for (int i = 0; i < CameraCalibration.this.points.size(); ++i) {
                int j = 0;
                while (j < ((List)CameraCalibration.this.points.get(i)).size()) {
                    double[][] tmp = this.computeJacobian(i, j, params);
                    result[k * 2 + 0] = tmp[0];
                    result[k * 2 + 1] = tmp[1];
                    ++j;
                    ++k;
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private double[][] computeJacobian(int img, int point, double[] params) {
            void result;
            void t300;
            void t296;
            void t292;
            void t288;
            void t284;
            void t280;
            void t279;
            void t278;
            void t277;
            void t276;
            void t272;
            void t271;
            void t270;
            void t266;
            void t299;
            void t298;
            void t297;
            void t259;
            void t295;
            void t294;
            void t293;
            void t253;
            void t291;
            void t290;
            void t289;
            void t249;
            void t287;
            void t286;
            void t285;
            void t243;
            void t283;
            void t282;
            void t281;
            void t199;
            void t141;
            void t275;
            void t274;
            void t273;
            void t269;
            void t268;
            void t267;
            void t265;
            void t264;
            void t263;
            void t261;
            void t258;
            void t256;
            void t257;
            void t262;
            void t254;
            void t260;
            void t255;
            void t252;
            void t251;
            void t250;
            void t242;
            void t233;
            void t241;
            void t248;
            void t240;
            void t239;
            void t237;
            void t223;
            void t236;
            void t247;
            void t235;
            void t217;
            void t234;
            void t216;
            void t215;
            void t232;
            void t246;
            void t231;
            void t213;
            void t230;
            void t245;
            void t227;
            void t229;
            void t244;
            void t228;
            void t226;
            void t225;
            void t224;
            void t218;
            void t222;
            void t238;
            void t221;
            void t219;
            void t210;
            void t220;
            void t207;
            void t200;
            void t212;
            void t211;
            void t206;
            void t203;
            void t214;
            void t209;
            void t208;
            void t205;
            void t204;
            void t202;
            void t201;
            void t195;
            void t194;
            void t182;
            void t193;
            void t198;
            void t192;
            void t191;
            void t197;
            void t188;
            void t190;
            void t196;
            void t189;
            void t187;
            void t186;
            void t185;
            void t184;
            void t181;
            void t173;
            void t180;
            void t179;
            void t168;
            void t178;
            void t183;
            void t177;
            void t158;
            void t153;
            void t176;
            void t172;
            void t171;
            void t167;
            void t175;
            void t166;
            void t163;
            void t161;
            void t165;
            void t169;
            void t164;
            void t162;
            void t170;
            void t154;
            void t150;
            void t149;
            void t148;
            void t174;
            void t160;
            void t159;
            void t157;
            void t156;
            void t155;
            void t152;
            void t151;
            void t144;
            void t140;
            void t124;
            void t139;
            void t147;
            void t138;
            void t137;
            void t136;
            void t131;
            void t135;
            void t146;
            void t134;
            void t133;
            void t132;
            void t130;
            void t145;
            void t129;
            void t128;
            void t127;
            void t126;
            void t125;
            void t123;
            void t122;
            void t113;
            void t112;
            void t121;
            void t143;
            void t117;
            void t120;
            void t119;
            void t118;
            void t116;
            void t142;
            void t115;
            void t106;
            void t111;
            void t110;
            double[][] A0 = new double[2][16];
            double X = ((Point2d)((IndependentPair)((List)CameraCalibration.this.points.get(img)).get(point)).firstObject()).getX();
            double Y = ((Point2d)((IndependentPair)((List)CameraCalibration.this.points.get(img)).get(point)).firstObject()).getY();
            double fx = params[0];
            double fy = params[1];
            double u0 = params[2];
            double v0 = params[3];
            double sk = params[4];
            double k1 = params[5];
            double k2 = params[6];
            double k3 = params[7];
            double p1 = params[8];
            double p2 = params[9];
            double wx = params[img * 6 + 10];
            double wy = params[img * 6 + 11];
            double wz = params[img * 6 + 12];
            double tx = params[img * 6 + 13];
            double ty = params[img * 6 + 14];
            double tz = params[img * 6 + 15];
            double t2 = wx * wx;
            double t3 = wy * wy;
            double t4 = wz * wz;
            double t5 = t2 + t3 + t4;
            double t6 = Math.sqrt(t5);
            double t7 = Math.sin(t6);
            double t8 = 1.0 / Math.sqrt(t5);
            double t9 = Math.cos(t6);
            double t10 = t9 - 1.0;
            double t11 = 1.0 / t5;
            double t12 = t7 * t8 * wy;
            double t13 = t10 * t11 * wx * wz;
            double t14 = t12 + t13;
            double t15 = t7 * t8 * wz;
            double t16 = t7 * t8 * wx;
            double t18 = t10 * t11 * wy * wz;
            double t17 = t16 - t18;
            double t19 = Y * t17;
            double t39 = X * t14;
            double t20 = t19 - t39 + tz;
            double t21 = 1.0 / t20;
            double t22 = t10 * t11 * wx * wy;
            double t23 = t3 + t4;
            double t24 = t10 * t11 * t23;
            double t25 = t24 + 1.0;
            double t26 = fx * t25;
            double t27 = t15 + t22;
            double t28 = t17 * u0;
            double t29 = t2 + t4;
            double t30 = t10 * t11 * t29;
            double t31 = t30 + 1.0;
            double t32 = sk * t31;
            double t45 = fx * t27;
            double t33 = t28 + t32 - t45;
            double t34 = Y * t33;
            double t35 = fx * tx;
            double t36 = sk * ty;
            double t37 = tz * u0;
            double t40 = t15 - t22;
            double t41 = sk * t40;
            double t42 = t14 * u0;
            double t43 = t26 + t41 - t42;
            double t44 = X * t43;
            double t46 = t34 + t35 + t36 + t37 + t44;
            double t47 = t21 * t46;
            double t38 = -t47 + u0;
            double t48 = 1.0 / (fx * fx * fx);
            double t49 = t38 * t38;
            double t50 = t48 * t49 * 2.0;
            double t51 = 1.0 / (fx * fx);
            double t52 = X * t25;
            double t57 = Y * t27;
            double t53 = t52 - t57 + tx;
            double t54 = t21 * t38 * t51 * t53 * 2.0;
            double t55 = t50 + t54;
            double t60 = fy * ty;
            double t61 = fy * t40;
            double t62 = t14 * v0;
            double t63 = t61 - t62;
            double t64 = X * t63;
            double t65 = tz * v0;
            double t66 = t17 * v0;
            double t67 = fy * t31;
            double t68 = t66 + t67;
            double t69 = Y * t68;
            double t70 = t60 + t64 + t65 + t69;
            double t71 = t21 * t70;
            double t56 = -t71 + v0;
            double t58 = t49 * t51;
            double t59 = 1.0 / (fy * fy);
            double t72 = t56 * t56;
            double t73 = t59 * t72;
            double t74 = t58 + t73;
            double t75 = t74 * t74;
            double t76 = 1.0 / (fy * fy * fy);
            double t77 = t72 * t76 * 2.0;
            double t78 = X * t40;
            double t79 = Y * t31;
            double t80 = t78 + t79 + ty;
            double t81 = t21 * t56 * t59 * t80 * 2.0;
            double t82 = t77 + t81;
            double t83 = k1 * t74;
            double t84 = k2 * t75;
            double t85 = k3 * t74 * t75;
            double t86 = t83 + t84 + t85;
            double t87 = 1.0 / Math.pow(t5, 1.5);
            double t88 = 1.0 / (t5 * t5);
            double t89 = t7 * t87 * wx * wy;
            double t90 = t2 * t7 * t87 * wz;
            double t91 = t2 * t10 * t88 * wz * 2.0;
            double t102 = t10 * t11 * wz;
            double t103 = t9 * t11 * wx * wy;
            double t92 = t89 + t90 + t91 - t102 - t103;
            double t93 = t7 * t8;
            double t94 = t2 * t9 * t11;
            double t95 = t10 * t88 * wx * wy * wz * 2.0;
            double t96 = t7 * t87 * wx * wy * wz;
            double t109 = t2 * t7 * t87;
            double t97 = t93 + t94 + t95 + t96 - t109;
            double t98 = t9 * t11 * wx * wz;
            double t99 = t2 * t7 * t87 * wy;
            double t100 = t2 * t10 * t88 * wy * 2.0;
            double t107 = t10 * t11 * wy;
            double t108 = t7 * t87 * wx * wz;
            double t101 = t98 + t99 + t100 - t107 - t108;
            double t104 = t10 * t29 * t88 * wx * 2.0;
            double t105 = t7 * t29 * t87 * wx;
            double t114 = t10 * t11 * wx * 2.0;
            double d = t104 + t105 - t114;
            double d2 = X * t92;
            double d3 = Y * t97;
            void var263_134 = t110 + t111;
            double d4 = 1.0 / (t20 * t20);
            double d5 = fy * t106;
            double d6 = t97 * v0;
            void var271_138 = t115 - t142;
            double d7 = Y * t116;
            double d8 = fy * t101;
            double d9 = t92 * v0;
            void var279_142 = t118 + t119;
            double d10 = X * t120;
            void var283_144 = t117 - t143;
            double d11 = t21 * t121;
            double d12 = t70 * t112 * t113;
            void var289_147 = t122 + t123;
            double d13 = t10 * t23 * t88 * wx * 2.0;
            double d14 = t7 * t23 * t87 * wx;
            void var295_150 = t125 + t126;
            double d15 = sk * t101;
            double d16 = t92 * u0;
            double d17 = fx * t127;
            void var303_154 = t128 + t129 - t145;
            double d18 = X * t130;
            double d19 = -t98 + t99 + t100 - t107 + t108;
            double d20 = fx * t132;
            double d21 = t97 * u0;
            double d22 = sk * t106;
            void var315_160 = t133 + t134 - t146;
            double d23 = Y * t135;
            void var319_162 = t131 + t136;
            double d24 = t21 * t137;
            double d25 = t46 * t112 * t113;
            void var325_165 = t138 - t147;
            double d26 = t38 * t51 * t139 * 2.0;
            double d27 = t56 * t59 * t124 * 2.0;
            void var331_168 = t140 - t144;
            double d28 = t7 * t87 * wy * wz;
            double d29 = t3 * t7 * t87 * wx;
            double d30 = t3 * t10 * t88 * wx * 2.0;
            double d31 = t10 * t29 * t88 * wy * 2.0;
            double d32 = t7 * t29 * t87 * wy;
            void var343_174 = t151 + t152;
            double d33 = t9 * t11 * wy * wz;
            double d34 = t3 * t7 * t87 * wz;
            double d35 = t3 * t10 * t88 * wz * 2.0;
            double d36 = -t89 - t102 + t103 + t155 + t156;
            void var353_179 = t157 * u0;
            double d37 = t10 * t23 * t88 * wy * 2.0;
            double d38 = t7 * t23 * t87 * wy;
            double d39 = t10 * t11 * wy * 2.0;
            void var361_183 = t159 + t160 - t174;
            double d40 = t10 * t11 * wx;
            void var365_185 = -t148 + t149 + t150 + t154 - t170;
            double d41 = sk * t162;
            double d42 = t3 * t7 * t87;
            double d43 = t3 * t9 * t11;
            double d44 = -t93 + t95 + t96 + t164 - t169;
            void var375_190 = t165 * u0;
            double d45 = fx * t161;
            void var379_192 = t163 + t166 - t175;
            double d46 = X * t167;
            double d47 = Y * t157;
            double d48 = X * t165;
            void var387_196 = t171 + t172;
            void var389_197 = t148 + t149 + t150 - t154 - t170;
            double d49 = fx * t176;
            double d50 = sk * t153;
            void var395_200 = t158 + t177 - t183;
            double d51 = Y * t178;
            void var399_202 = t168 + t179;
            double d52 = t21 * t180;
            double d53 = t46 * t113 * t173;
            void var405_205 = t181 - t184;
            double d54 = fy * t162;
            void var409_207 = t165 * v0;
            void var411_208 = t185 + t186;
            double d55 = X * t187;
            double d56 = fy * t153;
            void var417_211 = t157 * v0;
            void var419_212 = t189 - t196;
            double d57 = Y * t190;
            void var423_214 = t188 - t197;
            double d58 = t21 * t191;
            double d59 = t70 * t113 * t173;
            void var429_217 = t192 - t198;
            double d60 = t56 * t59 * t193 * 2.0;
            double d61 = t38 * t51 * t182 * 2.0;
            void var435_220 = t194 + t195;
            double d62 = t4 * t9 * t11;
            double d63 = t4 * t7 * t87 * wx;
            double d64 = t4 * t10 * t88 * wx * 2.0;
            void var443_224 = t148 - t154 - t170 + t201 + t202;
            double d65 = t4 * t7 * t87 * wy;
            double d66 = t4 * t10 * t88 * wy * 2.0;
            double d67 = t98 - t107 - t108 + t204 + t205;
            double d68 = t4 * t7 * t87;
            double d69 = t10 * t29 * t88 * wz * 2.0;
            double d70 = t7 * t29 * t87 * wz;
            double d71 = t10 * t11 * wz * 2.0;
            void var459_232 = t208 + t209 - t214;
            double d72 = X * t203;
            double d73 = Y * t206;
            void var465_235 = t211 + t212;
            double d74 = t10 * t23 * t88 * wz * 2.0;
            double d75 = t7 * t23 * t87 * wz;
            void var471_238 = t203 * u0;
            double d76 = t93 + t95 + t96 + t200 - t207;
            void var475_240 = t206 * u0;
            double d77 = -t93 + t95 + t96 - t200 + t207;
            double d78 = fx * t220;
            double d79 = sk * t210;
            void var483_244 = t219 + t221 - t238;
            double d80 = Y * t222;
            void var487_246 = t203 * v0;
            double d81 = fy * t218;
            void var491_248 = t224 + t225;
            double d82 = X * t226;
            double d83 = fy * t210;
            void var497_251 = t206 * v0;
            void var499_252 = t228 - t244;
            double d84 = Y * t229;
            void var503_254 = t227 - t245;
            double d85 = t21 * t230;
            double d86 = t70 * t113 * t213;
            void var509_257 = t231 - t246;
            double d87 = t56 * t59 * t232 * 2.0;
            void var513_259 = -t214 + t215 + t216;
            double d88 = sk * t218;
            double d89 = fx * t234;
            void var519_262 = t217 + t235 - t247;
            double d90 = X * t236;
            void var523_264 = t223 + t237;
            double d91 = t21 * t239;
            double d92 = t46 * t113 * t213;
            void var529_267 = t240 - t248;
            double d93 = t38 * t51 * t241 * 2.0;
            void var533_269 = t233 + t242;
            double d94 = 1.0 / fx;
            double d95 = 1.0 / fy;
            double d96 = t21 * t56 * t250 * 2.0;
            double d97 = sk * t21 * t38 * t51 * 2.0;
            void var543_274 = t251 + t252;
            double d98 = t21 * u0;
            double d99 = t70 * t113;
            double d100 = t21 * v0;
            void var551_278 = t255 - t260;
            double d101 = t46 * t113;
            void var555_280 = t254 - t262;
            double d102 = t38 * t51 * t257 * 2.0;
            double d103 = t56 * t59 * t256 * 2.0;
            void var561_283 = t258 - t261;
            double d104 = k1 * t55;
            double d105 = k2 * t55 * t74 * 2.0;
            double d106 = k3 * t55 * t75 * 3.0;
            void var569_287 = t263 + t264 + t265;
            double d107 = k1 * t82;
            double d108 = k3 * t75 * t82 * 3.0;
            double d109 = k2 * t74 * t82 * 2.0;
            void var577_291 = t267 + t268 + t269;
            double d110 = t21 * t80;
            double d111 = t21 * t80 * t86;
            double d112 = k1 * t21 * t38 * t51 * t80 * 2.0;
            double d113 = k2 * t21 * t38 * t51 * t74 * t80 * 4.0;
            double d114 = k3 * t21 * t38 * t51 * t75 * t80 * 6.0;
            void var589_297 = t273 + t274 + t275;
            double d115 = t38 * t56 * 2.0;
            double d116 = k1 * t141;
            double d117 = k2 * t74 * t141 * 2.0;
            double d118 = k3 * t75 * t141 * 3.0;
            double d119 = k1 * t199;
            double d120 = k2 * t74 * t199 * 2.0;
            double d121 = k3 * t75 * t199 * 3.0;
            void var605_305 = t281 + t282 + t283;
            double d122 = k1 * t243;
            double d123 = k2 * t74 * t243 * 2.0;
            double d124 = k3 * t75 * t243 * 3.0;
            void var613_309 = t285 + t286 + t287;
            double d125 = k1 * t21 * t38 * t249 * 2.0;
            double d126 = k2 * t21 * t38 * t74 * t249 * 4.0;
            double d127 = k3 * t21 * t38 * t75 * t249 * 6.0;
            void var621_313 = t289 + t290 + t291;
            double d128 = k1 * t253;
            double d129 = k3 * t75 * t253 * 3.0;
            double d130 = k2 * t74 * t253 * 2.0;
            void var629_317 = t293 + t294 + t295;
            double d131 = k1 * t259;
            double d132 = k2 * t74 * t259 * 2.0;
            double d133 = k3 * t75 * t259 * 3.0;
            void var637_321 = t297 + t298 + t299;
            A0[0][0] = t21 * t53 + t266 * (u0 - t21 * (t34 + t35 + t36 + t37 + X * (t26 - t14 * u0 + sk * (t15 - t10 * t11 * wx * wy)))) - p2 * (t50 + t54 + t21 * t38 * t53 * 4.0) + t21 * t53 * t86 - p1 * t21 * t53 * t56 * 2.0;
            A0[0][1] = -p2 * t82 + t38 * t270 - p1 * t21 * t38 * t80 * 2.0;
            A0[0][2] = 1.0;
            A0[0][4] = t271 + t272 - p2 * (t21 * t38 * t80 * 4.0 + t21 * t38 * t51 * t80 * 2.0) + t38 * t276 - p1 * t21 * t56 * t80 * 2.0;
            A0[0][5] = -t38 * t74;
            A0[0][6] = -t38 * t75;
            A0[0][7] = -t38 * t74 * t75;
            A0[0][8] = t277;
            A0[0][9] = t49 * 2.0 + t58 + t73;
            A0[0][10] = t138 - t147 + t86 * t139 + t38 * (t278 + t279 + t280) - p2 * (t140 - t144 + t38 * t139 * 4.0) + p1 * t38 * t124 * 2.0 - p1 * t56 * t139 * 2.0;
            A0[0][11] = -t184 + t86 * t182 + t38 * t284 - p2 * (t194 + t195 + t38 * t182 * 4.0) + t21 * (t168 + Y * (t158 - sk * t153 + fx * (t148 + t149 + t150 - t10 * t11 * wx - t9 * t11 * wy * wz))) - p1 * t38 * t193 * 2.0 - p1 * t56 * t182 * 2.0;
            A0[0][12] = t240 - t248 + t38 * t288 - p2 * (t233 + t242 + t38 * t241 * 4.0) + t86 * (t21 * (t223 + X * (t217 + sk * (t93 + t95 + t96 + t200 - t4 * t7 * t87) - fx * (t215 + t216 - t10 * t11 * wz * 2.0))) - t46 * t113 * t213) - p1 * t38 * t232 * 2.0 - p1 * t56 * t241 * 2.0;
            A0[0][13] = fx * t21 + t38 * t292 - p2 * (fx * t21 * t38 * 4.0 + t21 * t38 * t249 * 2.0) + fx * t21 * t86 - fx * p1 * t21 * t56 * 2.0;
            A0[0][14] = sk * t21 + t38 * t296 - p2 * (t251 + t252 + sk * t21 * t38 * 4.0) + sk * t21 * t86 - fy * p1 * t21 * t38 * 2.0 - p1 * sk * t21 * t56 * 2.0;
            A0[0][15] = t254 - t46 * t113 + t38 * t300 + t86 * t257 - p2 * (t258 - t261 + t38 * t257 * 4.0) - p1 * t56 * t257 * 2.0 + p1 * t38 * (t255 - t260) * 2.0;
            A0[1][0] = -p1 * t55 + t56 * t266 - p2 * t21 * t53 * t56 * 2.0;
            A0[1][1] = t271 + t272 + t56 * t270 - p1 * (t77 + t81 + t21 * t56 * t80 * 4.0) - p2 * t21 * t38 * t80 * 2.0;
            A0[1][3] = 1.0;
            A0[1][4] = t56 * t276 - p2 * t21 * t56 * t80 * 2.0 - p1 * t21 * t38 * t51 * t80 * 2.0;
            A0[1][5] = -t56 * t74;
            A0[1][6] = -t56 * t75;
            A0[1][7] = -t56 * t74 * t75;
            A0[1][8] = t58 + t72 * 2.0 + t73;
            A0[1][9] = t277;
            A0[1][10] = -t122 - t123 - t86 * t124 + t56 * (t278 + t279 + t280) + p1 * (-t140 + t144 + t56 * t124 * 4.0) + p2 * t38 * t124 * 2.0 - p2 * t56 * t139 * 2.0;
            A0[1][11] = t192 - t198 + t86 * t193 + t56 * t284 - p1 * (t194 + t195 + t56 * t193 * 4.0) - p2 * t38 * t193 * 2.0 - p2 * t56 * t182 * 2.0;
            A0[1][12] = t231 - t246 + t86 * t232 + t56 * t288 - p1 * (t233 + t242 + t56 * t232 * 4.0) - p2 * t38 * t232 * 2.0 - p2 * t56 * t241 * 2.0;
            A0[1][13] = t56 * t292 - fx * p2 * t21 * t56 * 2.0 - p1 * t21 * t38 * t249 * 2.0;
            A0[1][14] = fy * t21 + t56 * t296 - p1 * (t251 + t252 + fy * t21 * t56 * 4.0) + fy * t21 * t86 - fy * p2 * t21 * t38 * 2.0 - p2 * sk * t21 * t56 * 2.0;
            A0[1][15] = -t255 + t260 - t86 * t256 + t56 * t300 + p1 * (-t258 + t261 + t56 * t256 * 4.0) - p2 * t56 * t257 * 2.0 + p2 * t38 * (t255 - t260) * 2.0;
            double[][] dArray = new double[2][10 + 6 * CameraCalibration.this.points.size()];
            System.arraycopy(A0[0], 0, result[0], 0, 10);
            System.arraycopy(A0[1], 0, result[1], 0, 10);
            System.arraycopy(A0[0], 10, result[0], 10 + img * 6, 6);
            System.arraycopy(A0[1], 10, result[1], 10 + img * 6, 6);
            return result;
        }
    }

    private class Value
    implements MultivariateVectorFunction {
        private Value() {
        }

        public double[] value(double[] params) throws IllegalArgumentException {
            int totalPoints = 0;
            for (int i = 0; i < CameraCalibration.this.points.size(); ++i) {
                totalPoints += ((List)CameraCalibration.this.points.get(i)).size();
            }
            double[] result = new double[2 * totalPoints];
            int k = 0;
            for (int i = 0; i < CameraCalibration.this.points.size(); ++i) {
                int j = 0;
                while (j < ((List)CameraCalibration.this.points.get(i)).size()) {
                    double[] tmp = this.computeValue(i, j, params);
                    result[k * 2 + 0] = tmp[0];
                    result[k * 2 + 1] = tmp[1];
                    ++j;
                    ++k;
                }
            }
            return result;
        }

        private double[] computeValue(int img, int point, double[] params) {
            double[][] A0 = new double[2][1];
            double X = ((Point2d)((IndependentPair)((List)CameraCalibration.this.points.get(img)).get(point)).firstObject()).getX();
            double Y = ((Point2d)((IndependentPair)((List)CameraCalibration.this.points.get(img)).get(point)).firstObject()).getY();
            double fx = params[0];
            double fy = params[1];
            double u0 = params[2];
            double v0 = params[3];
            double sk = params[4];
            double k1 = params[5];
            double k2 = params[6];
            double k3 = params[7];
            double p1 = params[8];
            double p2 = params[9];
            double wx = params[img * 6 + 10];
            double wy = params[img * 6 + 11];
            double wz = params[img * 6 + 12];
            double tx = params[img * 6 + 13];
            double ty = params[img * 6 + 14];
            double tz = params[img * 6 + 15];
            double t2 = wx * wx;
            double t3 = wy * wy;
            double t4 = wz * wz;
            double t5 = t2 + t3 + t4;
            double t6 = Math.sqrt(t5);
            double t7 = Math.sin(t6);
            double t8 = 1.0 / Math.sqrt(t5);
            double t9 = Math.cos(t6);
            double t10 = t9 - 1.0;
            double t11 = 1.0 / t5;
            double t12 = t7 * t8 * wy;
            double t13 = t10 * t11 * wx * wz;
            double t14 = t12 + t13;
            double t15 = t7 * t8 * wz;
            double t16 = t7 * t8 * wx;
            double t18 = t10 * t11 * wy * wz;
            double t17 = t16 - t18;
            double t19 = Y * t17;
            double t38 = X * t14;
            double t20 = t19 - t38 + tz;
            double t21 = 1.0 / t20;
            double t22 = t10 * t11 * wx * wy;
            double t23 = t3 + t4;
            double t24 = t10 * t11 * t23;
            double t25 = t24 + 1.0;
            double t26 = fx * t25;
            double t27 = t15 + t22;
            double t28 = t17 * u0;
            double t29 = t2 + t4;
            double t30 = t10 * t11 * t29;
            double t31 = t30 + 1.0;
            double t32 = sk * t31;
            double t43 = fx * t27;
            double t33 = t28 + t32 - t43;
            double t34 = Y * t33;
            double t35 = fx * tx;
            double t36 = sk * ty;
            double t37 = tz * u0;
            double t39 = t15 - t22;
            double t40 = sk * t39;
            double t48 = t14 * u0;
            double t41 = t26 + t40 - t48;
            double t42 = X * t41;
            double t44 = t34 + t35 + t36 + t37 + t42;
            double t49 = t21 * t44;
            double t45 = -t49 + u0;
            double t53 = fy * ty;
            double t54 = fy * t39;
            double t55 = t14 * v0;
            double t56 = t54 - t55;
            double t57 = X * t56;
            double t58 = tz * v0;
            double t59 = t17 * v0;
            double t60 = fy * t31;
            double t61 = t59 + t60;
            double t62 = Y * t61;
            double t63 = t53 + t57 + t58 + t62;
            double t64 = t21 * t63;
            double t46 = -t64 + v0;
            double t47 = 1.0 / (fx * fx);
            double t50 = t45 * t45;
            double t51 = t47 * t50;
            double t52 = 1.0 / (fy * fy);
            double t65 = t46 * t46;
            double t66 = t52 * t65;
            double t67 = t51 + t66;
            double t68 = t67 * t67;
            double t69 = k1 * t67;
            double t70 = k2 * t68;
            double t71 = k3 * t67 * t68;
            double t72 = t69 + t70 + t71;
            A0[0][0] = -t45 * t72 + t21 * (t34 + t35 + t36 + t37 + X * (t26 - t14 * u0 + sk * (t15 - t10 * t11 * wx * wy))) + p2 * (t50 * 2.0 + t51 + t66) + p1 * t45 * t46 * 2.0;
            A0[1][0] = t64 - t46 * t72 + p1 * (t51 + t65 * 2.0 + t66) + p2 * t45 * t46 * 2.0;
            return new double[]{A0[0][0], A0[1][0]};
        }
    }
}

