/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera.calibration;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.camera.Camera;
import org.openimaj.image.camera.CameraIntrinsics;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point3dImpl;
import org.openimaj.math.geometry.transforms.HomographyRefinement;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Zhengyou Zhang"}, title="A flexible new technique for camera calibration", year="2000", journal="Pattern Analysis and Machine Intelligence, IEEE Transactions on", pages={"1330", "1334"}, month="Nov", number="11", volume="22", customData={"keywords", "calibration;computer vision;geometry;image sensors;matrix algebra;maximum likelihood estimation;optimisation;3D computer vision;camera calibration;flexible technique;maximum likelihood criterion;planar pattern;radial lens distortion;Calibration;Cameras;Closed-form solution;Computer simulation;Computer vision;Layout;Lenses;Maximum likelihood estimation;Nonlinear distortion;Testing", "doi", "10.1109/34.888718", "ISSN", "0162-8828"})
public class CameraCalibrationZhang {
    protected List<List<? extends IndependentPair<? extends Point2d, ? extends Point2d>>> points;
    protected List<Camera> cameras;

    public CameraCalibrationZhang(List<List<? extends IndependentPair<? extends Point2d, ? extends Point2d>>> points, int width, int height) {
        this.points = points;
        this.performCalibration(width, height);
    }

    protected void performCalibration(int width, int height) {
        ArrayList<Matrix> homographies = new ArrayList<Matrix>();
        for (int i = 0; i < this.points.size(); ++i) {
            List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> data = this.points.get(i);
            Matrix h = HomographyRefinement.SINGLE_IMAGE_TRANSFER.refine(TransformUtilities.homographyMatrixNorm(data), data);
            homographies.add(h);
        }
        this.estimateIntrisicAndExtrinsics(homographies, width, height);
        this.estimateRadialDistortion();
        this.refine();
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }

    public CameraIntrinsics getIntrisics() {
        return this.cameras.get((int)0).intrinsicParameters;
    }

    private double[] vij(Matrix h, int i, int j) {
        h = h.transpose();
        double[] vij = new double[]{h.get(i, 0) * h.get(j, 0), h.get(i, 0) * h.get(j, 1) + h.get(i, 1) * h.get(j, 0), h.get(i, 1) * h.get(j, 1), h.get(i, 2) * h.get(j, 0) + h.get(i, 0) * h.get(j, 2), h.get(i, 2) * h.get(j, 1) + h.get(i, 1) * h.get(j, 2), h.get(i, 2) * h.get(j, 2)};
        return vij;
    }

    private CameraIntrinsics estimateIntrinsics(List<Matrix> homographies, int width, int height) {
        double[][] V = new double[homographies.size() == 2 ? 5 : 2 * homographies.size()][];
        int i = 0;
        int j = 0;
        while (i < homographies.size()) {
            Matrix h = homographies.get(i);
            V[j] = this.vij(h, 0, 1);
            V[j + 1] = ArrayUtils.subtract((double[])this.vij(h, 0, 0), (double[])this.vij(h, 1, 1));
            ++i;
            j += 2;
        }
        if (homographies.size() == 2) {
            V[V.length - 1] = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0};
        }
        double[] b = MatrixUtils.solveHomogeneousSystem((double[][])V);
        double v0 = (b[1] * b[3] - b[0] * b[4]) / (b[0] * b[2] - b[1] * b[1]);
        double lamda = b[5] - (b[3] * b[3] + v0 * (b[1] * b[3] - b[0] * b[4])) / b[0];
        double alpha = Math.sqrt(lamda / b[0]);
        double beta = Math.sqrt(lamda * b[0] / (b[0] * b[2] - b[1] * b[1]));
        double gamma = -b[1] * alpha * alpha * beta / lamda;
        double u0 = gamma * v0 / beta - b[3] * alpha * alpha / lamda;
        Matrix A = new Matrix((double[][])new double[][]{{alpha, gamma, u0}, {0.0, beta, v0}, {0.0, 0.0, 1.0}});
        return new CameraIntrinsics(A, width, height);
    }

    protected void estimateRadialDistortion() {
        CameraIntrinsics ci = this.cameras.get((int)0).intrinsicParameters;
        int totalPoints = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            totalPoints += this.points.get(i).size();
        }
        Matrix D = new Matrix(2 * totalPoints, 2);
        Matrix d = new Matrix(2 * totalPoints, 1);
        int k = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            List<? extends IndependentPair<? extends Point2d, ? extends Point2d>> pointPairs = this.points.get(i);
            Matrix idealH = this.cameras.get(i).computeHomography();
            int j = 0;
            while (j < pointPairs.size()) {
                Point2d XY = (Point2d)pointPairs.get(j).firstObject();
                Point2d uv = XY.transform(idealH);
                Point2d ipt = (Point2d)pointPairs.get(j).secondObject();
                d.set(k * 2 + 0, 0, (double)(ipt.getX() - uv.getX()));
                d.set(k * 2 + 1, 0, (double)(ipt.getY() - uv.getY()));
                double tmp1 = (double)uv.getX() - ci.getPrincipalPointX();
                double tmp2 = (double)uv.getY() - ci.getPrincipalPointY();
                double x = tmp1 / ci.getFocalLengthX();
                double y = tmp2 / ci.getFocalLengthY();
                double r2 = x * x + y * y;
                double r4 = r2 * r2;
                D.set(k * 2 + 0, 0, tmp1 * r2);
                D.set(k * 2 + 0, 1, tmp1 * r4);
                D.set(k * 2 + 1, 0, tmp2 * r2);
                D.set(k * 2 + 1, 1, tmp2 * r4);
                ++j;
                ++k;
            }
        }
        Matrix result = D.solve(d);
        ci.k1 = result.get(0, 0);
        ci.k2 = result.get(1, 0);
        ci.k3 = 0.0;
    }

    protected void estimateIntrisicAndExtrinsics(List<Matrix> homographies, int width, int height) {
        this.cameras = new ArrayList<Camera>(homographies.size());
        CameraIntrinsics intrinsic = this.estimateIntrinsics(homographies, width, height);
        for (int i = 0; i < homographies.size(); ++i) {
            this.cameras.add(this.estimateExtrinsics(homographies.get(i), intrinsic));
        }
    }

    private Camera estimateExtrinsics(Matrix h, CameraIntrinsics intrinsic) {
        Matrix Ainv = intrinsic.calibrationMatrix.inverse();
        Matrix h1 = h.getMatrix(0, 2, 0, 0);
        Matrix h2 = h.getMatrix(0, 2, 1, 1);
        Matrix h3 = h.getMatrix(0, 2, 2, 2);
        Matrix r1 = Ainv.times(h1);
        double lamda = 1.0 / r1.norm2();
        MatrixUtils.times((Matrix)r1, (double)lamda);
        Matrix r2 = Ainv.times(h2);
        MatrixUtils.times((Matrix)r2, (double)lamda);
        Matrix r3 = new Matrix((double[][])new double[][]{{r1.get(1, 0) * r2.get(2, 0) - r1.get(2, 0) * r2.get(1, 0)}, {r1.get(2, 0) * r2.get(0, 0) - r1.get(0, 0) * r2.get(2, 0)}, {r1.get(0, 0) * r2.get(1, 0) - r1.get(1, 0) * r2.get(0, 0)}});
        Matrix R = TransformUtilities.approximateRotationMatrix((Matrix)MatrixUtils.hstack((Matrix[])new Matrix[]{r1, r2, r3}));
        Matrix t = Ainv.times(h3);
        MatrixUtils.times((Matrix)t, (double)lamda);
        Camera ce = new Camera();
        ce.intrinsicParameters = intrinsic;
        ce.rotation = R;
        ce.translation = new Point3dImpl(t.getColumnPackedCopy());
        return ce;
    }

    protected RealVector buildObservedVector() {
        int totalPoints = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            totalPoints += this.points.get(i).size();
        }
        double[] vec = new double[totalPoints * 2];
        int k = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            int j = 0;
            while (j < this.points.get(i).size()) {
                vec[k * 2 + 0] = ((Point2d)this.points.get(i).get(j).secondObject()).getX();
                vec[k * 2 + 1] = ((Point2d)this.points.get(i).get(j).secondObject()).getY();
                ++j;
                ++k;
            }
        }
        return new ArrayRealVector(vec, false);
    }

    private void refine() {
        LevenbergMarquardtOptimizer lm = new LevenbergMarquardtOptimizer();
        RealVector start = this.buildInitialVector();
        RealVector observed = this.buildObservedVector();
        int maxEvaluations = 1000;
        int maxIterations = 1000;
        Value value = new Value();
        Jacobian jacobian = new Jacobian();
        MultivariateJacobianFunction model = LeastSquaresFactory.model((MultivariateVectorFunction)value, (MultivariateMatrixFunction)jacobian);
        LeastSquaresOptimizer.Optimum result = lm.optimize(LeastSquaresFactory.create((MultivariateJacobianFunction)model, (RealVector)observed, (RealVector)start, null, (int)1000, (int)1000));
        this.updateEstimates(result.getPoint());
    }

    private void updateEstimates(RealVector point) {
        CameraIntrinsics intrinsic = this.cameras.get((int)0).intrinsicParameters;
        intrinsic.setFocalLengthX(point.getEntry(0));
        intrinsic.setFocalLengthY(point.getEntry(1));
        intrinsic.setPrincipalPointX(point.getEntry(2));
        intrinsic.setPrincipalPointY(point.getEntry(3));
        intrinsic.setSkewFactor(point.getEntry(4));
        intrinsic.k1 = point.getEntry(5);
        intrinsic.k2 = point.getEntry(6);
        for (int i = 0; i < this.cameras.size(); ++i) {
            Camera e = this.cameras.get(i);
            double[] rv = new double[]{point.getEntry(i * 6 + 7), point.getEntry(i * 6 + 8), point.getEntry(i * 6 + 9)};
            e.rotation = TransformUtilities.rodrigues((double[])rv);
            e.translation.setX(point.getEntry(i * 6 + 10));
            e.translation.setY(point.getEntry(i * 6 + 11));
            e.translation.setZ(point.getEntry(i * 6 + 12));
        }
    }

    private RealVector buildInitialVector() {
        CameraIntrinsics intrinsic = this.cameras.get((int)0).intrinsicParameters;
        double[] vector = new double[7 + this.cameras.size() * 6];
        vector[0] = intrinsic.getFocalLengthX();
        vector[1] = intrinsic.getFocalLengthY();
        vector[2] = intrinsic.getPrincipalPointX();
        vector[3] = intrinsic.getPrincipalPointY();
        vector[4] = intrinsic.getSkewFactor();
        vector[5] = intrinsic.k1;
        vector[6] = intrinsic.k2;
        for (int i = 0; i < this.cameras.size(); ++i) {
            Camera e = this.cameras.get(i);
            double[] rv = TransformUtilities.rodrigues((Matrix)e.rotation);
            vector[i * 6 + 7] = rv[0];
            vector[i * 6 + 8] = rv[1];
            vector[i * 6 + 9] = rv[2];
            vector[i * 6 + 10] = e.translation.getX();
            vector[i * 6 + 11] = e.translation.getY();
            vector[i * 6 + 12] = e.translation.getZ();
        }
        return new ArrayRealVector(vector, false);
    }

    public double calculateError() {
        double error = 0.0;
        int nPoints = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            for (int j = 0; j < this.points.get(i).size(); ++j) {
                ++nPoints;
                Point2d model = (Point2d)this.points.get(i).get(j).firstObject();
                Point2d observed = (Point2d)this.points.get(i).get(j).secondObject();
                Point2d predicted = this.cameras.get(i).project(model);
                float dx = observed.getX() - predicted.getX();
                float dy = observed.getY() - predicted.getY();
                error += Math.sqrt(dx * dx + dy * dy);
            }
        }
        return error / (double)nPoints;
    }

    private class Jacobian
    implements MultivariateMatrixFunction {
        private Jacobian() {
        }

        public double[][] value(double[] params) {
            int totalPoints = 0;
            for (int i = 0; i < CameraCalibrationZhang.this.points.size(); ++i) {
                totalPoints += CameraCalibrationZhang.this.points.get(i).size();
            }
            double[][] result = new double[2 * totalPoints][];
            int k = 0;
            for (int i = 0; i < CameraCalibrationZhang.this.points.size(); ++i) {
                int j = 0;
                while (j < CameraCalibrationZhang.this.points.get(i).size()) {
                    double[][] tmp = this.computeJacobian(i, j, params);
                    result[k * 2 + 0] = tmp[0];
                    result[k * 2 + 1] = tmp[1];
                    ++j;
                    ++k;
                }
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private double[][] computeJacobian(int img, int point, double[] params) {
            void result;
            void t289;
            void t284;
            void t281;
            void t278;
            void t272;
            void t266;
            void t265;
            void t261;
            void t258;
            void t257;
            void t256;
            void t253;
            void t288;
            void t287;
            void t250;
            void t283;
            void t282;
            void t243;
            void t280;
            void t279;
            void t239;
            void t277;
            void t276;
            void t236;
            void t271;
            void t270;
            void t188;
            void t140;
            void t260;
            void t259;
            void t255;
            void t254;
            void t252;
            void t251;
            void t286;
            void t249;
            void t247;
            void t245;
            void t285;
            void t246;
            void t248;
            void t244;
            void t242;
            void t241;
            void t240;
            void t235;
            void t226;
            void t234;
            void t238;
            void t233;
            void t232;
            void t230;
            void t213;
            void t229;
            void t237;
            void t228;
            void t207;
            void t227;
            void t206;
            void t205;
            void t225;
            void t275;
            void t224;
            void t216;
            void t223;
            void t274;
            void t220;
            void t222;
            void t273;
            void t221;
            void t219;
            void t218;
            void t217;
            void t208;
            void t215;
            void t214;
            void t212;
            void t231;
            void t211;
            void t209;
            void t200;
            void t210;
            void t203;
            void t197;
            void t193;
            void t196;
            void t202;
            void t201;
            void t204;
            void t199;
            void t198;
            void t195;
            void t194;
            void t187;
            void t171;
            void t186;
            void t192;
            void t185;
            void t184;
            void t183;
            void t176;
            void t182;
            void t191;
            void t181;
            void t180;
            void t179;
            void t190;
            void t178;
            void t177;
            void t175;
            void t189;
            void t174;
            void t173;
            void t172;
            void t170;
            void t269;
            void t169;
            void t159;
            void t168;
            void t268;
            void t165;
            void t167;
            void t267;
            void t166;
            void t151;
            void t164;
            void t163;
            void t162;
            void t160;
            void t161;
            void t155;
            void t154;
            void t153;
            void t152;
            void t158;
            void t157;
            void t148;
            void t146;
            void t150;
            void t149;
            void t156;
            void t147;
            void t145;
            void t144;
            void t264;
            void t139;
            void t128;
            void t138;
            void t143;
            void t137;
            void t136;
            void t135;
            void t131;
            void t134;
            void t142;
            void t133;
            void t118;
            void t132;
            void t130;
            void t141;
            void t129;
            void t115;
            void t113;
            void t127;
            void t126;
            void t125;
            void t263;
            void t121;
            void t124;
            void t123;
            void t122;
            void t114;
            void t120;
            void t262;
            void t119;
            void t117;
            void t112;
            double[][] A0 = new double[2][13];
            double X = ((Point2d)CameraCalibrationZhang.this.points.get(img).get(point).firstObject()).getX();
            double Y = ((Point2d)CameraCalibrationZhang.this.points.get(img).get(point).firstObject()).getY();
            double fx = params[0];
            double fy = params[1];
            double u0 = params[2];
            double v0 = params[3];
            double sk = params[4];
            double k1 = params[5];
            double k2 = params[6];
            double wx = params[img * 6 + 7];
            double wy = params[img * 6 + 8];
            double wz = params[img * 6 + 9];
            double tx = params[img * 6 + 10];
            double ty = params[img * 6 + 11];
            double tz = params[img * 6 + 12];
            double t2 = wx * wx;
            double t3 = wy * wy;
            double t4 = wz * wz;
            double t5 = t2 + t3 + t4;
            double t6 = Math.sqrt(t5);
            double t7 = Math.sin(t6);
            double t8 = 1.0 / Math.sqrt(t5);
            double t9 = Math.cos(t6);
            double t10 = t9 - 1.0;
            double t11 = 1.0 / t5;
            double t12 = t7 * t8 * wy;
            double t13 = t10 * t11 * wx * wz;
            double t14 = t12 + t13;
            double t15 = t7 * t8 * wz;
            double t16 = t7 * t8 * wx;
            double t18 = t10 * t11 * wy * wz;
            double t17 = t16 - t18;
            double t19 = Y * t17;
            double t39 = X * t14;
            double t20 = t19 - t39 + tz;
            double t21 = 1.0 / t20;
            double t22 = t10 * t11 * wx * wy;
            double t23 = t3 + t4;
            double t24 = t10 * t11 * t23;
            double t25 = t24 + 1.0;
            double t26 = fx * t25;
            double t27 = t15 + t22;
            double t28 = t17 * u0;
            double t29 = t2 + t4;
            double t30 = t10 * t11 * t29;
            double t31 = t30 + 1.0;
            double t32 = sk * t31;
            double t45 = fx * t27;
            double t33 = t28 + t32 - t45;
            double t34 = Y * t33;
            double t35 = fx * tx;
            double t36 = sk * ty;
            double t37 = tz * u0;
            double t40 = t15 - t22;
            double t41 = sk * t40;
            double t42 = t14 * u0;
            double t43 = t26 + t41 - t42;
            double t44 = X * t43;
            double t46 = t34 + t35 + t36 + t37 + t44;
            double t47 = t21 * t46;
            double t38 = -t47 + u0;
            double t48 = 1.0 / (fx * fx * fx);
            double t49 = t38 * t38;
            double t50 = t48 * t49 * 2.0;
            double t51 = 1.0 / (fx * fx);
            double t52 = X * t25;
            double t57 = Y * t27;
            double t53 = t52 - t57 + tx;
            double t54 = t21 * t38 * t51 * t53 * 2.0;
            double t55 = t50 + t54;
            double t60 = fy * ty;
            double t61 = fy * t40;
            double t62 = t14 * v0;
            double t63 = t61 - t62;
            double t64 = X * t63;
            double t65 = tz * v0;
            double t66 = t17 * v0;
            double t67 = fy * t31;
            double t68 = t66 + t67;
            double t69 = Y * t68;
            double t70 = t60 + t64 + t65 + t69;
            double t71 = t21 * t70;
            double t56 = -t71 + v0;
            double t58 = t49 * t51;
            double t59 = 1.0 / (fy * fy);
            double t72 = t56 * t56;
            double t73 = t59 * t72;
            double t74 = t58 + t73;
            double t75 = 1.0 / (fy * fy * fy);
            double t76 = t72 * t75 * 2.0;
            double t77 = X * t40;
            double t78 = Y * t31;
            double t79 = t77 + t78 + ty;
            double t80 = t21 * t56 * t59 * t79 * 2.0;
            double t81 = t76 + t80;
            double t82 = k1 * t74;
            double t83 = t74 * t74;
            double t84 = k2 * t83;
            double t85 = t82 + t84;
            double t86 = 1.0 / Math.pow(t5, 1.5);
            double t87 = 1.0 / (t5 * t5);
            double t88 = t9 * t11 * wx * wz;
            double t89 = t2 * t7 * t86 * wy;
            double t90 = t2 * t10 * t87 * wy * 2.0;
            double t91 = t7 * t86 * wx * wy;
            double t92 = t2 * t7 * t86 * wz;
            double t93 = t2 * t10 * t87 * wz * 2.0;
            double t105 = t10 * t11 * wz;
            double t106 = t9 * t11 * wx * wy;
            double t94 = t91 + t92 + t93 - t105 - t106;
            double t95 = t7 * t8;
            double t96 = t2 * t9 * t11;
            double t97 = t10 * t87 * wx * wy * wz * 2.0;
            double t98 = t7 * t86 * wx * wy * wz;
            double t103 = t2 * t7 * t86;
            double t99 = t95 + t96 + t97 + t98 - t103;
            double t100 = t10 * t29 * t87 * wx * 2.0;
            double t101 = t7 * t29 * t86 * wx;
            double t116 = t10 * t11 * wx * 2.0;
            double t102 = t100 + t101 - t116;
            double t104 = t7 * t86 * wx * wz;
            double t107 = X * t94;
            double t108 = Y * t99;
            double t109 = t107 + t108;
            double t110 = 1.0 / (t20 * t20);
            double t111 = t10 * t23 * t87 * wx * 2.0;
            double d = t7 * t23 * t86 * wx;
            double d2 = t111 + t112;
            double d3 = t10 * t11 * wy;
            double d4 = t88 + t89 + t90 - t104 - t117;
            double d5 = t94 * u0;
            double d6 = t99 * u0;
            double d7 = fy * t102;
            double d8 = t99 * v0;
            void var273_139 = t119 - t262;
            double d9 = Y * t120;
            double d10 = fy * t114;
            double d11 = t94 * v0;
            void var281_143 = t122 + t123;
            double d12 = X * t124;
            void var285_145 = t121 - t263;
            double d13 = t21 * t125;
            double d14 = t70 * t109 * t110;
            void var291_148 = t126 + t127;
            double d15 = sk * t114;
            double d16 = fx * t113;
            void var297_151 = t115 + t129 - t141;
            double d17 = X * t130;
            double d18 = -t88 + t89 + t90 + t104 - t117;
            double d19 = fx * t132;
            double d20 = sk * t102;
            void var307_156 = t118 + t133 - t142;
            double d21 = Y * t134;
            void var311_158 = t131 + t135;
            double d22 = t21 * t136;
            double d23 = t46 * t109 * t110;
            void var317_161 = t137 - t143;
            double d24 = t38 * t51 * t138 * 2.0;
            double d25 = t56 * t59 * t128 * 2.0;
            void var323_164 = t139 - t264;
            double d26 = t3 * t7 * t86 * wz;
            double d27 = t3 * t10 * t87 * wz * 2.0;
            double d28 = -t91 - t105 + t106 + t144 + t145;
            double d29 = t3 * t7 * t86;
            double d30 = t3 * t9 * t11;
            double d31 = -t95 + t97 + t98 + t147 - t156;
            double d32 = t10 * t29 * t87 * wy * 2.0;
            double d33 = t7 * t29 * t86 * wy;
            void var341_173 = t149 + t150;
            double d34 = t9 * t11 * wy * wz;
            double d35 = t3 * t7 * t86 * wx;
            double d36 = t3 * t10 * t87 * wx * 2.0;
            double d37 = t7 * t86 * wy * wz;
            double d38 = Y * t146;
            double d39 = X * t148;
            void var355_180 = t157 + t158;
            double d40 = t10 * t11 * wx;
            void var359_182 = t152 + t153 + t154 - t155 - t161;
            double d41 = fy * t160;
            void var363_184 = t148 * v0;
            void var365_185 = t162 + t163;
            double d42 = X * t164;
            double d43 = fy * t151;
            void var371_188 = t146 * v0;
            void var373_189 = t166 - t267;
            double d44 = Y * t167;
            void var377_191 = t165 - t268;
            double d45 = t21 * t168;
            double d46 = t70 * t110 * t159;
            void var383_194 = t169 - t269;
            double d47 = t56 * t59 * t170 * 2.0;
            void var387_196 = -t152 + t153 + t154 + t155 - t161;
            double d48 = fx * t172;
            void var391_198 = t146 * u0;
            double d49 = sk * t151;
            void var395_200 = t173 + t174 - t189;
            double d50 = Y * t175;
            double d51 = t10 * t23 * t87 * wy * 2.0;
            double d52 = t7 * t23 * t86 * wy;
            double d53 = t10 * t11 * wy * 2.0;
            void var405_205 = t177 + t178 - t190;
            double d54 = sk * t160;
            void var409_207 = t148 * u0;
            double d55 = fx * t179;
            void var413_209 = t180 + t181 - t191;
            double d56 = X * t182;
            void var417_211 = t176 + t183;
            double d57 = t21 * t184;
            double d58 = t46 * t110 * t159;
            void var423_214 = t185 - t192;
            double d59 = t38 * t51 * t186 * 2.0;
            void var427_216 = t171 + t187;
            double d60 = t4 * t9 * t11;
            double d61 = t4 * t7 * t86 * wx;
            double d62 = t4 * t10 * t87 * wx * 2.0;
            void var435_220 = -t152 + t155 - t161 + t194 + t195;
            double d63 = t4 * t7 * t86;
            double d64 = t10 * t29 * t87 * wz * 2.0;
            double d65 = t7 * t29 * t86 * wz;
            double d66 = t10 * t11 * wz * 2.0;
            void var445_225 = t198 + t199 - t204;
            double d67 = t4 * t7 * t86 * wy;
            double d68 = t4 * t10 * t87 * wy * 2.0;
            double d69 = t88 - t104 - t117 + t201 + t202;
            double d70 = t10 * t23 * t87 * wz * 2.0;
            double d71 = t7 * t23 * t86 * wz;
            void var457_231 = t196 * u0;
            double d72 = t95 + t97 + t98 + t193 - t197;
            void var461_233 = t203 * u0;
            double d73 = -t95 + t97 + t98 - t193 + t197;
            double d74 = fx * t210;
            double d75 = sk * t200;
            void var469_237 = t209 + t211 - t231;
            double d76 = Y * t212;
            double d77 = X * t196;
            double d78 = Y * t203;
            void var477_241 = t214 + t215;
            void var479_242 = t196 * v0;
            double d79 = fy * t208;
            void var483_244 = t217 + t218;
            double d80 = X * t219;
            double d81 = fy * t200;
            void var489_247 = t203 * v0;
            void var491_248 = t221 - t273;
            double d82 = Y * t222;
            void var495_250 = t220 - t274;
            double d83 = t21 * t223;
            double d84 = t70 * t110 * t216;
            void var501_253 = t224 - t275;
            double d85 = t56 * t59 * t225 * 2.0;
            void var505_255 = -t204 + t205 + t206;
            double d86 = sk * t208;
            double d87 = fx * t227;
            void var511_258 = t207 + t228 - t237;
            double d88 = X * t229;
            void var515_260 = t213 + t230;
            double d89 = t21 * t232;
            double d90 = t46 * t110 * t216;
            void var521_263 = t233 - t238;
            double d91 = t38 * t51 * t234 * 2.0;
            void var525_265 = t226 + t235;
            double d92 = 1.0 / fx;
            double d93 = 1.0 / fy;
            double d94 = t21 * t56 * t240 * 2.0;
            double d95 = sk * t21 * t38 * t51 * 2.0;
            void var535_270 = t241 + t242;
            double d96 = t21 * u0;
            double d97 = t46 * t110;
            void var541_273 = t244 - t248;
            double d98 = t70 * t110;
            double d99 = t21 * v0;
            void var547_276 = t246 - t285;
            double d100 = t38 * t51 * t245 * 2.0;
            double d101 = t56 * t59 * t247 * 2.0;
            void var553_279 = t249 - t286;
            double d102 = k1 * t55;
            double d103 = k2 * t55 * t74 * 2.0;
            void var559_282 = t251 + t252;
            double d104 = k1 * t81;
            double d105 = k2 * t74 * t81 * 2.0;
            void var565_285 = t254 + t255;
            double d106 = t21 * t79;
            double d107 = t21 * t79 * t85;
            double d108 = k1 * t21 * t38 * t51 * t79 * 2.0;
            double d109 = k2 * t21 * t38 * t51 * t74 * t79 * 4.0;
            void var575_290 = t259 + t260;
            double d110 = k1 * t140;
            double d111 = k2 * t74 * t140 * 2.0;
            double d112 = k1 * t188;
            double d113 = k2 * t74 * t188 * 2.0;
            void var585_295 = t270 + t271;
            double d114 = k1 * t236;
            double d115 = k2 * t74 * t236 * 2.0;
            void var591_298 = t276 + t277;
            double d116 = k1 * t21 * t38 * t239 * 2.0;
            double d117 = k2 * t21 * t38 * t74 * t239 * 4.0;
            void var597_301 = t279 + t280;
            double d118 = k1 * t243;
            double d119 = k2 * t74 * t243 * 2.0;
            void var603_304 = t282 + t283;
            double d120 = k1 * t250;
            double d121 = k2 * t74 * t250 * 2.0;
            void var609_307 = t287 + t288;
            A0[0][0] = t21 * t53 + t253 * (u0 - t21 * (t34 + t35 + t36 + t37 + X * (t26 - t14 * u0 + sk * (t15 - t10 * t11 * wx * wy)))) + t21 * t53 * t85;
            A0[0][1] = t38 * t256;
            A0[0][2] = 1.0;
            A0[0][4] = t257 + t258 + t38 * t261;
            A0[0][5] = -t38 * t74;
            A0[0][6] = -t38 * t83;
            A0[0][7] = t137 - t143 + t38 * (t265 + t266) + t85 * (t21 * (X * (t115 - fx * t113 + sk * (t88 + t89 + t90 - t10 * t11 * wy - t7 * t86 * wx * wz)) + Y * (t118 + fx * (-t88 + t89 + t90 + t104 - t10 * t11 * wy) - sk * t102)) - t46 * t109 * t110);
            A0[0][8] = t185 - t192 + t85 * t186 + t38 * t272;
            A0[0][9] = -t238 + t38 * t278 + t85 * t234 + t21 * (t213 + X * (t207 + sk * (t95 + t97 + t98 + t193 - t4 * t7 * t86) - fx * (t205 + t206 - t10 * t11 * wz * 2.0)));
            A0[0][10] = fx * t21 + t38 * t281 + fx * t21 * t85;
            A0[0][11] = sk * t21 + t38 * t284 + sk * t21 * t85;
            A0[0][12] = t244 - t46 * t110 + t38 * t289 + t85 * t245;
            A0[1][0] = t56 * t253;
            A0[1][1] = t257 + t258 + t56 * t256;
            A0[1][3] = 1.0;
            A0[1][4] = t56 * t261;
            A0[1][5] = -t56 * t74;
            A0[1][6] = -t56 * t83;
            A0[1][7] = -t126 - t127 + t56 * (t265 + t266) - t85 * t128;
            A0[1][8] = t169 - t269 + t85 * t170 + t56 * t272;
            A0[1][9] = t224 - t275 + t85 * t225 + t56 * t278;
            A0[1][10] = t56 * t281;
            A0[1][11] = fy * t21 + t56 * t284 + fy * t21 * t85;
            A0[1][12] = -t246 + t285 - t85 * t247 + t56 * t289;
            double[][] dArray = new double[2][7 + 6 * CameraCalibrationZhang.this.points.size()];
            System.arraycopy(A0[0], 0, result[0], 0, 7);
            System.arraycopy(A0[1], 0, result[1], 0, 7);
            System.arraycopy(A0[0], 7, result[0], 7 + img * 6, 6);
            System.arraycopy(A0[1], 7, result[1], 7 + img * 6, 6);
            return result;
        }
    }

    private class Value
    implements MultivariateVectorFunction {
        private Value() {
        }

        public double[] value(double[] params) throws IllegalArgumentException {
            int totalPoints = 0;
            for (int i = 0; i < CameraCalibrationZhang.this.points.size(); ++i) {
                totalPoints += CameraCalibrationZhang.this.points.get(i).size();
            }
            double[] result = new double[2 * totalPoints];
            int k = 0;
            for (int i = 0; i < CameraCalibrationZhang.this.points.size(); ++i) {
                int j = 0;
                while (j < CameraCalibrationZhang.this.points.get(i).size()) {
                    double[] tmp = this.computeValue(i, j, params);
                    result[k * 2 + 0] = tmp[0];
                    result[k * 2 + 1] = tmp[1];
                    ++j;
                    ++k;
                }
            }
            return result;
        }

        private double[] computeValue(int img, int point, double[] params) {
            double[][] A0 = new double[2][1];
            double X = ((Point2d)CameraCalibrationZhang.this.points.get(img).get(point).firstObject()).getX();
            double Y = ((Point2d)CameraCalibrationZhang.this.points.get(img).get(point).firstObject()).getY();
            double fx = params[0];
            double fy = params[1];
            double u0 = params[2];
            double v0 = params[3];
            double sk = params[4];
            double k1 = params[5];
            double k2 = params[6];
            double wx = params[img * 6 + 7];
            double wy = params[img * 6 + 8];
            double wz = params[img * 6 + 9];
            double tx = params[img * 6 + 10];
            double ty = params[img * 6 + 11];
            double tz = params[img * 6 + 12];
            double t2 = wx * wx;
            double t3 = wy * wy;
            double t4 = wz * wz;
            double t5 = t2 + t3 + t4;
            double t6 = Math.sqrt(t5);
            double t7 = Math.sin(t6);
            double t8 = 1.0 / Math.sqrt(t5);
            double t9 = Math.cos(t6);
            double t10 = t9 - 1.0;
            double t11 = 1.0 / t5;
            double t12 = t7 * t8 * wy;
            double t13 = t10 * t11 * wx * wz;
            double t14 = t12 + t13;
            double t15 = t7 * t8 * wz;
            double t16 = t7 * t8 * wx;
            double t18 = t10 * t11 * wy * wz;
            double t17 = t16 - t18;
            double t19 = Y * t17;
            double t39 = X * t14;
            double t20 = t19 - t39 + tz;
            double t21 = 1.0 / t20;
            double t22 = t10 * t11 * wx * wy;
            double t23 = t3 + t4;
            double t24 = t10 * t11 * t23;
            double t25 = t24 + 1.0;
            double t26 = fx * t25;
            double t27 = t15 + t22;
            double t28 = t17 * u0;
            double t29 = t2 + t4;
            double t30 = t10 * t11 * t29;
            double t31 = t30 + 1.0;
            double t32 = sk * t31;
            double t47 = fx * t27;
            double t33 = t28 + t32 - t47;
            double t34 = Y * t33;
            double t35 = fx * tx;
            double t36 = sk * ty;
            double t37 = tz * u0;
            double t40 = t15 - t22;
            double t43 = sk * t40;
            double t44 = t14 * u0;
            double t45 = t26 + t43 - t44;
            double t46 = X * t45;
            double t48 = t34 + t35 + t36 + t37 + t46;
            double t49 = t21 * t48;
            double t38 = -t49 + u0;
            double t53 = fy * ty;
            double t54 = fy * t40;
            double t55 = t14 * v0;
            double t56 = t54 - t55;
            double t57 = X * t56;
            double t58 = tz * v0;
            double t59 = t17 * v0;
            double t60 = fy * t31;
            double t61 = t59 + t60;
            double t62 = Y * t61;
            double t63 = t53 + t57 + t58 + t62;
            double t64 = t21 * t63;
            double t41 = -t64 + v0;
            double t42 = 1.0 / (fx * fx);
            double t50 = t38 * t38;
            double t51 = t42 * t50;
            double t52 = 1.0 / (fy * fy);
            double t65 = t41 * t41;
            double t66 = t52 * t65;
            double t67 = t51 + t66;
            double t68 = k1 * t67;
            double t69 = t67 * t67;
            double t70 = k2 * t69;
            double t71 = t68 + t70;
            A0[0][0] = -t38 * t71 + t21 * (t34 + t35 + t36 + t37 + X * (t26 - t14 * u0 + sk * (t15 - t10 * t11 * wx * wy)));
            A0[1][0] = t64 - t41 * t71;
            return new double[]{A0[0][0], A0[1][0]};
        }
    }
}

