/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera.calibration;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.openimaj.algorithm.iterative.MinEpsilonOrMaxIterations;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.camera.calibration.FastChessboardDetector;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.contour.Contour;
import org.openimaj.image.contour.SuzukiContourProcessor;
import org.openimaj.image.feature.local.interest.SubPixelCorners;
import org.openimaj.image.processing.algorithm.EqualisationProcessor;
import org.openimaj.image.processing.algorithm.MaxFilter;
import org.openimaj.image.processing.algorithm.MeanCenter;
import org.openimaj.image.processing.threshold.AdaptiveLocalThresholdMean;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Circle;
import org.openimaj.math.geometry.shape.PointList;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.pair.FloatIntPair;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayAdapter;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.capture.VideoCapture;

public class ChessboardCornerFinder
implements ImageAnalyser<FImage> {
    private static final Logger logger = Logger.getLogger(ChessboardCornerFinder.class);
    private static final int MIN_DILATIONS = 0;
    private static final int MAX_DILATIONS = 7;
    private static final SubPixelCorners SUB_PIX_CORNERS = new SubPixelCorners(2, 2, (Predicate)new MinEpsilonOrMaxIterations(0.1, 15));
    boolean filterQuads = true;
    private double minSize = 25.0;
    private int maxApproxLevel = 7;
    boolean histogramEqualise = false;
    boolean adaptiveThreshold = false;
    final FastChessboardDetector fastDetector;
    private int patternWidth;
    private int patternHeight;
    boolean found = false;
    private List<Point2dImpl> outCorners = new ArrayList<Point2dImpl>();

    public ChessboardCornerFinder(int patternWidth, int patternHeight, Options ... opts) {
        this.patternWidth = patternWidth;
        this.patternHeight = patternHeight;
        EnumSet<Options> es = EnumSet.noneOf(Options.class);
        for (Options o : opts) {
            es.add(o);
        }
        this.filterQuads = es.contains((Object)Options.FILTER_QUADS);
        this.histogramEqualise = es.contains((Object)Options.HISTOGRAM_EQUALISE);
        this.adaptiveThreshold = es.contains((Object)Options.ADAPTIVE_THRESHOLD);
        this.fastDetector = es.contains((Object)Options.FAST_CHECK) ? new FastChessboardDetector(patternWidth, patternHeight) : null;
    }

    public void analyseImage(FImage image) {
        this.found = false;
        this.outCorners.clear();
        if (this.histogramEqualise) {
            image = (FImage)image.process((SinglebandImageProcessor)new EqualisationProcessor());
        }
        int prevSqrSize = 0;
        if (this.fastDetector != null) {
            this.fastDetector.analyseImage(image);
            if (!this.fastDetector.chessboardDetected()) {
                return;
            }
        }
        for (int k = 0; k < 6; ++k) {
            block1: for (int dilations = 0; dilations < 7 && !this.found; ++dilations) {
                FImage threshImg;
                if (this.adaptiveThreshold) {
                    int blockSize = (int)(Math.round(prevSqrSize == 0 ? (double)Math.min(image.width, image.height) * (k % 2 == 0 ? 0.2 : 0.1) : (double)(prevSqrSize * 2)) | 1L);
                    threshImg = (FImage)image.process((SinglebandImageProcessor)new AdaptiveLocalThresholdMean(blockSize, k / 2 * 5));
                    if (dilations > 0) {
                        MaxFilter.filter((FImage)threshImg, (int)(dilations - 1));
                    }
                } else {
                    threshImg = image.clone().threshold(Float.valueOf(MeanCenter.patchMean((float[][])image.pixels) - 0.039215688f));
                    MaxFilter.filter((FImage)threshImg, (int)dilations);
                }
                threshImg.drawShape((Shape)new Rectangle(1.0f, 1.0f, (float)(threshImg.width - 3), (float)(threshImg.height - 3)), 3, (Object)Float.valueOf(1.0f));
                List<Quad> quads = this.extractQuads(threshImg);
                if (quads.size() <= 0) continue;
                this.findQuadNeighbours(quads);
                int groupIdx = 0;
                while (true) {
                    int count;
                    List<Quad> quadGroup = this.findConnectedQuads(quads, groupIdx);
                    int icount = count = quadGroup.size();
                    if (count == 0) continue block1;
                    logger.trace((Object)"Starting ordering of inner quads");
                    count = this.orderFoundConnectedQuads(quadGroup, quads);
                    logger.trace((Object)String.format("Orig count: %d  After ordering: %d", icount, count));
                    if (count != 0) {
                        int i;
                        count = this.cleanFoundConnectedQuads(quadGroup);
                        logger.trace((Object)String.format("Connected group: %d  orig count: %d cleaned: %d", groupIdx, icount, count));
                        ArrayList<Corner> cornerGroup = new ArrayList<Corner>();
                        count = this.checkQuadGroup(quadGroup, cornerGroup);
                        logger.trace((Object)String.format("Connected group: %d  count: %d  cleaned: %d", groupIdx, icount, count));
                        int n = count > 0 ? this.patternWidth * this.patternHeight : -count;
                        n = Math.min(n, this.patternWidth * this.patternHeight);
                        float sumDist = 0.0f;
                        int total = 0;
                        for (i = 0; i < n; ++i) {
                            FloatIntPair pair = ((Corner)((Object)cornerGroup.get(i))).meanDist();
                            float avgi = pair.first;
                            int ni = pair.second;
                            sumDist += avgi * (float)ni;
                            total += ni;
                        }
                        prevSqrSize = Math.round(sumDist / (float)Math.max(total, 1));
                        if (count > 0 || this.outCorners.size() > 0 && -count > this.outCorners.size()) {
                            this.outCorners.clear();
                            for (i = 0; i < n; ++i) {
                                this.outCorners.add(new Point2dImpl((Point2d)cornerGroup.get(i)));
                            }
                            if (count == this.patternWidth * this.patternHeight && this.checkBoardMonotony()) {
                                this.found = true;
                                continue block1;
                            }
                        }
                    }
                    ++groupIdx;
                }
            }
        }
        if (this.found) {
            this.found = this.checkBoardMonotony();
        }
        if (this.found) {
            int k;
            int BORDER = 8;
            for (k = 0; !(k >= this.patternWidth * this.patternHeight || this.outCorners.get((int)k).x <= 8.0f || this.outCorners.get((int)k).x > (float)(image.width - 8) || this.outCorners.get((int)k).y <= 8.0f || this.outCorners.get((int)k).y > (float)(image.height - 8)); ++k) {
            }
            boolean bl = this.found = k == this.patternWidth * this.patternHeight;
        }
        if (this.found && this.patternHeight % 2 == 0 && this.patternWidth % 2 == 0) {
            int lastRow = (this.patternHeight - 1) * this.patternWidth;
            double dy0 = this.outCorners.get((int)lastRow).y - this.outCorners.get((int)0).y;
            if (dy0 < 0.0) {
                int n = this.patternWidth * this.patternHeight;
                for (int i = 0; i < n / 2; ++i) {
                    Collections.swap(this.outCorners, i, n - i - 1);
                }
            }
        }
        if (this.found) {
            this.outCorners = SUB_PIX_CORNERS.findSubPixCorners(image, this.outCorners);
        }
    }

    private List<Quad> extractQuads(FImage threshImg) {
        TObjectIntHashMap counters = new TObjectIntHashMap();
        ArrayList<Corner[]> cornerList = new ArrayList<Corner[]>();
        HashMap<Corner[], Contour> parentMapping = new HashMap<Corner[], Contour>();
        Contour board = null;
        Contour contours = SuzukiContourProcessor.findContours((FImage)threshImg);
        for (Contour c : contours.contourIterable()) {
            Rectangle bounds = c.calculateRegularBoundingBox();
            if (!c.isHole() || !((double)(bounds.width * bounds.height) >= this.minSize)) continue;
            Polygon p = null;
            for (int approxLevel = 1; approxLevel <= this.maxApproxLevel && (p = c.reduceVertices((double)approxLevel)).nVertices() != 4; ++approxLevel) {
            }
            if (p == null || p.nVertices() != 4 || !p.isConvex() || !p.hasNoInnerPolygons()) continue;
            double perimeter = p.calculatePerimeter();
            double area = p.calculateArea();
            Corner[] pt = new Corner[4];
            for (int i = 0; i < 4; ++i) {
                pt[i] = new Corner((Point2d)p.points.get(i));
            }
            float dx = pt[0].x - pt[2].x;
            float dy = pt[0].y - pt[2].y;
            double d1 = Math.sqrt(dx * dx + dy * dy);
            dx = pt[1].x - pt[3].x;
            dy = pt[1].y - pt[3].y;
            double d2 = Math.sqrt(dx * dx + dy * dy);
            dx = pt[0].x - pt[1].x;
            dy = pt[0].y - pt[1].y;
            double d3 = Math.sqrt(dx * dx + dy * dy);
            dx = pt[1].x - pt[2].x;
            dy = pt[1].y - pt[2].y;
            double d4 = Math.sqrt(dx * dx + dy * dy);
            if (this.filterQuads && (!(d3 * 4.0 > d4) || !(d4 * 4.0 > d3) || !(d3 * d4 < area * 1.5) || !(area > this.minSize) || !(d1 >= 0.15 * perimeter) || !(d2 >= 0.15 * perimeter))) continue;
            Contour parent = c.parent;
            counters.adjustOrPutValue((Object)parent, 1, 1);
            if (board == null || counters.get((Object)board) < counters.get((Object)parent)) {
                board = parent;
            }
            cornerList.add(pt);
            parentMapping.put(pt, c.parent);
        }
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (int i = 0; i < cornerList.size(); ++i) {
            Corner[] pts = (Corner[])cornerList.get(i);
            if (this.filterQuads && parentMapping.get(pts) != board) continue;
            Quad q = new Quad();
            q.corners = pts;
            q.minEdgeLength = Float.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                float dx = pts[j].x - pts[j + 1 & 3].x;
                float dy = pts[j].y - pts[j + 1 & 3].y;
                float d = dx * dx + dy * dy;
                if (!(q.minEdgeLength > d)) continue;
                q.minEdgeLength = d;
            }
            quads.add(q);
        }
        return quads;
    }

    private void findQuadNeighbours(List<Quad> quads) {
        int quadCount = quads.size();
        float threshScale = 1.0f;
        for (int idx = 0; idx < quads.size(); ++idx) {
            Quad curQuad = quads.get(idx);
            for (int i = 0; i < 4; ++i) {
                int k;
                int j;
                float dy;
                float dx;
                float dist;
                float minDist = Float.MAX_VALUE;
                int closestCornerIdx = -1;
                Quad closestQuad = null;
                Corner closestCorner = null;
                if (curQuad.neighbours[i] != null) continue;
                Corner pt = curQuad.corners[i];
                for (int k2 = 0; k2 < quadCount; ++k2) {
                    if (k2 == idx) continue;
                    for (int j2 = 0; j2 < 4; ++j2) {
                        if (quads.get((int)k2).neighbours[j2] != null || !((dist = (dx = pt.x - quads.get((int)k2).corners[j2].x) * dx + (dy = pt.y - quads.get((int)k2).corners[j2].y) * dy) < minDist) || !(dist <= curQuad.minEdgeLength * 1.0f) || !(dist <= quads.get((int)k2).minEdgeLength * 1.0f)) continue;
                        float ediff = curQuad.minEdgeLength - quads.get((int)k2).minEdgeLength;
                        if (ediff > 32.0f * curQuad.minEdgeLength || ediff > 32.0f * quads.get((int)k2).minEdgeLength) {
                            logger.trace((Object)"Incompatible edge lengths");
                            continue;
                        }
                        closestCornerIdx = j2;
                        closestQuad = quads.get(k2);
                        minDist = dist;
                    }
                }
                if (closestCornerIdx < 0 || !(minDist < Float.MAX_VALUE)) continue;
                closestCorner = closestQuad.corners[closestCornerIdx];
                for (j = 0; j < 4 && curQuad.neighbours[j] != closestQuad && !((dx = closestCorner.x - curQuad.corners[j].x) * dx + (dy = closestCorner.y - curQuad.corners[j].y) * dy < minDist); ++j) {
                }
                if (j < 4 || curQuad.count >= 4 || closestQuad.count >= 4) continue;
                for (j = 0; j < closestQuad.count && closestQuad.neighbours[j] != curQuad; ++j) {
                }
                if (j < closestQuad.count) continue;
                for (k = 0; k < quadCount; ++k) {
                    Quad q = quads.get(k);
                    if (k == idx || q == closestQuad) continue;
                    for (j = 0; !(j >= 4 || q.neighbours[j] == null && (dist = (dx = closestCorner.x - q.corners[j].x) * dx + (dy = closestCorner.y - q.corners[j].y) * dy) < minDist); ++j) {
                    }
                    if (j < 4) break;
                }
                if (k < quadCount) continue;
                closestCorner.x = (pt.x + closestCorner.x) * 0.5f;
                closestCorner.y = (pt.y + closestCorner.y) * 0.5f;
                ++curQuad.count;
                curQuad.neighbours[i] = closestQuad;
                curQuad.corners[i] = closestCorner;
                ++closestQuad.count;
                closestQuad.neighbours[closestCornerIdx] = curQuad;
            }
        }
    }

    public boolean isFound() {
        return this.found;
    }

    public List<Point2dImpl> getCorners() {
        return this.outCorners;
    }

    private List<Quad> findConnectedQuads(List<Quad> quads, int groupIdx) {
        int i;
        ArrayDeque<Quad> stack = new ArrayDeque<Quad>();
        int quadCount = quads.size();
        ArrayList<Quad> outGroup = new ArrayList<Quad>();
        for (i = 0; i < quadCount && (quads.get((int)i).count <= 0 || quads.get((int)i).groupIdx >= 0); ++i) {
        }
        if (i < quadCount) {
            Quad q = quads.get(i);
            stack.push(q);
            outGroup.add(q);
            q.groupIdx = groupIdx;
            q.ordered = false;
            while (stack.size() > 0) {
                q = (Quad)stack.pop();
                for (i = 0; i < 4; ++i) {
                    Quad neighbour = q.neighbours[i];
                    if (neighbour == null || neighbour.count <= 0 || neighbour.groupIdx >= 0) continue;
                    stack.push(neighbour);
                    outGroup.add(neighbour);
                    neighbour.groupIdx = groupIdx;
                    neighbour.ordered = false;
                }
            }
        }
        return outGroup;
    }

    private int orderFoundConnectedQuads(List<Quad> quads, List<Quad> allQuads) {
        int j;
        int i;
        ArrayDeque<Quad> stack = new ArrayDeque<Quad>();
        int quadCount = quads.size();
        Quad start = null;
        for (int i2 = 0; i2 < quadCount; ++i2) {
            if (quads.get((int)i2).count != 4) continue;
            start = quads.get(i2);
            break;
        }
        if (start == null) {
            return 0;
        }
        int rowMin = 0;
        int colMin = 0;
        int rowMax = 0;
        int colMax = 0;
        TIntIntHashMap colHist = new TIntIntHashMap();
        TIntIntHashMap rowHist = new TIntIntHashMap();
        stack.push(start);
        start.row = 0;
        start.col = 0;
        start.ordered = true;
        while (stack.size() > 0) {
            Quad q = (Quad)stack.pop();
            int col = q.col;
            int row = q.row;
            colHist.adjustOrPutValue(col, 1, 1);
            rowHist.adjustOrPutValue(row, 1, 1);
            if (row > rowMax) {
                rowMax = row;
            }
            if (row < rowMin) {
                rowMin = row;
            }
            if (col > colMax) {
                colMax = col;
            }
            if (col < colMin) {
                colMin = col;
            }
            for (int i3 = 0; i3 < 4; ++i3) {
                Quad neighbour = q.neighbours[i3];
                switch (i3) {
                    case 0: {
                        --row;
                        --col;
                        break;
                    }
                    case 1: {
                        col += 2;
                        break;
                    }
                    case 2: {
                        row += 2;
                        break;
                    }
                    case 3: {
                        col -= 2;
                    }
                }
                if (neighbour == null || neighbour.ordered || neighbour.count != 4) continue;
                this.orderQuad(neighbour, q.corners[i3], (i3 + 2) % 4);
                neighbour.ordered = true;
                neighbour.row = row;
                neighbour.col = col;
                stack.push(neighbour);
            }
        }
        int w = this.patternWidth - 1;
        int h = this.patternHeight - 1;
        int drow = rowMax - rowMin + 1;
        int dcol = colMax - colMin + 1;
        if (w > h && dcol < drow || w < h && drow < dcol) {
            h = this.patternWidth - 1;
            w = this.patternHeight - 1;
        }
        logger.trace((Object)String.format("Size: %dx%d  Pattern: %dx%d", dcol, drow, w, h));
        if (dcol < w || drow < h) {
            logger.trace((Object)"Too few inner quad rows/cols");
            return 0;
        }
        int found = 0;
        for (i = 0; i < quadCount; ++i) {
            if (quads.get((int)i).count != 4) continue;
            int col = quads.get((int)i).col;
            int row = quads.get((int)i).row;
            for (j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        --row;
                        --col;
                        break;
                    }
                    case 1: {
                        col += 2;
                        break;
                    }
                    case 2: {
                        row += 2;
                        break;
                    }
                    case 3: {
                        col -= 2;
                    }
                }
                Quad neighbour = quads.get((int)i).neighbours[j];
                if (neighbour == null || neighbour.ordered || col > colMax || col < colMin || row > rowMax || row < rowMin) continue;
                logger.trace((Object)String.format("Adding inner: col: %d  row: %d", col, row));
                ++found;
                this.orderQuad(neighbour, quads.get((int)i).corners[j], (j + 2) % 4);
                neighbour.ordered = true;
                neighbour.row = row;
                neighbour.col = col;
            }
        }
        if (found > 0) {
            logger.trace((Object)String.format("Found %d inner quads not connected to outer quads, repairing", found));
            for (i = 0; i < quadCount; ++i) {
                if (quads.get((int)i).count >= 4 || !quads.get((int)i).ordered) continue;
                int added = this.addOuterQuad(quads.get(i), quads, allQuads);
                quadCount += added;
            }
        }
        if (dcol == w && drow == h) {
            logger.trace((Object)"Inner bounds ok, check outer quads");
            int rcount = quadCount;
            for (int i4 = quadCount - 1; i4 >= 0; --i4) {
                if (quads.get((int)i4).ordered) continue;
                boolean outer = false;
                for (j = 0; j < 4; ++j) {
                    if (quads.get((int)i4).neighbours[j] == null || !quads.get((int)i4).neighbours[j].ordered) continue;
                    outer = true;
                }
                if (outer) continue;
                logger.trace((Object)String.format("Removing quad %d", i4));
                this.removeQuadFromGroup(quads, quads.get(i4));
                --rcount;
            }
            return rcount;
        }
        return 0;
    }

    private void orderQuad(Quad quad, Corner corner, int common) {
        int tc;
        for (tc = 0; tc < 4 && (quad.corners[tc].x != corner.x || quad.corners[tc].y != corner.y); ++tc) {
        }
        while (tc != common) {
            Corner tempc = quad.corners[3];
            Quad tempq = quad.neighbours[3];
            for (int i = 3; i > 0; --i) {
                quad.corners[i] = quad.corners[i - 1];
                quad.neighbours[i] = quad.neighbours[i - 1];
            }
            quad.corners[0] = tempc;
            quad.neighbours[0] = tempq;
            ++tc;
            tc %= 4;
        }
    }

    private int addOuterQuad(Quad quad, List<Quad> quads, List<Quad> allQuads) {
        int added = 0;
        for (int i = 0; i < 4; ++i) {
            if (quad.neighbours[i] != null) continue;
            int j = (i + 2) % 4;
            logger.trace((Object)"Adding quad as neighbor 2");
            Quad q = new Quad();
            allQuads.add(q);
            ++added;
            quads.add(q);
            quad.neighbours[i] = q;
            ++quad.count;
            q.neighbours[j] = quad;
            q.groupIdx = quad.groupIdx;
            q.count = 1;
            q.ordered = false;
            q.minEdgeLength = quad.minEdgeLength;
            Corner pt = quad.corners[i];
            float dx = pt.x - quad.corners[j].x;
            float dy = pt.y - quad.corners[j].y;
            for (int k = 0; k < 4; ++k) {
                Corner corner = new Corner((Point2d)pt);
                pt = quad.corners[k];
                q.corners[k] = corner;
                corner.x += dx;
                corner.y += dy;
            }
            q.corners[j] = quad.corners[i];
            if (quad.neighbours[(i + 3) % 4] == null || !quad.neighbours[(i + 3) % 4].ordered || quad.neighbours[(i + 3) % 4].neighbours[i] == null || !quad.neighbours[(i + 3) % 4].neighbours[i].ordered) continue;
            Quad qn = quad.neighbours[(i + 3) % 4].neighbours[i];
            q.count = 2;
            q.neighbours[(j + 1) % 4] = qn;
            qn.neighbours[(i + 1) % 4] = q;
            ++qn.count;
            q.corners[(j + 1) % 4] = qn.corners[(i + 1) % 4];
        }
        return added;
    }

    private void removeQuadFromGroup(List<Quad> quads, Quad q0) {
        int count = quads.size();
        block0: for (int i = 0; i < count; ++i) {
            Quad q = quads.get(i);
            for (int j = 0; j < 4; ++j) {
                if (q.neighbours[j] != q0) continue;
                q.neighbours[j] = null;
                --q.count;
                for (int k = 0; k < 4; ++k) {
                    if (q0.neighbours[k] != q) continue;
                    q0.neighbours[k] = null;
                    --q0.count;
                    continue block0;
                }
                continue block0;
            }
        }
        quads.remove(q0);
    }

    private int cleanFoundConnectedQuads(List<Quad> quadGroup) {
        int quadCount = quadGroup.size();
        Point2dImpl center = new Point2dImpl();
        int count = ((this.patternWidth + 1) * (this.patternHeight + 1) + 1) / 2;
        if (quadCount <= count) {
            return quadCount;
        }
        ArrayList<Point2dImpl> centers = new ArrayList<Point2dImpl>(quadCount);
        for (int i = 0; i < quadCount; ++i) {
            Point2dImpl ci = new Point2dImpl();
            Quad q = quadGroup.get(i);
            for (int j = 0; j < 4; ++j) {
                Corner pt = q.corners[j];
                ci.x += pt.x;
                ci.y += pt.y;
            }
            ci.x *= 0.25f;
            ci.y *= 0.25f;
            centers.add(ci);
            center.x += ci.x;
            center.y += ci.y;
        }
        center.x /= (float)quadCount;
        center.y /= (float)quadCount;
        while (quadCount > count) {
            double minBoxArea = Double.MAX_VALUE;
            int minBoxAreaIndex = -1;
            for (int skip = 0; skip < quadCount; ++skip) {
                Point2dImpl temp = (Point2dImpl)centers.get(skip);
                centers.set(skip, center);
                PointList pl = new PointList(centers);
                Polygon hull = pl.calculateConvexHull();
                centers.set(skip, temp);
                double hullArea = hull.calculateArea();
                if (!(hullArea < minBoxArea)) continue;
                minBoxArea = hullArea;
                minBoxAreaIndex = skip;
            }
            Quad q0 = quadGroup.get(minBoxAreaIndex);
            block4: for (int i = 0; i < quadCount; ++i) {
                Quad q = quadGroup.get(i);
                for (int j = 0; j < 4; ++j) {
                    if (q.neighbours[j] != q0) continue;
                    q.neighbours[j] = null;
                    --q.count;
                    for (int k = 0; k < 4; ++k) {
                        if (q0.neighbours[k] != q) continue;
                        q0.neighbours[k] = null;
                        --q0.count;
                        continue block4;
                    }
                    continue block4;
                }
            }
            --quadCount;
            quadGroup.remove(minBoxAreaIndex);
            centers.remove(minBoxAreaIndex);
            --quadCount;
        }
        return quadCount;
    }

    private int checkQuadGroup(List<Quad> quadGroup, List<Corner> outCorners) {
        int ROW1 = 1000000;
        int ROW2 = 2000000;
        int ROW_ = 3000000;
        int result = 0;
        int quadCount = quadGroup.size();
        int cornerCount = 0;
        Corner[] corners = new Corner[quadCount * 4];
        int width = 0;
        int height = 0;
        int[] hist = new int[]{0, 0, 0, 0, 0};
        Corner first = null;
        Corner first2 = null;
        try {
            Corner c;
            int k;
            int j;
            int i;
            for (i = 0; i < quadCount; ++i) {
                Quad q = quadGroup.get(i);
                for (j = 0; j < 4; ++j) {
                    int rowFlag;
                    if (q.neighbours[j] == null) continue;
                    Corner a = q.corners[j];
                    Corner b = q.corners[j + 1 & 3];
                    int n = q.count == 1 ? 1000000 : (rowFlag = q.count == 2 ? 2000000 : 3000000);
                    if (a.row == 0) {
                        corners[cornerCount++] = a;
                        a.row = rowFlag;
                    } else if (a.row > rowFlag) {
                        a.row = rowFlag;
                    }
                    if (q.neighbours[j + 1 & 3] == null) continue;
                    if (a.count >= 4 || b.count >= 4) {
                        throw new Exception();
                    }
                    for (int k2 = 0; k2 < 4; ++k2) {
                        if (a.neighbours[k2] == b) {
                            throw new Exception();
                        }
                        if (b.neighbours[k2] != a) continue;
                        throw new Exception();
                    }
                    a.neighbours[a.count++] = b;
                    b.neighbours[b.count++] = a;
                }
            }
            if (cornerCount != this.patternWidth * this.patternHeight) {
                throw new Exception();
            }
            for (i = 0; i < cornerCount; ++i) {
                int n = corners[i].count;
                assert (0 <= n && n <= 4);
                int n2 = n;
                hist[n2] = hist[n2] + 1;
                if (first != null || n != 2) continue;
                if (corners[i].row == 1000000) {
                    first = corners[i];
                    continue;
                }
                if (first2 != null || corners[i].row != 2000000) continue;
                first2 = corners[i];
            }
            if (first == null) {
                first = first2;
            }
            if (first == null || hist[0] != 0 || hist[1] != 0 || hist[2] != 4 || hist[3] != (this.patternWidth + this.patternHeight) * 2 - 8) {
                throw new Exception();
            }
            Corner cur = first;
            Corner below = null;
            Corner right = null;
            outCorners.add(cur);
            for (k = 0; k < 4; ++k) {
                c = cur.neighbours[k];
                if (c == null) continue;
                if (right == null) {
                    right = c;
                    continue;
                }
                if (below != null) continue;
                below = c;
            }
            if (right == null || right.count != 2 && right.count != 3 || below == null || below.count != 2 && below.count != 3) {
                throw new Exception();
            }
            cur.row = 0;
            first = below;
            block7: while (true) {
                right.row = 0;
                outCorners.add(right);
                if (right.count == 2) break;
                if (right.count != 3 || outCorners.size() >= Math.max(this.patternWidth, this.patternHeight)) {
                    throw new Exception();
                }
                cur = right;
                k = 0;
                while (true) {
                    if (k >= 4) continue block7;
                    c = cur.neighbours[k];
                    if (c != null && c.row > 0) {
                        int kk;
                        for (kk = 0; kk < 4 && c.neighbours[kk] != below; ++kk) {
                        }
                        if (kk < 4) {
                            below = c;
                        } else {
                            right = c;
                        }
                    }
                    ++k;
                }
                break;
            }
            width = outCorners.size();
            if (width == this.patternWidth) {
                height = this.patternHeight;
            } else if (width == this.patternHeight) {
                height = this.patternWidth;
            } else {
                throw new Exception();
            }
            i = 1;
            while (first != null) {
                cur = first;
                first = null;
                int j2 = 0;
                while (true) {
                    cur.row = i;
                    outCorners.add(cur);
                    if (cur.count == 2 + (i < height - 1 ? 1 : 0) && j2 > 0) break;
                    right = null;
                    for (int k3 = 0; k3 < 4; ++k3) {
                        int kk;
                        c = cur.neighbours[k3];
                        if (c == null || c.row <= i) continue;
                        for (kk = 0; kk < 4 && (c.neighbours[kk] == null || c.neighbours[kk].row != i - 1); ++kk) {
                        }
                        if (kk < 4) {
                            right = c;
                            if (j2 <= 0) continue;
                            break;
                        }
                        if (j2 != 0) continue;
                        first = c;
                    }
                    if (right == null) {
                        throw new Exception();
                    }
                    cur = right;
                    ++j2;
                }
                if (j2 != width - 1) {
                    throw new Exception();
                }
                ++i;
            }
            if (outCorners.size() != cornerCount) {
                throw new Exception();
            }
            if (width != this.patternWidth) {
                int i2;
                int t = width;
                width = height;
                height = t;
                for (i2 = 0; i2 < cornerCount; ++i2) {
                    corners[i2] = outCorners.get(i2);
                }
                for (i2 = 0; i2 < height; ++i2) {
                    for (j = 0; j < width; ++j) {
                        outCorners.set(i2 * width + j, corners[j * height + i2]);
                    }
                }
            }
            Point2dImpl p0 = outCorners.get(0);
            Point2dImpl p1 = outCorners.get(this.patternWidth - 1);
            Point2dImpl p2 = outCorners.get(this.patternWidth);
            if ((p1.x - p0.x) * (p2.y - p1.y) - (p1.y - p0.y) * (p2.x - p1.x) < 0.0f) {
                if (width % 2 == 0) {
                    for (int i3 = 0; i3 < height; ++i3) {
                        for (int j3 = 0; j3 < width / 2; ++j3) {
                            Collections.swap(outCorners, i3 * width + j3, i3 * width + width - j3 - 1);
                        }
                    }
                } else {
                    for (int j4 = 0; j4 < width; ++j4) {
                        for (int i4 = 0; i4 < height / 2; ++i4) {
                            Collections.swap(outCorners, i4 * width + j4, (height - i4 - 1) * width + j4);
                        }
                    }
                }
            }
            result = cornerCount;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result <= 0) {
            cornerCount = Math.min(cornerCount, this.patternWidth * this.patternHeight);
            outCorners.clear();
            for (int i = 0; i < cornerCount; ++i) {
                outCorners.add(corners[i]);
            }
            result = -cornerCount;
            if (result == -this.patternWidth * this.patternHeight) {
                result = -result;
            }
        }
        return result;
    }

    private boolean checkBoardMonotony() {
        for (int k = 0; k < 2; ++k) {
            for (int i = 0; i < (k == 0 ? this.patternHeight : this.patternWidth); ++i) {
                Point2dImpl a = k == 0 ? this.outCorners.get(i * this.patternWidth) : this.outCorners.get(i);
                Point2dImpl b = k == 0 ? this.outCorners.get((i + 1) * this.patternWidth - 1) : this.outCorners.get((this.patternHeight - 1) * this.patternWidth + i);
                float prevt = 0.0f;
                float dx0 = b.x - a.x;
                float dy0 = b.y - a.y;
                if (Math.abs(dx0) + Math.abs(dy0) < Float.MIN_VALUE) {
                    return false;
                }
                for (int j = 1; j < (k == 0 ? this.patternWidth : this.patternHeight) - 1; ++j) {
                    Point2dImpl c = k == 0 ? this.outCorners.get(i * this.patternWidth + j) : this.outCorners.get(j * this.patternWidth + i);
                    float t = ((c.x - a.x) * dx0 + (c.y - a.y) * dy0) / (dx0 * dx0 + dy0 * dy0);
                    if (t < prevt || t > 1.0f) {
                        return false;
                    }
                    prevt = t;
                }
            }
        }
        return true;
    }

    public void drawChessboardCorners(MBFImage image) {
        ChessboardCornerFinder.drawChessboardCorners(image, this.patternWidth, this.patternHeight, this.outCorners, this.found);
    }

    public static void drawChessboardCorners(MBFImage image, int patternWidth, int patternHeight, List<? extends Point2d> corners, boolean found) {
        int radius = 4;
        if (!found) {
            Float[] color = RGBColour.RGB((int)0, (int)0, (int)255);
            for (int i = 0; i < corners.size(); ++i) {
                Point2d pt = corners.get(i);
                image.drawLine((Point2d)new Point2dImpl(pt.getX() - 4.0f, pt.getY() - 4.0f), (Point2d)new Point2dImpl(pt.getX() + 4.0f, pt.getY() + 4.0f), 1, (Object)color);
                image.drawLine((Point2d)new Point2dImpl(pt.getX() - 4.0f, pt.getY() + 4.0f), (Point2d)new Point2dImpl(pt.getX() + 4.0f, pt.getY() - 4.0f), 1, (Object)color);
                image.drawShape((Shape)new Circle(pt, 4.0f), 1, (Object)color);
            }
        } else {
            Point2dImpl prevPt = new Point2dImpl();
            Float[][] lineColours = new Float[][]{RGBColour.RGB((int)0, (int)0, (int)255), RGBColour.RGB((int)0, (int)128, (int)255), RGBColour.RGB((int)0, (int)200, (int)200), RGBColour.RGB((int)0, (int)255, (int)0), RGBColour.RGB((int)200, (int)200, (int)0), RGBColour.RGB((int)255, (int)0, (int)0), RGBColour.RGB((int)255, (int)0, (int)255)};
            int i = 0;
            for (int y = 0; y < patternHeight; ++y) {
                Float[] color = lineColours[y % lineColours.length];
                int x = 0;
                while (x < patternWidth) {
                    Point2d pt = corners.get(i);
                    if (i != 0) {
                        image.drawLine((Point2d)prevPt, pt, 1, (Object)color);
                    }
                    image.drawLine((Point2d)new Point2dImpl(pt.getX() - 4.0f, pt.getY() - 4.0f), (Point2d)new Point2dImpl(pt.getX() + 4.0f, pt.getY() + 4.0f), 1, (Object)color);
                    image.drawLine((Point2d)new Point2dImpl(pt.getX() - 4.0f, pt.getY() + 4.0f), (Point2d)new Point2dImpl(pt.getX() + 4.0f, pt.getY() - 4.0f), 1, (Object)color);
                    image.drawShape((Shape)new Circle(pt, 4.0f), 1, (Object)color);
                    prevPt = pt;
                    ++x;
                    ++i;
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        final ChessboardCornerFinder fcc = new ChessboardCornerFinder(9, 6, Options.FILTER_QUADS, Options.FAST_CHECK);
        VideoDisplay.createVideoDisplay((Video)new VideoCapture(640, 480)).addVideoListener((VideoDisplayListener)new VideoDisplayAdapter<MBFImage>(){

            public void beforeUpdate(MBFImage frame) {
                fcc.analyseImage(frame.flatten());
                fcc.drawChessboardCorners(frame);
            }
        });
    }

    public static enum Options {
        FILTER_QUADS,
        HISTOGRAM_EQUALISE,
        ADAPTIVE_THRESHOLD,
        FAST_CHECK;

    }

    private static final class Quad {
        int groupIdx = -1;
        Corner[] corners = new Corner[4];
        float minEdgeLength;
        int count;
        Quad[] neighbours = new Quad[4];
        boolean ordered;
        int row;
        int col;

        private Quad() {
        }
    }

    private static final class Corner
    extends Point2dImpl {
        int row;
        int count;
        Corner[] neighbours = new Corner[4];

        public Corner(Point2d point2d) {
            super(point2d);
        }

        FloatIntPair meanDist() {
            float sum = 0.0f;
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.neighbours[i] == null) continue;
                float dx = this.neighbours[i].x - this.x;
                float dy = this.neighbours[i].y - this.y;
                sum = (float)((double)sum + Math.sqrt(dx * dx + dy * dy));
                ++n;
            }
            return new FloatIntPair(sum / (float)Math.max(n, 1), n);
        }
    }
}

