/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.camera.calibration;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.contour.Contour;
import org.openimaj.image.contour.SuzukiContourProcessor;
import org.openimaj.image.processing.algorithm.FilterSupport;
import org.openimaj.image.processing.algorithm.MinMaxAnalyser;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.hershey.HersheyFont;
import org.openimaj.math.geometry.shape.RotatedRectangle;
import org.openimaj.util.pair.FloatIntPair;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayAdapter;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.capture.VideoCapture;

public class FastChessboardDetector
implements ImageAnalyser<FImage> {
    private static final float BLACK_LEVEL = 0.078431375f;
    private static final float WHITE_LEVEL = 0.50980395f;
    private static final float BLACK_WHITE_GAP = 0.27450982f;
    private static final float MIN_ASPECT_RATIO = 0.3f;
    private static final float MAX_ASPECT_RATIO = 3.0f;
    private static final float MIN_BOX_SIZE = 10.0f;
    private int patternHeight;
    private int patternWidth;
    private boolean result;

    public FastChessboardDetector(int patternWidth, int patternHeight) {
        this.patternWidth = patternWidth;
        this.patternHeight = patternHeight;
    }

    private void quickThresh(FImage in, FImage out, float thresh, boolean inverse) {
        boolean low = false;
        boolean high = true;
        if (inverse) {
            low = true;
            high = false;
        }
        for (int y = 0; y < in.height; ++y) {
            for (int x = 0; x < in.width; ++x) {
                out.pixels[y][x] = in.pixels[y][x] > thresh ? (float)low : (float)high;
            }
        }
    }

    public void analyseImage(FImage src) {
        FImage thresh = new FImage(src.width, src.height);
        MinMaxAnalyser mma = new MinMaxAnalyser(FilterSupport.BLOCK_3x3);
        src.analyseWith((ImageAnalyser)mma);
        FImage white = mma.min;
        FImage black = mma.max;
        this.result = false;
        block0: for (float threshLevel = 0.078431375f; threshLevel < 0.50980395f && !this.result; threshLevel += 0.078431375f) {
            ArrayList<FloatIntPair> quads = new ArrayList<FloatIntPair>();
            this.quickThresh(white, thresh, threshLevel + 0.27450982f, false);
            this.getQuadrangleHypotheses(SuzukiContourProcessor.findContours((FImage)thresh), quads, 1);
            this.quickThresh(black, thresh, threshLevel, true);
            this.getQuadrangleHypotheses(SuzukiContourProcessor.findContours((FImage)thresh), quads, 0);
            int minQuadsCount = this.patternWidth * this.patternHeight / 2;
            Collections.sort(quads, FloatIntPair.FIRST_ITEM_ASCENDING_COMPARATOR);
            float sizeRelDev = 0.4f;
            for (int i = 0; i < quads.size(); ++i) {
                int j;
                for (j = i + 1; j < quads.size() && !(((FloatIntPair)quads.get((int)j)).first / ((FloatIntPair)quads.get((int)i)).first > 1.4f); ++j) {
                }
                if (j + 1 <= minQuadsCount + i) continue;
                int[] counts = new int[2];
                this.countClasses(quads, i, j, counts);
                int blackCount = (int)Math.round(Math.ceil((double)this.patternWidth / 2.0) * Math.ceil((double)this.patternHeight / 2.0));
                int whiteCount = (int)Math.round(Math.floor((double)this.patternWidth / 2.0) * Math.floor((double)this.patternHeight / 2.0));
                if ((double)counts[0] < (double)blackCount * 0.75 || (double)counts[1] < (double)whiteCount * 0.75) continue;
                this.result = true;
                continue block0;
            }
        }
    }

    void countClasses(List<FloatIntPair> pairs, int idx1, int idx2, int[] counts) {
        for (int i = idx1; i != idx2; ++i) {
            int n = pairs.get((int)i).second;
            counts[n] = counts[n] + 1;
        }
    }

    void getQuadrangleHypotheses(Contour contours, List<FloatIntPair> quads, int classId) {
        for (Contour seq : contours.contourIterable()) {
            float aspectRatio;
            RotatedRectangle box = seq.minimumBoundingRectangle(true);
            float boxSize = Math.max(box.width, box.height);
            if (boxSize < 10.0f || (aspectRatio = box.width / Math.max(box.height, 1.0f)) < 0.3f || aspectRatio > 3.0f) continue;
            quads.add(new FloatIntPair(boxSize, classId));
        }
    }

    public boolean chessboardDetected() {
        return this.result;
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        final FastChessboardDetector fcd = new FastChessboardDetector(9, 6);
        final VideoDisplay vd = VideoDisplay.createVideoDisplay((Video)new VideoCapture(640, 480));
        vd.setCalculateFPS(true);
        vd.addVideoListener((VideoDisplayListener)new VideoDisplayAdapter<MBFImage>(){

            public void beforeUpdate(MBFImage frame) {
                fcd.analyseImage(frame.flatten());
                frame.drawText(fcd.result + "", 100, 100, (Font)HersheyFont.FUTURA_LIGHT, 20, (Object)RGBColour.RED);
                System.out.println(vd.getDisplayFPS());
            }
        });
    }
}

